/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.graphdrawing.graphml.reader.GraphMLParseContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.base.ListCell;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.io.gml.EdgeGraphicsParser;
import y.io.gml.EdgeLabelGraphicsEncoder;
import y.io.gml.EdgeRealizerObjectEncoder;
import y.io.gml.LabelGraphicsEncoder;
import y.io.gml.LabelGraphicsParser;
import y.io.gml.NodeLabelGraphicsEncoder;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;
import y.view.Arrow;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.LineType;
import y.view.NodeLabel;
import y.view.YLabel;
import yext.graphml.graph2D.A;

public class GraphicsSerializationToolkit {
    static final Map H = NodeLabelGraphicsEncoder.anchorEncoding;
    static final Map L = NodeLabelGraphicsEncoder.modelEncoding;
    static final Map P = EdgeLabelGraphicsEncoder.edgePosMap;
    static final Map I = EdgeLabelGraphicsEncoder.edgeModelMap;
    static final Map G = EdgeLabelGraphicsEncoder.edgePrefMap;
    static final Map B = new HashMap();
    static final Map D = LabelGraphicsParser.nodeLabelModelMap;
    static final Map E = LabelGraphicsParser.edgeLabelPosMap;
    static final Map A = LabelGraphicsParser.edgeLabelModelMap;
    static final Map F = LabelGraphicsParser.edgeLabelPrefMap;
    static boolean J = true;
    static boolean K = true;
    static boolean N = true;
    static boolean O = true;
    private static YList C;
    private static final int M = 32;

    public void printHeader(PrintStream printStream, String string, String string2) {
        printStream.println("<?xml version=\"1.0\"?>");
        printStream.println("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">");
    }

    public static void printText(IndentPrintWriter indentPrintWriter, String string, String string2) {
        if (string2 == null) {
            indentPrintWriter.println("<y:" + string + "/>");
            return;
        }
        if (string2.length() > 0) {
            indentPrintWriter.print("<" + string + ">");
            indentPrintWriter.print(string2);
            indentPrintWriter.println("</" + string + ">");
        } else {
            indentPrintWriter.println("<" + string + "/>");
        }
    }

    public static void printText(IndentPrintWriter indentPrintWriter, String string, Object object) {
        GraphicsSerializationToolkit.printText(indentPrintWriter, string, object.toString());
    }

    public static String codeLocation(YPoint yPoint) {
        if (yPoint == null) {
            return "";
        }
        return " x=\"" + yPoint.getX() + "\" y=\"" + yPoint.getY() + "\"";
    }

    public static String codeSize(YDimension yDimension) {
        if (yDimension == null) {
            return "";
        }
        return " width=\"" + yDimension.getWidth() + "\" height=\"" + yDimension.getHeight() + "\"";
    }

    public static void writeLocation(IndentPrintWriter indentPrintWriter, String string, YPoint yPoint) {
        if (yPoint == null) {
            return;
        }
        indentPrintWriter.println("<y:" + string + GraphicsSerializationToolkit.codeLocation(yPoint) + "/>");
    }

    public static void writePath(IndentPrintWriter indentPrintWriter, EdgeLayout edgeLayout) {
        if (edgeLayout == null) {
            return;
        }
        YPoint yPoint = edgeLayout.getSourcePoint();
        YPoint yPoint2 = edgeLayout.getTargetPoint();
        indentPrintWriter.print("<y:Path");
        indentPrintWriter.print(" sx=\"" + yPoint.getX() + "\" sy=\"" + yPoint.getY() + "\"");
        indentPrintWriter.print(" tx=\"" + yPoint2.getX() + "\" ty=\"" + yPoint2.getY() + "\"");
        if (edgeLayout.pointCount() == 0) {
            indentPrintWriter.println("/>");
        } else {
            indentPrintWriter.println(">");
            indentPrintWriter.increaseIndent();
            for (int i = 0; i < edgeLayout.pointCount(); ++i) {
                GraphicsSerializationToolkit.writeLocation(indentPrintWriter, "Point", edgeLayout.getPoint(i));
            }
            indentPrintWriter.decreaseIndent();
            indentPrintWriter.println("</y:Path>");
        }
    }

    public static void writeNodeLayout(IndentPrintWriter indentPrintWriter, NodeLayout nodeLayout) {
        indentPrintWriter.print("<y:Geometry ");
        indentPrintWriter.print(GraphicsSerializationToolkit.codeLocation(new YPoint(nodeLayout.getX(), nodeLayout.getY())));
        indentPrintWriter.print(GraphicsSerializationToolkit.codeSize(new YDimension(nodeLayout.getWidth(), nodeLayout.getHeight())));
        indentPrintWriter.println("/>");
    }

    public static void writeStyle(IndentPrintWriter indentPrintWriter, String string, LineType lineType, Color color) {
        String string2 = EdgeRealizerObjectEncoder.encodeLineStyle((byte)lineType.getLineStyle());
        indentPrintWriter.print("<y:" + string + " ");
        indentPrintWriter.print("type=\"" + string2 + "\" ");
        indentPrintWriter.print("width=\"" + lineType.getLineWidth() + "\" ");
        if (color != null) {
            GraphicsSerializationToolkit.writeColor(indentPrintWriter, "color", color);
        } else {
            indentPrintWriter.print("hasColor=\"false\" ");
        }
        indentPrintWriter.println("/>");
    }

    public static void writeArrows(IndentPrintWriter indentPrintWriter, String string, Arrow arrow, Arrow arrow2) {
        indentPrintWriter.print("<y:" + string + " source=\"" + EdgeRealizerObjectEncoder.encodeArrowType((Arrow)arrow) + "\"");
        indentPrintWriter.println(" target=\"" + EdgeRealizerObjectEncoder.encodeArrowType((Arrow)arrow2) + "\"/>");
    }

    public static void writeColor(IndentPrintWriter indentPrintWriter, String string, Color color) {
        int n;
        if (color == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(9);
        stringBuffer.append('#');
        String string2 = Integer.toHexString(color.getRed()).toUpperCase();
        for (n = 2 - string2.length(); n > 0; --n) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        string2 = Integer.toHexString(color.getGreen()).toUpperCase();
        for (n = 2 - string2.length(); n > 0; --n) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        string2 = Integer.toHexString(color.getBlue()).toUpperCase();
        for (n = 2 - string2.length(); n > 0; --n) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        if (color.getAlpha() != 255) {
            string2 = Integer.toHexString(color.getAlpha()).toUpperCase();
            for (n = 2 - string2.length(); n > 0; --n) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        indentPrintWriter.print(string + "=\"" + stringBuffer.toString() + "\" ");
    }

    public static void writeLabelContent(IndentPrintWriter indentPrintWriter, YLabel yLabel) {
        Icon icon;
        indentPrintWriter.print("x=\"" + yLabel.getOffsetX() + "\" y=\"" + yLabel.getOffsetY() + "\" ");
        indentPrintWriter.print("width=\"" + yLabel.getWidth() + "\" height=\"" + yLabel.getHeight() + "\" ");
        indentPrintWriter.print("visible=\"" + yLabel.isVisible() + "\" ");
        indentPrintWriter.print("alignment=\"" + LabelGraphicsEncoder.encodeAlignment((byte)yLabel.getAlignment()) + "\" ");
        indentPrintWriter.print("fontFamily=\"" + yLabel.getFontName() + "\" fontSize=\"" + yLabel.getFontSize() + "\" fontStyle=\"" + LabelGraphicsEncoder.encodeFontStyle((int)yLabel.getFontStyle()) + "\" ");
        GraphicsSerializationToolkit.writeColor(indentPrintWriter, "textColor", yLabel.getTextColor());
        if (yLabel.getBackgroundColor() != null) {
            GraphicsSerializationToolkit.writeColor(indentPrintWriter, "backgroundColor", yLabel.getBackgroundColor());
        }
        if (yLabel.getLineColor() != null) {
            GraphicsSerializationToolkit.writeColor(indentPrintWriter, "lineColor", yLabel.getLineColor());
        }
        if ((icon = yLabel.getIcon()) != null && icon instanceof A) {
            indentPrintWriter.print("icon=\"" + ((A)yLabel.getIcon()).A() + "\" ");
            if (O) {
                try {
                    indentPrintWriter.print("horizontalTextPosition=\"" + GraphicsSerializationToolkit.B(yLabel.getHorizontalTextPosition()) + "\" ");
                    indentPrintWriter.print("verticalTextPosition=\"" + GraphicsSerializationToolkit.A(yLabel.getVerticalTextPosition()) + "\" ");
                    indentPrintWriter.print("iconTextGap=\"" + yLabel.getIconTextGap() + "\" ");
                }
                catch (LinkageError linkageError) {
                    O = false;
                }
            }
        }
        if (J) {
            try {
                if (yLabel.getRotationAngle() != 0) {
                    indentPrintWriter.print("rotationAngle=\"" + yLabel.getRotationAngle() + "\" ");
                }
            }
            catch (LinkageError linkageError) {
                J = false;
            }
        }
        if (K) {
            try {
                if (yLabel.isUnderlinedTextEnabled()) {
                    indentPrintWriter.print("underlinedText=\"true\" ");
                }
            }
            catch (LinkageError linkageError) {
                K = false;
            }
        }
    }

    public static void writeNodeLabel(IndentPrintWriter indentPrintWriter, NodeLabel nodeLabel) {
        GraphicsSerializationToolkit.writeNodeLabel(indentPrintWriter, nodeLabel, "y:NodeLabel");
    }

    public static void writeNodeLabel(IndentPrintWriter indentPrintWriter, NodeLabel nodeLabel, String string) {
        indentPrintWriter.print("<" + string + ' ');
        GraphicsSerializationToolkit.writeLabelContent(indentPrintWriter, (YLabel)nodeLabel);
        indentPrintWriter.print("modelName=\"" + L.get(new Byte(nodeLabel.getModel())) + "\" ");
        indentPrintWriter.print("modelPosition=\"" + H.get(new Byte(nodeLabel.getPosition())) + "\" ");
        indentPrintWriter.print("autoSizePolicy=\"" + NodeLabelGraphicsEncoder.encodeAutoSizePolicy((byte)nodeLabel.getAutoSizePolicy()) + "\">");
        indentPrintWriter.setXmlConversionActive(true);
        indentPrintWriter.print(nodeLabel.getText());
        indentPrintWriter.setXmlConversionActive(false);
        indentPrintWriter.println("</" + string + '>');
    }

    public static void writeEdgeLabel(IndentPrintWriter indentPrintWriter, EdgeLabel edgeLabel) {
        Object v;
        String string;
        indentPrintWriter.print("<y:EdgeLabel ");
        GraphicsSerializationToolkit.writeLabelContent(indentPrintWriter, (YLabel)edgeLabel);
        String string2 = (String)I.get(new Byte(edgeLabel.getModel()));
        if (string2 != null) {
            indentPrintWriter.print("modelName=\"" + string2 + "\" ");
        }
        if ((string = (String)P.get(new Byte(edgeLabel.getPosition()))) != null) {
            indentPrintWriter.print("modelPosition=\"" + string + "\" ");
        }
        if ((v = G.get(new Byte(edgeLabel.getPreferredPlacement()))) != null) {
            indentPrintWriter.print("preferredPlacement=\"" + v + "\" ");
        }
        indentPrintWriter.print("distance=\"" + edgeLabel.getDistance() + "\" ");
        indentPrintWriter.print("ratio=\"" + edgeLabel.getRatio() + "\">");
        indentPrintWriter.setXmlConversionActive(true);
        indentPrintWriter.print(edgeLabel.getText());
        indentPrintWriter.setXmlConversionActive(false);
        indentPrintWriter.println("</y:EdgeLabel>");
    }

    public static void writeInsets(IndentPrintWriter indentPrintWriter, String string, Insets insets) {
        indentPrintWriter.println("<y:" + string + " top=\"" + insets.top + "\" bottom=\"" + insets.bottom + "\" left=\"" + insets.left + "\" right=\"" + insets.right + "\"/>");
    }

    private static URL A(GraphMLParseContext graphMLParseContext) {
        if (graphMLParseContext == null) {
            return null;
        }
        List list = graphMLParseContext.getContainers();
        try {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object e = list.get(i);
                if (!(e instanceof Graph2D)) continue;
                return ((Graph2D)e).getURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Icon A(String string, URL uRL) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL2 = new URL(uRL, string);
            }
            catch (Exception exception) {
                System.err.println("Cannot load image from: " + string);
                exception.printStackTrace();
            }
        }
        return new A(uRL2, string);
    }

    public static String parseText(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                stringBuffer.append(node2.getNodeValue());
            }
        }
        return stringBuffer.toString();
    }

    public static String getID(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("id")) continue;
            string = node2.getNodeValue();
        }
        return string;
    }

    public static String getREF(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("ref")) continue;
            string = node2.getNodeValue();
        }
        return string;
    }

    public static Insets parseInsets(Node node) {
        Insets insets = new Insets(0, 0, 0, 0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("top");
        if (node2 != null) {
            insets.top = Integer.parseInt(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("bottom")) != null) {
            insets.bottom = Integer.parseInt(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("left")) != null) {
            insets.left = Integer.parseInt(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("right")) != null) {
            insets.right = Integer.parseInt(node2.getNodeValue());
        }
        return insets;
    }

    public static EdgeLayout parseEdgeLayout(Node node) {
        DefaultEdgeLayout defaultEdgeLayout = new DefaultEdgeLayout();
        GraphicsSerializationToolkit.parsePath(node, (EdgeLayout)defaultEdgeLayout);
        return defaultEdgeLayout;
    }

    public static NodeLayout parseNodeLayout(Node node) {
        DefaultNodeLayout defaultNodeLayout = new DefaultNodeLayout();
        GraphicsSerializationToolkit.parseNodeLayout(node, (NodeLayout)defaultNodeLayout);
        return defaultNodeLayout;
    }

    public static void parseNodeLayout(Node node, NodeLayout nodeLayout) {
        NodeList nodeList = node.getChildNodes();
        double d = nodeLayout.getX();
        double d2 = nodeLayout.getY();
        double d3 = nodeLayout.getWidth();
        double d4 = nodeLayout.getHeight();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("height")) != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        if (d3 != nodeLayout.getWidth() || d4 != nodeLayout.getHeight()) {
            nodeLayout.setSize(d3, d4);
        }
        if (d != nodeLayout.getX() || d2 != nodeLayout.getY()) {
            nodeLayout.setLocation(d, d2);
        }
    }

    public static void parsePath(Node node, EdgeLayout edgeLayout) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("sx");
        if (node2 != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("sy")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("tx")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("ty")) != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        edgeLayout.setSourcePoint(new YPoint(d, d2));
        edgeLayout.setTargetPoint(new YPoint(d3, d4));
        edgeLayout.clearPoints();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || !(string = node3.getLocalName()).equals("Point")) continue;
                YPoint yPoint = GraphicsSerializationToolkit.parseLocation(node3);
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            }
        }
    }

    public static YPoint parseLocation(Node node) {
        NodeList nodeList = node.getChildNodes();
        double d = 0.0;
        double d2 = 0.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        return new YPoint(d, d2);
    }

    public static YDimension parseSize(Node node) {
        NodeList nodeList = node.getChildNodes();
        double d = 0.0;
        double d2 = 0.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("width");
        if (node2 != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("height")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        return new YDimension(d, d2);
    }

    public static boolean parseBool(Node node) {
        return new Boolean(GraphicsSerializationToolkit.parseText(node));
    }

    public static LineType parseLineType(Node node) {
        String string = "line";
        double d = 1.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("type");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        return LineType.getLineType((int)((int)d), (byte)EdgeGraphicsParser.decodeLineStyle((String)string));
    }

    public static Arrow parseArrow(Node node, String string) {
        Arrow arrow = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            arrow = EdgeGraphicsParser.decodeArrow((String)node2.getNodeValue());
        }
        if (arrow == null) {
            arrow = Arrow.NONE;
        }
        return arrow;
    }

    public static void parseLabel(Node node, YLabel yLabel) {
        GraphicsSerializationToolkit.A(node, yLabel, null);
    }

    static void A(Node node, YLabel yLabel, GraphMLParseContext graphMLParseContext) {
        yLabel.setText(GraphicsSerializationToolkit.parseText(node));
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("w")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("h")) != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
            yLabel.setSize(d3, d4);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            yLabel.setOffset(d, d2);
        }
        if ((node2 = namedNodeMap.getNamedItem("visible")) != null) {
            yLabel.setVisible(Boolean.valueOf(node2.getNodeValue()).booleanValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("alignment")) != null) {
            yLabel.setAlignment(LabelGraphicsParser.decodeAlignment((String)node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("textColor")) != null) {
            yLabel.setTextColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("backgroundColor")) != null) {
            yLabel.setBackgroundColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("lineColor")) != null) {
            yLabel.setLineColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("fontFamily")) != null) {
            yLabel.setFontName(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("fontSize")) != null) {
            yLabel.setFontSize(Integer.parseInt(node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("fontStyle")) != null) {
            yLabel.setFontStyle(LabelGraphicsParser.decodeFontStyle((String)node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("icon")) != null) {
            yLabel.setIcon(GraphicsSerializationToolkit.A(node2.getNodeValue(), GraphicsSerializationToolkit.A(graphMLParseContext)));
        }
        if (O) {
            try {
                node2 = namedNodeMap.getNamedItem("horizontalTextPosition");
                if (node2 != null) {
                    yLabel.setHorizontalTextPosition(GraphicsSerializationToolkit.B(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("verticalTextPosition")) != null) {
                    yLabel.setVerticalTextPosition(GraphicsSerializationToolkit.A(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("iconTextGap")) != null) {
                    yLabel.setIconTextGap(Byte.parseByte(node2.getNodeValue()));
                }
            }
            catch (LinkageError linkageError) {
                O = false;
            }
        }
        if (J) {
            try {
                node2 = namedNodeMap.getNamedItem("rotationAngle");
                if (node2 != null) {
                    yLabel.setRotationAngle(Integer.parseInt(node2.getNodeValue()));
                }
            }
            catch (LinkageError linkageError) {
                J = false;
            }
        }
        if (K) {
            try {
                node2 = namedNodeMap.getNamedItem("underlinedText");
                if (node2 != null) {
                    yLabel.setUnderlinedTextEnabled(Boolean.valueOf(node2.getNodeValue()).booleanValue());
                }
            }
            catch (LinkageError linkageError) {
                K = false;
            }
        }
    }

    public static void parseNodeLabel(Node node, NodeLabel nodeLabel) {
        GraphicsSerializationToolkit.A(node, nodeLabel, null);
    }

    static void A(Node node, NodeLabel nodeLabel, GraphMLParseContext graphMLParseContext) {
        Object v;
        GraphicsSerializationToolkit.A(node, (YLabel)nodeLabel, graphMLParseContext);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("autoSizePolicy");
        if (node2 != null) {
            nodeLabel.setAutoSizePolicy(LabelGraphicsParser.decodeAutoSizePolicy((String)node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("modelName")) != null && (v = D.get(node2.getNodeValue())) instanceof Byte) {
            nodeLabel.setModel(((Byte)v).byteValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("modelPosition")) != null && (v = B.get(node2.getNodeValue())) instanceof Byte) {
            nodeLabel.setPosition(((Byte)v).byteValue());
        }
    }

    public static void parseEdgeLabel(Node node, EdgeLabel edgeLabel) {
        GraphicsSerializationToolkit.A(node, edgeLabel, null);
    }

    static void A(Node node, EdgeLabel edgeLabel, GraphMLParseContext graphMLParseContext) {
        Object object;
        GraphicsSerializationToolkit.A(node, (YLabel)edgeLabel, graphMLParseContext);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("modelName");
        if (node2 != null && (object = A.get(node2.getNodeValue())) instanceof Byte) {
            edgeLabel.setModel(((Byte)object).byteValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("modelPosition")) != null && (object = E.get(node2.getNodeValue())) instanceof Byte) {
            edgeLabel.setPosition(((Byte)object).byteValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("preferredPlacement")) != null && (object = F.get(node2.getNodeValue())) instanceof Byte) {
            edgeLabel.setPreferredPlacement(((Byte)object).byteValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("distance")) != null) {
            edgeLabel.setDistance(Double.parseDouble(node2.getNodeValue()));
        }
        if ((node2 = namedNodeMap.getNamedItem("ratio")) != null) {
            edgeLabel.setRatio(Double.parseDouble(node2.getNodeValue()));
        }
        switch (edgeLabel.getModel()) {
            case 5: 
            case 6: {
                double d;
                Point2D point2D;
                double d2;
                Object object2;
                EdgeRealizer edgeRealizer;
                object = namedNodeMap.getNamedItem("x");
                Node node3 = namedNodeMap.getNamedItem("y");
                if (object == null || node3 == null || (edgeRealizer = edgeLabel.getOwner()) == null || (object2 = edgeLabel.getBestModelParameterForLocation(d2 = (point2D = edgeRealizer.getSourceIntersection()).getX() + Double.parseDouble(object.getNodeValue()), d = point2D.getY() + Double.parseDouble(node3.getNodeValue()))) == null) break;
                edgeLabel.setModelParameter(object2);
            }
        }
    }

    public static Color parseColor(String string) {
        Color color;
        Object object;
        int n;
        int n2;
        if (string.length() < 1 || string.charAt(0) != '#') {
            return Color.BLACK;
        }
        if (string.length() > 7) {
            n2 = Integer.parseInt(string.substring(1, 7), 16);
            n = Integer.parseInt(string.substring(7), 16);
            n2 += (n & 0xFF) << 24;
        } else {
            n = Integer.parseInt(string.substring(1), 16);
            n2 = n + -16777216;
        }
        for (object = C.firstCell(); object != null; object = object.succ()) {
            color = (Color)object.getInfo();
            if (color.getRGB() != n2) continue;
            C.removeCell(object);
            C.addFirstCell(object);
            return color;
        }
        object = new Color(n2, true);
        if (C.size() >= 32) {
            color = C.lastCell();
            C.removeCell((ListCell)color);
            color.setInfo(object);
            C.addFirstCell((ListCell)color);
        } else {
            C.addFirst(object);
        }
        return object;
    }

    public static String getAttr(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2.getNodeValue();
        }
        return null;
    }

    private static byte B(String string) {
        if (string.equals("left")) {
            return 8;
        }
        if (string.equals("right")) {
            return 16;
        }
        if (string.equals("left_aligned")) {
            return 32;
        }
        if (string.equals("right_aligned")) {
            return 64;
        }
        return 2;
    }

    private static byte A(String string) {
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("center")) {
            return 2;
        }
        return 4;
    }

    private static String B(byte by) {
        switch (by) {
            case 8: {
                return "left";
            }
            case 16: {
                return "right";
            }
            case 2: {
                return "center";
            }
            case 32: {
                return "left_aligned";
            }
            case 64: {
                return "right_aligned";
            }
        }
        return "center";
    }

    private static String A(byte by) {
        switch (by) {
            case 1: {
                return "top";
            }
            case 4: {
                return "bottom";
            }
        }
        return "bottom";
    }

    static {
        B.put("n", new Byte(108));
        B.put("nw", new Byte(104));
        B.put("ne", new Byte(105));
        B.put("w", new Byte(111));
        B.put("e", new Byte(110));
        B.put("sw", new Byte(107));
        B.put("s", new Byte(109));
        B.put("se", new Byte(106));
        B.put("c", new Byte(100));
        B.put("t", new Byte(102));
        B.put("tl", new Byte(117));
        B.put("tr", new Byte(118));
        B.put("r", new Byte(116));
        B.put("l", new Byte(115));
        B.put("bl", new Byte(119));
        B.put("b", new Byte(101));
        B.put("br", new Byte(120));
        B.put("anywhere", new Byte(114));
        B.put("dynamic", new Byte(112));
        C = new YList();
        C.add((Object)Color.BLACK);
        C.add((Object)Color.RED);
        C.add((Object)Color.BLUE);
        C.add((Object)Color.YELLOW);
        C.add((Object)Color.GREEN);
        C.add((Object)Color.WHITE);
    }
}

