/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.util.HashMap;
import java.util.Map;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import y.base.Edge;
import y.base.Graph;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import yext.graphml.graph2D.EdgeRealizerSerializer;
import yext.graphml.writer.AbstractOutputHandler;

public class WriteEdgeRealizerHandler
extends AbstractOutputHandler {
    protected static Map edgeRealizerSerializers = new HashMap();

    public static void addEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        edgeRealizerSerializers.put(edgeRealizerSerializer.getRealizerClass().getName(), edgeRealizerSerializer);
    }

    public String getKeyAttributes(GraphMLWriteContext graphMLWriteContext) {
        return "yfiles.type=\"edgegraphics\"";
    }

    public void printKeyOutput(GraphMLWriteContext graphMLWriteContext, IndentPrintWriter indentPrintWriter) {
    }

    public void printDataOutput(GraphMLWriteContext graphMLWriteContext, Graph graph, Object object, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.println();
        WriteEdgeRealizerHandler.writeRealizer(((Graph2D)graph).getRealizer((Edge)object), indentPrintWriter, graphMLWriteContext);
    }

    public static void writeRealizer(EdgeRealizer edgeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        EdgeRealizerSerializer edgeRealizerSerializer = (EdgeRealizerSerializer)edgeRealizerSerializers.get(edgeRealizer.getClass().getName());
        if (edgeRealizerSerializer == null) {
            System.err.println("Realizer not recognized: " + edgeRealizer.getClass().getName());
        } else {
            indentPrintWriter.increaseIndent();
            String string = edgeRealizerSerializer.getName();
            int n = string.indexOf(58);
            if (n < 0) {
                string = "y:" + string;
            } else if (n == 0) {
                string = string.substring(1);
            }
            indentPrintWriter.print("<" + string + " ");
            edgeRealizerSerializer.writeAttributes(edgeRealizer, indentPrintWriter, graphMLWriteContext);
            indentPrintWriter.println(">");
            indentPrintWriter.increaseIndent();
            edgeRealizerSerializer.write(edgeRealizer, indentPrintWriter, graphMLWriteContext);
            indentPrintWriter.decreaseIndent();
            indentPrintWriter.println("</" + string + ">");
            indentPrintWriter.decreaseIndent();
        }
    }
}

