/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.util.HashMap;
import java.util.Map;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeRealizer;
import yext.graphml.graph2D.NodeRealizerSerializer;
import yext.graphml.writer.AbstractOutputHandler;

public class WriteNodeRealizerHandler
extends AbstractOutputHandler {
    protected static Map nodeRealizerSerializers = new HashMap();

    public static void addNodeRealizerSerializer(NodeRealizerSerializer nodeRealizerSerializer) {
        nodeRealizerSerializers.put(nodeRealizerSerializer.getRealizerClass().getName(), nodeRealizerSerializer);
    }

    public String getKeyAttributes(GraphMLWriteContext graphMLWriteContext) {
        return "yfiles.type=\"nodegraphics\"";
    }

    public void printKeyOutput(GraphMLWriteContext graphMLWriteContext, IndentPrintWriter indentPrintWriter) {
    }

    public void printDataOutput(GraphMLWriteContext graphMLWriteContext, Graph graph, Object object, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.println();
        NodeRealizer nodeRealizer = ((Graph2D)graph).getRealizer((Node)object);
        WriteNodeRealizerHandler.writeRealizer(nodeRealizer, indentPrintWriter, graphMLWriteContext);
    }

    public static void writeRealizer(NodeRealizer nodeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        NodeRealizerSerializer nodeRealizerSerializer = (NodeRealizerSerializer)nodeRealizerSerializers.get(nodeRealizer.getClass().getName());
        if (nodeRealizerSerializer == null) {
            System.err.println("Realizer not recognized: " + nodeRealizer.getClass().getName());
        } else {
            indentPrintWriter.increaseIndent();
            String string = nodeRealizerSerializer.getName();
            int n = string.indexOf(58);
            if (n < 0) {
                string = "y:" + string;
            } else if (n == 0) {
                string = string.substring(1);
            }
            indentPrintWriter.print("<" + string + " ");
            nodeRealizerSerializer.writeAttributes(nodeRealizer, indentPrintWriter, graphMLWriteContext);
            indentPrintWriter.println(">");
            indentPrintWriter.increaseIndent();
            nodeRealizerSerializer.write(nodeRealizer, indentPrintWriter, graphMLWriteContext);
            indentPrintWriter.decreaseIndent();
            indentPrintWriter.println("</" + string + ">");
            indentPrintWriter.decreaseIndent();
        }
    }
}

