/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.awt.Color;
import java.io.PrintStream;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;
import y.view.Arrow;
import y.view.LineType;
import y.view.YLabel;

public class XMLTools {
    public void printHeader(PrintStream printStream, String string, String string2) {
        printStream.println("<?xml version=\"1.0\"?>");
        printStream.println("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">");
    }

    public static void printText(IndentPrintWriter indentPrintWriter, String string, String string2) {
        if (string2 == null) {
            indentPrintWriter.println("<" + string + "/>");
            return;
        }
        if (string2.length() > 0) {
            indentPrintWriter.print("<" + string + ">");
            indentPrintWriter.print(string2);
            indentPrintWriter.println("</" + string + ">");
        } else {
            indentPrintWriter.println("<" + string + "/>");
        }
    }

    public static void printText(IndentPrintWriter indentPrintWriter, String string, Object object) {
        XMLTools.printText(indentPrintWriter, string, object.toString());
    }

    public static void writePath(IndentPrintWriter indentPrintWriter, YPointPath yPointPath) {
        if (yPointPath == null) {
            return;
        }
        indentPrintWriter.println("<Path>");
        YPointCursor yPointCursor = yPointPath.points();
        while (yPointCursor.ok()) {
            indentPrintWriter.increaseIndent();
            XMLTools.writeLocation(indentPrintWriter, yPointCursor.point());
            indentPrintWriter.decreaseIndent();
            yPointCursor.next();
        }
        indentPrintWriter.println("</Path>");
    }

    public static void writeEdgeLayout(IndentPrintWriter indentPrintWriter, EdgeLayout edgeLayout) {
        indentPrintWriter.println("<EdgeLayout>");
        indentPrintWriter.increaseIndent();
        indentPrintWriter.println("<SourcePort>");
        indentPrintWriter.increaseIndent();
        XMLTools.writeLocation(indentPrintWriter, edgeLayout.getSourcePoint());
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</SourcePort>");
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("<Path>");
        indentPrintWriter.increaseIndent();
        for (int i = 0; i < edgeLayout.pointCount(); ++i) {
            XMLTools.writeLocation(indentPrintWriter, edgeLayout.getPoint(i));
        }
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</Path>");
        indentPrintWriter.println("<TargetPort>");
        indentPrintWriter.increaseIndent();
        XMLTools.writeLocation(indentPrintWriter, edgeLayout.getTargetPoint());
        indentPrintWriter.println("</TargetPort>");
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</EdgeLayout>");
    }

    public static void writeNodeLayout(IndentPrintWriter indentPrintWriter, NodeLayout nodeLayout) {
        indentPrintWriter.println("<NodeLayout>");
        indentPrintWriter.increaseIndent();
        XMLTools.writeLocation(indentPrintWriter, new YPoint(nodeLayout.getX(), nodeLayout.getY()));
        XMLTools.writeSize(indentPrintWriter, new YDimension(nodeLayout.getWidth(), nodeLayout.getHeight()));
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</NodeLayout>");
    }

    public static void writeLocation(IndentPrintWriter indentPrintWriter, YPoint yPoint) {
        if (yPoint == null) {
            return;
        }
        indentPrintWriter.println("<Location>");
        indentPrintWriter.increaseIndent();
        indentPrintWriter.println("<X>" + yPoint.getX() + "</X>");
        indentPrintWriter.println("<Y>" + yPoint.getY() + "</Y>");
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</Location>");
    }

    public static void writeSize(IndentPrintWriter indentPrintWriter, YDimension yDimension) {
        if (yDimension == null) {
            return;
        }
        indentPrintWriter.println("<Size>");
        indentPrintWriter.increaseIndent();
        indentPrintWriter.println("<Width>" + yDimension.getWidth() + "</Width>");
        indentPrintWriter.println("<Height>" + yDimension.getHeight() + "</Height>");
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</Size>");
    }

    public static void writeColor(IndentPrintWriter indentPrintWriter, Color color) {
        indentPrintWriter.println("<Color r=\"" + color.getRed() + "\" g=\"" + color.getGreen() + "\" b=\"" + color.getBlue() + "\" />");
    }

    public static void writeLineType(IndentPrintWriter indentPrintWriter, LineType lineType) {
        String string = "line1";
        if (lineType == LineType.LINE_1) {
            string = "line1";
        }
        if (lineType == LineType.LINE_2) {
            string = "line2";
        }
        if (lineType == LineType.LINE_3) {
            string = "line3";
        }
        if (lineType == LineType.LINE_4) {
            string = "line4";
        }
        if (lineType == LineType.LINE_5) {
            string = "line5";
        }
        if (lineType == LineType.DASHED_1) {
            string = "dashed1";
        }
        if (lineType == LineType.DASHED_2) {
            string = "dashed2";
        }
        if (lineType == LineType.DASHED_3) {
            string = "dashed3";
        }
        if (lineType == LineType.DASHED_4) {
            string = "dashed4";
        }
        if (lineType == LineType.DASHED_5) {
            string = "dashed5";
        }
        indentPrintWriter.println("<LineType type=\"" + string + "\"/>");
    }

    public static void writeArrow(IndentPrintWriter indentPrintWriter, Arrow arrow) {
        indentPrintWriter.println("<Arrow type=\"" + arrow.getType() + "\"/>");
    }

    public static void writeLabel(IndentPrintWriter indentPrintWriter, YLabel yLabel) {
        indentPrintWriter.println("<Label>");
        indentPrintWriter.increaseIndent();
        indentPrintWriter.print("<Text>");
        indentPrintWriter.setXmlConversionActive(true);
        indentPrintWriter.print(yLabel.getText());
        indentPrintWriter.setXmlConversionActive(false);
        indentPrintWriter.println("</Text>");
        indentPrintWriter.println("<Model value=\"" + yLabel.getModel() + "\"/>");
        indentPrintWriter.println("<Position value=\"" + yLabel.getPosition() + "\"/>");
        indentPrintWriter.println("<Visible value=\"" + yLabel.isVisible() + "\"/>");
        indentPrintWriter.println("<Alignment value=\"" + yLabel.getAlignment() + "\"/>");
        XMLTools.writeColor(indentPrintWriter, yLabel.getTextColor());
        indentPrintWriter.println("<Background value=\"" + yLabel.isBackgroundOn() + "\"/>");
        indentPrintWriter.println("<FontName value=\"" + yLabel.getFontName() + "\"/>");
        indentPrintWriter.println("<FontSize value=\"" + yLabel.getFontSize() + "\"/>");
        indentPrintWriter.println("<FontStyle value=\"" + yLabel.getFontStyle() + "\"/>");
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</Label>");
    }

    public static String parseText(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                stringBuffer.append(node2.getNodeValue());
            }
        }
        return stringBuffer.toString();
    }

    public static String getID(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("id")) continue;
            string = node2.getNodeValue();
        }
        return string;
    }

    public static String getREF(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("ref")) continue;
            string = node2.getNodeValue();
        }
        return string;
    }

    public static EdgeLayout parseEdgeLayout(Node node) {
        DefaultEdgeLayout defaultEdgeLayout = new DefaultEdgeLayout();
        XMLTools.parseEdgeLayout(node, (EdgeLayout)defaultEdgeLayout);
        return defaultEdgeLayout;
    }

    public static void parseEdgeLayout(Node node, EdgeLayout edgeLayout) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("SourcePort")) {
                    XMLTools.parseSourcePort(node2, edgeLayout);
                }
                if (string.equals("Path")) {
                    XMLTools.parsePath(node2, edgeLayout);
                }
                if (!string.equals("TargetPort")) continue;
                XMLTools.parseTargetPort(node2, edgeLayout);
            }
        }
    }

    public static NodeLayout parseNodeLayout(Node node) {
        DefaultNodeLayout defaultNodeLayout = new DefaultNodeLayout();
        XMLTools.parseNodeLayout(node, (NodeLayout)defaultNodeLayout);
        return defaultNodeLayout;
    }

    public static void parseNodeLayout(Node node, NodeLayout nodeLayout) {
        NodeList nodeList = node.getChildNodes();
        YPoint yPoint = null;
        YDimension yDimension = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("Location")) {
                    yPoint = XMLTools.parseLocation(node2);
                }
                if (!string.equals("Size")) continue;
                yDimension = XMLTools.parseSize(node2);
            }
        }
        if (yDimension != null) {
            nodeLayout.setSize(yDimension.getWidth(), yDimension.getHeight());
        }
        if (yPoint != null) {
            nodeLayout.setLocation(yPoint.getX(), yPoint.getY());
        }
    }

    public static void parsePath(Node node, EdgeLayout edgeLayout) {
        edgeLayout.clearPoints();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !(string = node2.getLocalName()).equals("Location")) continue;
                YPoint yPoint = XMLTools.parseLocation(node2);
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            }
        }
    }

    public static void parseTargetPort(Node node, EdgeLayout edgeLayout) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !(string = node2.getLocalName()).equals("Location")) continue;
                edgeLayout.setTargetPoint(XMLTools.parseLocation(node2));
            }
        }
    }

    public static void parseSourcePort(Node node, EdgeLayout edgeLayout) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !(string = node2.getLocalName()).equals("Location")) continue;
                edgeLayout.setSourcePoint(XMLTools.parseLocation(node2));
            }
        }
    }

    public static YPoint parseLocation(Node node) {
        NodeList nodeList = node.getChildNodes();
        double d = 0.0;
        double d2 = 0.0;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("X")) {
                    d = Double.parseDouble(XMLTools.parseText(node2));
                }
                if (!string.equals("Y")) continue;
                d2 = Double.parseDouble(XMLTools.parseText(node2));
            }
        }
        return new YPoint(d, d2);
    }

    public static YDimension parseSize(Node node) {
        NodeList nodeList = node.getChildNodes();
        double d = 0.0;
        double d2 = 0.0;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("Width")) {
                    d = Double.parseDouble(XMLTools.parseText(node2));
                }
                if (!string.equals("Height")) continue;
                d2 = Double.parseDouble(XMLTools.parseText(node2));
            }
        }
        return new YDimension(d, d2);
    }

    public static boolean parseBool(Node node) {
        return new Boolean(XMLTools.parseText(node));
    }

    public static Color parseColor(Node node) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().equals("r")) {
                n = Integer.parseInt(node2.getNodeValue());
            }
            if (node2.getNodeName().equals("g")) {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            if (!node2.getNodeName().equals("b")) continue;
            n3 = Integer.parseInt(node2.getNodeValue());
        }
        return new Color(n, n2, n3);
    }

    public static LineType parseLineType(Node node) {
        String string = "line1";
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("type")) continue;
            string = node2.getNodeValue();
        }
        if (string.equals("line1")) {
            return LineType.LINE_1;
        }
        if (string.equals("line2")) {
            return LineType.LINE_2;
        }
        if (string.equals("line3")) {
            return LineType.LINE_3;
        }
        if (string.equals("line4")) {
            return LineType.LINE_4;
        }
        if (string.equals("line5")) {
            return LineType.LINE_5;
        }
        if (string.equals("dashed1")) {
            return LineType.DASHED_1;
        }
        if (string.equals("dashed2")) {
            return LineType.DASHED_2;
        }
        if (string.equals("dashed3")) {
            return LineType.DASHED_3;
        }
        if (string.equals("dashed4")) {
            return LineType.DASHED_4;
        }
        if (string.equals("dashed5")) {
            return LineType.DASHED_5;
        }
        return LineType.LINE_1;
    }

    public static Arrow parseArrow(Node node) {
        int n = 0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals("type")) continue;
            n = Integer.parseInt(node2.getNodeValue());
        }
        return Arrow.getArrow((byte)((byte)n));
    }

    public static void parseLabel(Node node, YLabel yLabel) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("Text")) {
                    yLabel.setText(XMLTools.parseText(node2));
                }
                if (string.equals("Position")) {
                    yLabel.setPosition((byte)Integer.parseInt(XMLTools.getAttr(node2, "value")));
                }
                if (string.equals("Model")) {
                    yLabel.setModel((byte)Integer.parseInt(XMLTools.getAttr(node2, "value")));
                }
                if (string.equals("Alignment")) {
                    yLabel.setAlignment((byte)Integer.parseInt(XMLTools.getAttr(node2, "value")));
                }
                if (string.equals("FontName")) {
                    yLabel.setFontName(XMLTools.getAttr(node2, "value"));
                }
                if (string.equals("FontSize")) {
                    yLabel.setFontSize(Integer.parseInt(XMLTools.getAttr(node2, "value")));
                }
                if (string.equals("FontStyle")) {
                    yLabel.setFontStyle(Integer.parseInt(XMLTools.getAttr(node2, "value")));
                }
                if (string.equals("Color")) {
                    yLabel.setTextColor(XMLTools.parseColor(node2));
                }
                if (string.equals("Visible")) {
                    yLabel.setVisible(new Boolean(XMLTools.getAttr(node2, "value")).booleanValue());
                }
                if (!string.equals("Background")) continue;
                yLabel.setBackground(new Boolean(XMLTools.getAttr(node2, "value")).booleanValue());
            }
        }
    }

    public static String getAttr(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2.getNodeValue();
        }
        return null;
    }
}

