/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.util.ArrayList;
import org.graphdrawing.graphml.writer.GraphElementProvider;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.view.hierarchy.HierarchyManager;
import yext.graphml.writer.YGraphElementProvider;

public class YHierarchyGraphElementProvider
extends YGraphElementProvider {
    protected HierarchyManager hierarchyManager;

    public YHierarchyGraphElementProvider(Graph graph) {
        super(graph);
    }

    protected YHierarchyGraphElementProvider(Node node, HierarchyManager hierarchyManager) {
        this.init(node, hierarchyManager);
    }

    protected void init(Graph graph) {
        this.graph = graph;
        this.hierarchyManager = HierarchyManager.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(graph.N());
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (this.hierarchyManager.getParentNode(node) == null) {
                arrayList.add(node);
            }
            nodeCursor.next();
        }
        this.nodes = new Node[arrayList.size()];
        arrayList.toArray(this.nodes);
        this.edges = graph.getEdgeArray();
    }

    protected void init(Node node, HierarchyManager hierarchyManager) {
        this.hierarchyManager = hierarchyManager;
        if (hierarchyManager.isFolderNode(node)) {
            this.graph = hierarchyManager.getInnerGraph(node);
            this.edges = this.graph.getEdgeArray();
        } else {
            this.graph = node.getGraph();
            this.edges = new Edge[0];
        }
        NodeCursor nodeCursor = hierarchyManager.getChildren(node);
        this.nodes = new Node[nodeCursor.size()];
        int n = 0;
        while (nodeCursor.ok()) {
            this.nodes[n++] = nodeCursor.node();
            nodeCursor.next();
        }
    }

    public GraphElementProvider getNodeSubgraph(Object object) {
        Node node = (Node)object;
        if (!this.hierarchyManager.isNormalNode(node)) {
            return new YHierarchyGraphElementProvider(node, this.hierarchyManager);
        }
        return null;
    }

    public Object getSourceNode(Object object) {
        Edge edge = (Edge)object;
        if (this.hierarchyManager.isInterEdge(edge)) {
            return this.hierarchyManager.getRealSource(edge);
        }
        return super.getSourceNode(edge);
    }

    public Object getTargetNode(Object object) {
        Edge edge = (Edge)object;
        if (this.hierarchyManager.isInterEdge(edge)) {
            return this.hierarchyManager.getRealTarget(edge);
        }
        return super.getTargetNode(edge);
    }
}

