/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import y.base.Edge;
import y.base.Graph;
import y.layout.EdgeLayout;
import y.view.ArcEdgeRealizer;
import y.view.BezierEdgeRealizer;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.PolyLineEdgeRealizer;
import y.view.SplineEdgeRealizer;
import y.view.YLabel;
import yext.graphml.graph2D.XMLTools;
import yext.graphml.writer.AbstractOutputHandler;

public class YWriteEdgeHandler
extends AbstractOutputHandler {
    public String getId() {
        return "yfiles.edgedata";
    }

    public String getKeyAttributes(GraphMLWriteContext graphMLWriteContext) {
        return "yfiles.type=\"edgedata\"";
    }

    public void printKeyOutput(GraphMLWriteContext graphMLWriteContext, IndentPrintWriter indentPrintWriter) {
    }

    public void printDataOutput(GraphMLWriteContext graphMLWriteContext, Graph graph, Object object, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.println();
        this.write(indentPrintWriter, ((Graph2D)graph).getRealizer((Edge)object));
    }

    public void write(IndentPrintWriter indentPrintWriter, EdgeRealizer edgeRealizer) {
        XMLTools.writeEdgeLayout(indentPrintWriter, (EdgeLayout)edgeRealizer);
        XMLTools.writeColor(indentPrintWriter, edgeRealizer.getLineColor());
        XMLTools.writeLineType(indentPrintWriter, edgeRealizer.getLineType());
        this.writeCurveType(indentPrintWriter, edgeRealizer);
        this.writeSourceArrow(indentPrintWriter, edgeRealizer);
        this.writeTargetArrow(indentPrintWriter, edgeRealizer);
        for (int i = 0; i < edgeRealizer.labelCount(); ++i) {
            XMLTools.writeLabel(indentPrintWriter, (YLabel)edgeRealizer.getLabel(i));
        }
    }

    protected void writeCurveType(IndentPrintWriter indentPrintWriter, EdgeRealizer edgeRealizer) {
        String string = "Polyline";
        if (edgeRealizer instanceof PolyLineEdgeRealizer) {
            PolyLineEdgeRealizer polyLineEdgeRealizer = (PolyLineEdgeRealizer)edgeRealizer;
            string = polyLineEdgeRealizer.getSmoothedBends() ? "SmoothPolyline" : "Polyline";
        }
        if (edgeRealizer instanceof ArcEdgeRealizer) {
            string = "Arc";
        }
        if (edgeRealizer instanceof BezierEdgeRealizer) {
            string = "Bezier";
        }
        if (edgeRealizer instanceof SplineEdgeRealizer) {
            string = "Spline";
        }
        indentPrintWriter.println("<CurveType type=\"" + string + "\"/>");
    }

    protected void writeSourceArrow(IndentPrintWriter indentPrintWriter, EdgeRealizer edgeRealizer) {
        indentPrintWriter.println("<SourceArrow>");
        indentPrintWriter.increaseIndent();
        XMLTools.writeArrow(indentPrintWriter, edgeRealizer.getSourceArrow());
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</SourceArrow>");
    }

    protected void writeTargetArrow(IndentPrintWriter indentPrintWriter, EdgeRealizer edgeRealizer) {
        indentPrintWriter.println("<TargetArrow>");
        indentPrintWriter.increaseIndent();
        XMLTools.writeArrow(indentPrintWriter, edgeRealizer.getTargetArrow());
        indentPrintWriter.decreaseIndent();
        indentPrintWriter.println("</TargetArrow>");
    }
}

