/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphdrawing.graphml.attr.AttributeFactory;
import org.graphdrawing.graphml.reader.GraphElementFactory;
import org.graphdrawing.graphml.reader.GraphMLParseContext;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.util.D;

public class YGraphElementFactory
implements GraphElementFactory,
AttributeFactory {
    protected YList graphList;
    protected YList createdGraphList;
    protected Class graphImpl;
    protected YList attributeList;
    protected Map attributeMap;

    public YGraphElementFactory(Class clazz) {
        this.graphImpl = clazz;
        this.graphList = new YList();
        this.attributeList = new YList();
        this.createdGraphList = new YList();
        this.attributeMap = new HashMap();
    }

    public YGraphElementFactory(Graph graph) {
        this(graph.getClass());
        graph.clear();
        this.createdGraphList.add((Object)graph);
    }

    public YList getGraphList() {
        return this.graphList;
    }

    public Object createGraphML(GraphMLParseContext graphMLParseContext) {
        return null;
    }

    public Object createGraph(GraphMLParseContext graphMLParseContext, String string, int n) {
        Object object;
        if (this.createdGraphList.isEmpty()) {
            try {
                object = this.graphImpl.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            object = this.createdGraphList.pop();
        }
        this.graphList.add(object);
        Graph graph = (Graph)object;
        YCursor yCursor = this.attributeList.cursor();
        while (yCursor.ok()) {
            AttributeData attributeData = (AttributeData)yCursor.current();
            if (graph.getDataProvider((Object)attributeData.B) == null) {
                switch (attributeData.A) {
                    case 1: {
                        graph.addDataProvider((Object)attributeData.B, (DataProvider)graph.createNodeMap());
                        break;
                    }
                    case 2: {
                        graph.addDataProvider((Object)attributeData.B, (DataProvider)graph.createEdgeMap());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported attribute type: " + attributeData.A);
                    }
                }
            }
            yCursor.next();
        }
        return object;
    }

    public Object createNode(GraphMLParseContext graphMLParseContext, String string) {
        D.watch((String)("node added: " + string));
        List list = graphMLParseContext.getContainers();
        Graph graph = (Graph)list.get(list.size() - 1);
        Node node = graph.createNode();
        return node;
    }

    public Object createEdge(GraphMLParseContext graphMLParseContext, String string, Object object, Object object2, Object object3, Object object4, boolean bl) {
        D.watch((String)("edge added: " + string));
        List list = graphMLParseContext.getContainers();
        Graph graph = (Graph)list.get(list.size() - 1);
        Node node = (Node)object;
        Node node2 = (Node)object2;
        Edge edge = graph.createEdge(node, node2);
        return edge;
    }

    public Object createPort(GraphMLParseContext graphMLParseContext, String string) {
        return null;
    }

    public Object createHyperEdge(GraphMLParseContext graphMLParseContext, String string) {
        return null;
    }

    public Object createEndPoint(GraphMLParseContext graphMLParseContext, String string, Object object, Object object2, int n) {
        return null;
    }

    public void defineAttribute(String string, int n, int n2) {
        AttributeData attributeData = new AttributeData(string, n2, n);
        this.attributeList.add((Object)attributeData);
        this.attributeMap.put(string, attributeData);
    }

    public void createAttribute(GraphMLParseContext graphMLParseContext, String string, String string2) {
        List list = graphMLParseContext.getContainers();
        Graph graph = (Graph)list.get(list.size() - 2);
        Object e = list.get(list.size() - 1);
        DataProvider dataProvider = graph.getDataProvider((Object)string);
        AttributeData attributeData = (AttributeData)this.attributeMap.get(string);
        if (e instanceof Node) {
            Node node = (Node)e;
            NodeMap nodeMap = (NodeMap)dataProvider;
            switch (attributeData.C) {
                case 4: {
                    nodeMap.setDouble((Object)node, Double.parseDouble(string2));
                    break;
                }
                case 3: {
                    nodeMap.setDouble((Object)node, (double)Float.parseFloat(string2));
                    break;
                }
                case 1: {
                    nodeMap.setInt((Object)node, Integer.parseInt(string2));
                    break;
                }
                case 2: {
                    nodeMap.setInt((Object)node, (int)Long.parseLong(string2));
                    break;
                }
                case 5: {
                    nodeMap.set((Object)node, (Object)string2);
                    break;
                }
                case 6: {
                    nodeMap.setBool((Object)node, "true".equalsIgnoreCase(string2));
                    break;
                }
                default: {
                    throw new RuntimeException("Undefined Attribute type: " + attributeData.C);
                }
            }
        } else if (e instanceof Edge) {
            Edge edge = (Edge)e;
            EdgeMap edgeMap = (EdgeMap)dataProvider;
            switch (attributeData.C) {
                case 4: {
                    edgeMap.setDouble((Object)edge, Double.parseDouble(string2));
                    break;
                }
                case 3: {
                    edgeMap.setDouble((Object)edge, (double)Float.parseFloat(string2));
                    break;
                }
                case 1: {
                    edgeMap.setInt((Object)edge, Integer.parseInt(string2));
                    break;
                }
                case 2: {
                    edgeMap.setInt((Object)edge, (int)Long.parseLong(string2));
                    break;
                }
                case 5: {
                    edgeMap.set((Object)edge, (Object)string2);
                    break;
                }
                case 6: {
                    edgeMap.setBool((Object)edge, Boolean.valueOf(string2).booleanValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Undefined Attribute type: " + attributeData.C);
                }
            }
        }
    }

    protected class AttributeData {
        String B;
        int A;
        int C;

        protected AttributeData(String string, int n, int n2) {
            this.B = string;
            this.A = n;
            this.C = n2;
        }
    }
}

