/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.ConstructorParam;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import java.util.Collection;
import java.util.Vector;

public class ConstructorParamNode
extends BaseNode {
    private IdentNode lhsUnresolved;
    public DeclNode lhs;
    public ExprNode rhs;
    private static final MemberResolver<DeclNode> lhsResolver;

    public ConstructorParamNode(IdentNode identNode, ExprNode exprNode) {
        super(identNode.getCoords());
        this.lhsUnresolved = this.becomeParent(identNode);
        this.rhs = this.becomeParent(exprNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.lhsUnresolved, this.lhs));
        if (this.rhs != null) {
            vector.add(this.rhs);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        if (this.rhs != null) {
            vector.add("rhs");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!lhsResolver.resolve(this.lhsUnresolved)) {
            return false;
        }
        this.lhs = lhsResolver.getResult(DeclNode.class);
        return lhsResolver.finish();
    }

    @Override
    protected boolean checkLocal() {
        return this.rhs == null || this.typeCheckLocal();
    }

    private boolean typeCheckLocal() {
        TypeNode typeNode = this.lhs.getDeclType();
        TypeNode typeNode2 = this.rhs.getType();
        if (typeNode2.isEqual(typeNode)) {
            return true;
        }
        this.rhs = this.becomeParent(this.rhs.adjustType(typeNode, this.getCoords()));
        return this.rhs != ConstNode.getInvalid();
    }

    @Override
    protected IR constructIR() {
        if (this.rhs != null) {
            this.rhs = this.rhs.evaluate();
        }
        return new ConstructorParam(this.lhs.checkIR(Entity.class), this.rhs != null ? this.rhs.checkIR(Expression.class) : null);
    }

    static {
        ConstructorParamNode.setName(ConstructorParamNode.class, "constructor parameter declaration");
        lhsResolver = new MemberResolver();
    }
}

