/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class RangeSpecNode
extends BaseNode {
    public static final long UNBOUND = Integer.MAX_VALUE;
    private long lower;
    private long upper;

    public RangeSpecNode(Coords coords, long l, long l2) {
        super(coords);
        this.lower = l;
        this.upper = l2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        if (this.lower < 0L) {
            this.reportError("The lower bound of the range must be a positive number.");
            bl = false;
        }
        if (this.upper < 0L) {
            this.reportError("The upper bound of the range must be a positive number.");
            bl = false;
        }
        if (this.lower > this.upper) {
            this.reportError("The lower bound must be less (or equal) than the upper bound of the range.");
            bl = false;
        }
        return bl;
    }

    @Override
    public String getName() {
        return super.getName() + " [" + this.lower + ":" + this.upper + "]";
    }

    public long getLower() {
        return this.lower;
    }

    public long getUpper() {
        return this.upper;
    }

    static {
        RangeSpecNode.setName(RangeSpecNode.class, "range spec");
    }
}

