/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.RuleDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SequenceDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SubpatternDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeCaseDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.model.decl.ModelNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.PackageTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphRhsNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementsNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeIteratedNode;
import de.unika.ipd.grgen.ast.util.CollectChecker;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.SimpleChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Unit;
import de.unika.ipd.grgen.ir.executable.FilterFunction;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterFunction;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.executable.Sequence;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.PackageActionType;
import de.unika.ipd.grgen.util.Base;
import java.util.Collection;
import java.util.Vector;

public class UnitNode
extends BaseNode {
    private static UnitNode root;
    private ModelNode stdModel;
    private CollectNode<ModelNode> models;
    private CollectNode<SubpatternDeclNode> subpatterns;
    private CollectNode<IdentNode> subpatternsUnresolved;
    private CollectNode<ActionDeclNode> actions;
    private CollectNode<IdentNode> actionsUnresolved;
    private CollectNode<MatchTypeActionNode> matchTypes;
    private CollectNode<IdentNode> matchTypesUnresolved;
    private CollectNode<MatchTypeIteratedNode> matchTypesIterated;
    private CollectNode<IdentNode> matchTypesIteratedUnresolved;
    private CollectNode<FilterFunctionDeclNode> filterFunctions;
    private CollectNode<IdentNode> filterFunctionsUnresolved;
    private CollectNode<TypeDeclNode> matchClassDecls;
    private CollectNode<IdentNode> matchClassesUnresolved;
    private CollectNode<MatchClassFilterFunctionDeclNode> matchClassFilterFunctions;
    private CollectNode<IdentNode> matchClassFilterFunctionsUnresolved;
    private CollectNode<FunctionDeclNode> functions;
    private CollectNode<IdentNode> functionsUnresolved;
    private CollectNode<ProcedureDeclNode> procedures;
    private CollectNode<IdentNode> proceduresUnresolved;
    private CollectNode<SequenceDeclNode> sequences;
    private CollectNode<IdentNode> sequencesUnresolved;
    private CollectNode<TypeDeclNode> packages;
    private CollectNode<IdentNode> packagesUnresolved;
    private String unitname;
    private String filename;
    private static final CollectResolver<SubpatternDeclNode> subpatternsResolver;
    private static final CollectResolver<ActionDeclNode> actionsResolver;
    private static final CollectResolver<MatchTypeActionNode> matchTypesResolver;
    private static final CollectResolver<FilterFunctionDeclNode> filterFunctionsResolver;
    private static final CollectResolver<TypeDeclNode> matchClassesResolver;
    private static final CollectResolver<MatchClassFilterFunctionDeclNode> matchClassFilterFunctionsResolver;
    private static final CollectResolver<MatchTypeIteratedNode> matchTypesIteratedResolver;
    private static final CollectResolver<FunctionDeclNode> functionsResolver;
    private static final CollectResolver<ProcedureDeclNode> proceduresResolver;
    private static final CollectResolver<SequenceDeclNode> sequencesResolver;
    private static final CollectResolver<TypeDeclNode> packagesResolver;

    public UnitNode(String string, String string2, ModelNode modelNode, CollectNode<ModelNode> collectNode, CollectNode<IdentNode> collectNode2, CollectNode<IdentNode> collectNode3, CollectNode<IdentNode> collectNode4, CollectNode<IdentNode> collectNode5, CollectNode<IdentNode> collectNode6, CollectNode<IdentNode> collectNode7, CollectNode<IdentNode> collectNode8, CollectNode<IdentNode> collectNode9, CollectNode<IdentNode> collectNode10, CollectNode<IdentNode> collectNode11, CollectNode<IdentNode> collectNode12) {
        this.stdModel = modelNode;
        this.models = collectNode;
        this.becomeParent(this.models);
        this.subpatternsUnresolved = collectNode2;
        this.becomeParent(this.subpatternsUnresolved);
        this.actionsUnresolved = collectNode3;
        this.becomeParent(this.actionsUnresolved);
        this.matchTypesUnresolved = collectNode4;
        this.becomeParent(this.matchTypesUnresolved);
        this.filterFunctionsUnresolved = collectNode5;
        this.becomeParent(this.filterFunctionsUnresolved);
        this.matchClassesUnresolved = collectNode6;
        this.becomeParent(this.matchClassesUnresolved);
        this.matchClassFilterFunctionsUnresolved = collectNode7;
        this.becomeParent(this.matchClassFilterFunctionsUnresolved);
        this.matchTypesIteratedUnresolved = collectNode8;
        this.becomeParent(this.matchTypesIteratedUnresolved);
        this.functionsUnresolved = collectNode9;
        this.becomeParent(this.functionsUnresolved);
        this.proceduresUnresolved = collectNode10;
        this.becomeParent(this.proceduresUnresolved);
        this.sequencesUnresolved = collectNode11;
        this.becomeParent(this.sequencesUnresolved);
        this.packagesUnresolved = collectNode12;
        this.becomeParent(this.packagesUnresolved);
        this.unitname = string;
        this.filename = string2;
    }

    protected ModelNode getStdModel() {
        return this.stdModel;
    }

    public void addModel(ModelNode modelNode) {
        this.models.addChild(modelNode);
    }

    public ModelNode getModel() {
        return this.models.get(0);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.models);
        vector.add(this.getValidVersion(this.subpatternsUnresolved, this.subpatterns));
        vector.add(this.getValidVersion(this.actionsUnresolved, this.actions));
        vector.add(this.getValidVersion(this.matchTypesUnresolved, this.matchTypes));
        vector.add(this.getValidVersion(this.filterFunctionsUnresolved, this.filterFunctions));
        vector.add(this.getValidVersion(this.matchClassesUnresolved, this.matchClassDecls));
        vector.add(this.getValidVersion(this.matchClassFilterFunctionsUnresolved, this.matchClassFilterFunctions));
        vector.add(this.getValidVersion(this.matchTypesIteratedUnresolved, this.matchTypesIterated));
        vector.add(this.getValidVersion(this.functionsUnresolved, this.functions));
        vector.add(this.getValidVersion(this.proceduresUnresolved, this.procedures));
        vector.add(this.getValidVersion(this.sequencesUnresolved, this.sequences));
        vector.add(this.getValidVersion(this.packagesUnresolved, this.packages));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("models");
        vector.add("subpatterns");
        vector.add("actions");
        vector.add("match types");
        vector.add("filter functions");
        vector.add("match classes");
        vector.add("match class filter functions");
        vector.add("match types iterated");
        vector.add("functions");
        vector.add("procedures");
        vector.add("sequences");
        vector.add("packages");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.subpatterns = subpatternsResolver.resolve(this.subpatternsUnresolved, this);
        this.actions = actionsResolver.resolve(this.actionsUnresolved, this);
        this.matchTypes = matchTypesResolver.resolve(this.matchTypesUnresolved, this);
        this.filterFunctions = filterFunctionsResolver.resolve(this.filterFunctionsUnresolved, this);
        this.matchClassDecls = matchClassesResolver.resolve(this.matchClassesUnresolved, this);
        this.matchClassFilterFunctions = matchClassFilterFunctionsResolver.resolve(this.matchClassFilterFunctionsUnresolved, this);
        this.matchTypesIterated = matchTypesIteratedResolver.resolve(this.matchTypesIteratedUnresolved, this);
        this.functions = functionsResolver.resolve(this.functionsUnresolved, this);
        this.procedures = proceduresResolver.resolve(this.proceduresUnresolved, this);
        this.sequences = sequencesResolver.resolve(this.sequencesUnresolved, this);
        this.packages = packagesResolver.resolve(this.packagesUnresolved, this);
        return this.subpatterns != null && this.actions != null && this.matchTypes != null && this.filterFunctions != null && this.matchClassDecls != null && this.matchClassFilterFunctions != null && this.matchTypesIterated != null && this.functions != null && this.procedures != null && this.sequences != null && this.packages != null;
    }

    @Override
    protected boolean checkLocal() {
        CollectChecker collectChecker = new CollectChecker(new SimpleChecker(ModelNode.class));
        boolean bl = collectChecker.check(this.models, error);
        for (ModelNode declNode : this.models.getChildren()) {
            bl = UnitNode.checkModelTypes(bl, declNode.getTypeDecls());
            for (ModelNode modelNode : declNode.getUsedModels().getChildren()) {
                bl = UnitNode.checkModelTypes(bl, modelNode.getTypeDecls());
                for (TypeDeclNode typeDeclNode : modelNode.getPackages().getChildren()) {
                    PackageTypeNode packageTypeNode = (PackageTypeNode)typeDeclNode.getDeclType();
                    bl = UnitNode.checkModelTypes(bl, packageTypeNode.getTypeDecls());
                }
            }
            for (TypeDeclNode typeDeclNode : declNode.getPackages().getChildren()) {
                PackageTypeNode packageTypeNode = (PackageTypeNode)typeDeclNode.getDeclType();
                bl = UnitNode.checkModelTypes(bl, packageTypeNode.getTypeDecls());
            }
        }
        for (SubpatternDeclNode subpatternDeclNode : this.subpatterns.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(subpatternDeclNode, subpatternDeclNode.pattern);
            if (subpatternDeclNode.right == null) continue;
            bl &= UnitNode.checkStatementsRHS(subpatternDeclNode, subpatternDeclNode.right.patternGraph);
        }
        for (ActionDeclNode actionDeclNode : this.actions.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(actionDeclNode, actionDeclNode.pattern);
            if (!(actionDeclNode instanceof RuleDeclNode)) continue;
            RuleDeclNode ruleDeclNode = (RuleDeclNode)actionDeclNode;
            bl &= UnitNode.checkStatementsRHS(actionDeclNode, ruleDeclNode.right.patternGraph);
        }
        for (FilterFunctionDeclNode filterFunctionDeclNode : this.filterFunctions.getChildren()) {
            if (filterFunctionDeclNode.evalStatements == null) continue;
            bl &= EvalStatementNode.checkStatements(true, filterFunctionDeclNode, null, filterFunctionDeclNode.evalStatements, true);
        }
        for (MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode : this.matchClassFilterFunctions.getChildren()) {
            if (matchClassFilterFunctionDeclNode.evalStatements == null) continue;
            bl &= EvalStatementNode.checkStatements(true, matchClassFilterFunctionDeclNode, null, matchClassFilterFunctionDeclNode.evalStatements, true);
        }
        for (FunctionDeclNode functionDeclNode : this.functions.getChildren()) {
            bl &= EvalStatementNode.checkStatements(true, functionDeclNode, null, functionDeclNode.evalStatements, true);
        }
        for (ProcedureDeclNode procedureDeclNode : this.procedures.getChildren()) {
            bl &= EvalStatementNode.checkStatements(false, procedureDeclNode, null, procedureDeclNode.evalStatements, true);
        }
        return bl;
    }

    private static boolean checkModelTypes(boolean bl, CollectNode<TypeDeclNode> collectNode) {
        for (TypeDeclNode typeDeclNode : collectNode.getChildren()) {
            DeclaredTypeNode declaredTypeNode = typeDeclNode.getDeclType();
            if (!(declaredTypeNode instanceof InheritanceTypeNode)) continue;
            InheritanceTypeNode inheritanceTypeNode = (InheritanceTypeNode)declaredTypeNode;
            bl &= inheritanceTypeNode.checkStatementsInMethods();
        }
        return bl;
    }

    public static boolean checkStatementsLHS(DeclNode declNode, PatternGraphLhsNode patternGraphLhsNode) {
        boolean bl = true;
        for (AlternativeDeclNode baseNode : patternGraphLhsNode.alts.getChildren()) {
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : baseNode.getChildren()) {
                bl &= UnitNode.checkStatementsLHS(declNode, alternativeCaseDeclNode.pattern);
                if (alternativeCaseDeclNode.right == null) continue;
                bl &= UnitNode.checkStatementsRHS(declNode, alternativeCaseDeclNode.right.patternGraph);
            }
        }
        for (IteratedDeclNode iteratedDeclNode : patternGraphLhsNode.iters.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(declNode, iteratedDeclNode.pattern);
            if (iteratedDeclNode.right == null) continue;
            bl &= UnitNode.checkStatementsRHS(declNode, iteratedDeclNode.right.patternGraph);
        }
        for (PatternGraphLhsNode patternGraphLhsNode2 : patternGraphLhsNode.idpts.getChildren()) {
            bl &= UnitNode.checkStatementsLHS(declNode, patternGraphLhsNode2);
        }
        for (EvalStatementsNode evalStatementsNode : patternGraphLhsNode.yields.getChildren()) {
            bl &= EvalStatementNode.checkStatements(true, declNode, null, evalStatementsNode.evalStatements, true);
        }
        return bl;
    }

    public static boolean checkStatementsRHS(DeclNode declNode, PatternGraphRhsNode patternGraphRhsNode) {
        boolean bl = true;
        for (EvalStatementsNode evalStatementsNode : patternGraphRhsNode.evals.getChildren()) {
            bl &= EvalStatementNode.checkStatements(false, declNode, null, evalStatementsNode.evalStatements, true);
        }
        return bl;
    }

    public Unit getUnit() {
        return this.checkIR(Unit.class);
    }

    @Override
    protected IR constructIR() {
        Base base;
        Unit unit = new Unit(this.unitname, this.filename);
        for (ModelNode declNode : this.models.getChildren()) {
            base = declNode.getModel();
            unit.addModel((Model)base);
        }
        for (SubpatternDeclNode subpatternDeclNode : this.subpatterns.getChildren()) {
            base = subpatternDeclNode.getMatcher();
            unit.addSubpatternRule((Rule)base);
        }
        for (ActionDeclNode actionDeclNode : this.actions.getChildren()) {
            base = actionDeclNode.getMatcher();
            unit.addActionRule((Rule)base);
        }
        for (FilterFunctionDeclNode filterFunctionDeclNode : this.filterFunctions.getChildren()) {
            base = filterFunctionDeclNode.getFilterFunction();
            unit.addFilterFunction((FilterFunction)base);
        }
        for (TypeDeclNode typeDeclNode : this.matchClassDecls.getChildren()) {
            base = (DefinedMatchTypeNode)typeDeclNode.getDeclType();
            DefinedMatchType definedMatchType = ((DefinedMatchTypeNode)base).getDefinedMatchType();
            unit.addMatchClass(definedMatchType);
        }
        for (MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode : this.matchClassFilterFunctions.getChildren()) {
            base = matchClassFilterFunctionDeclNode.getMatchClassFilterFunction();
            unit.addMatchClassFilterFunction((MatchClassFilterFunction)base);
        }
        for (FunctionDeclNode functionDeclNode : this.functions.getChildren()) {
            base = functionDeclNode.getFunction();
            unit.addFunction((Function)base);
        }
        for (ProcedureDeclNode procedureDeclNode : this.procedures.getChildren()) {
            base = procedureDeclNode.getProcedure();
            unit.addProcedure((Procedure)base);
        }
        for (SequenceDeclNode sequenceDeclNode : this.sequences.getChildren()) {
            base = sequenceDeclNode.getSequence();
            unit.addSequence((Sequence)base);
        }
        for (TypeDeclNode typeDeclNode : this.packages.getChildren()) {
            base = (PackageActionType)typeDeclNode.getDeclType().getType();
            unit.addPackage((PackageActionType)base);
        }
        return unit;
    }

    public static UnitNode getRoot() {
        return root;
    }

    public static void setRoot(UnitNode unitNode) {
        if (root != null) {
            throw new RuntimeException("Internal error, change of root node");
        }
        root = unitNode;
    }

    static {
        UnitNode.setName(UnitNode.class, "unit declaration");
        subpatternsResolver = new CollectResolver<SubpatternDeclNode>(new DeclarationResolver<SubpatternDeclNode>(SubpatternDeclNode.class));
        actionsResolver = new CollectResolver<ActionDeclNode>(new DeclarationResolver<ActionDeclNode>(ActionDeclNode.class));
        matchTypesResolver = new CollectResolver<MatchTypeActionNode>(new DeclarationTypeResolver<MatchTypeActionNode>(MatchTypeActionNode.class));
        filterFunctionsResolver = new CollectResolver<FilterFunctionDeclNode>(new DeclarationResolver<FilterFunctionDeclNode>(FilterFunctionDeclNode.class));
        matchClassesResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
        matchClassFilterFunctionsResolver = new CollectResolver<MatchClassFilterFunctionDeclNode>(new DeclarationResolver<MatchClassFilterFunctionDeclNode>(MatchClassFilterFunctionDeclNode.class));
        matchTypesIteratedResolver = new CollectResolver<MatchTypeIteratedNode>(new DeclarationTypeResolver<MatchTypeIteratedNode>(MatchTypeIteratedNode.class));
        functionsResolver = new CollectResolver<FunctionDeclNode>(new DeclarationResolver<FunctionDeclNode>(FunctionDeclNode.class));
        proceduresResolver = new CollectResolver<ProcedureDeclNode>(new DeclarationResolver<ProcedureDeclNode>(ProcedureDeclNode.class));
        sequencesResolver = new CollectResolver<SequenceDeclNode>(new DeclarationResolver<SequenceDeclNode>(SequenceDeclNode.class));
        packagesResolver = new CollectResolver<TypeDeclNode>(new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class));
    }
}

