/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.ConstructorParamNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.type.ConstructorTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.Constructor;
import de.unika.ipd.grgen.ir.ConstructorParam;
import de.unika.ipd.grgen.ir.IR;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ConstructorDeclNode
extends DeclNode {
    private static final TypeNode constructorType;
    private CollectNode<ConstructorParamNode> parameters;

    public ConstructorDeclNode(IdentNode identNode, CollectNode<ConstructorParamNode> collectNode) {
        super(identNode, constructorType);
        this.parameters = this.becomeParent(collectNode);
    }

    @Override
    public TypeNode getDeclType() {
        return constructorType;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.parameters);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("parameters");
        return vector;
    }

    public CollectNode<ConstructorParamNode> getParameters() {
        return this.parameters;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    public static String getKindStr() {
        return "constructor";
    }

    public Constructor getConstructor() {
        return this.checkIR(Constructor.class);
    }

    @Override
    protected IR constructIR() {
        LinkedHashSet<ConstructorParam> linkedHashSet = new LinkedHashSet<ConstructorParam>();
        for (ConstructorParamNode constructorParamNode : this.parameters.getChildren()) {
            linkedHashSet.add(constructorParamNode.checkIR(ConstructorParam.class));
        }
        return new Constructor(linkedHashSet);
    }

    static {
        ConstructorDeclNode.setName(ConstructorDeclNode.class, "constructor declaration");
        constructorType = new ConstructorTypeNode();
    }
}

