/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.DeclaredCharacter;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.InvalidDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.model.type.ArbitraryEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.Entity;
import java.awt.Color;

public abstract class DeclNode
extends BaseNode
implements DeclaredCharacter {
    public IdentNode ident;
    public BaseNode typeUnresolved;
    private static final DeclNode invalidDecl;

    public static final DeclNode getInvalid() {
        return invalidDecl;
    }

    public static final DeclNode getInvalid(IdentNode identNode) {
        return new InvalidDeclNode(identNode);
    }

    protected DeclNode(IdentNode identNode, BaseNode baseNode) {
        super(identNode.getCoords());
        identNode.setDecl(this);
        this.ident = identNode;
        this.becomeParent(this.ident);
        this.typeUnresolved = baseNode;
        this.becomeParent(this.typeUnresolved);
    }

    public IdentNode getIdentNode() {
        return this.ident;
    }

    public abstract TypeNode getDeclType();

    @Override
    public DeclNode getDecl() {
        return this;
    }

    @Override
    public Color getNodeColor() {
        return Color.BLUE;
    }

    public final String emptyWhenAnonymous(String string) {
        return this.getIdentNode().getCurrOcc().isAnonymous() ? "" : string;
    }

    public final String emptyWhenAnonymousPostfix(String string) {
        return this.getIdentNode().getCurrOcc().isAnonymous() ? "" : string + this.getIdentNode();
    }

    public final String emptyWhenAnonymousInParenthesis(String string) {
        return this.getIdentNode().getCurrOcc().isAnonymous() ? "" : string + "(" + this.getIdentNode() + ")";
    }

    public final String dotOrArrowWhenAnonymous() {
        if (this.getIdentNode().getCurrOcc().isAnonymous() && this instanceof EdgeDeclNode) {
            EdgeDeclNode edgeDeclNode = (EdgeDeclNode)this;
            if (edgeDeclNode.getDeclType() instanceof ArbitraryEdgeTypeNode) {
                return "?--?";
            }
            if (edgeDeclNode.getDeclType() instanceof DirectedEdgeTypeNode) {
                return "-->";
            }
            if (edgeDeclNode.getDeclType() instanceof UndirectedEdgeTypeNode) {
                return "--";
            }
        }
        return this.getIdentNode().getCurrOcc().isAnonymous() ? "." : this.getIdentNode().toString();
    }

    public Entity getEntity() {
        return this.checkIR(Entity.class);
    }

    public static String getKindStr() {
        return "declaration";
    }

    @Override
    public String toString() {
        return this.ident.toString();
    }

    static {
        DeclNode.setName(DeclNode.class, "declaration");
        invalidDecl = new InvalidDeclNode(IdentNode.getInvalid());
    }
}

