/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.InvalidDeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.ExecVariable;
import java.util.Collection;
import java.util.Vector;

public class ExecVarDeclNode
extends DeclNode {
    private static final DeclarationResolver<DeclNode> declOfTypeResolver = new DeclarationResolver<DeclNode>(DeclNode.class);
    private TypeNode type;

    public ExecVarDeclNode(IdentNode identNode, IdentNode identNode2) {
        super(identNode, identNode2);
    }

    public ExecVarDeclNode(IdentNode identNode, TypeNode typeNode) {
        super(identNode, typeNode);
        this.type = typeNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.type != null) {
            return true;
        }
        DeclNode declNode = (DeclNode)declOfTypeResolver.resolve(this.typeUnresolved, this);
        if (declNode instanceof InvalidDeclNode) {
            this.typeUnresolved.reportError("The exec variable " + this.getIdentNode() + " has an unknown type " + this.typeUnresolved + ".");
            return false;
        }
        this.type = declNode.getDeclType();
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved()) : this + " was not resolved";
        return this.type;
    }

    public static String getKindStr() {
        return "exec variable";
    }

    @Override
    protected ExecVariable constructIR() {
        return new ExecVariable("ExecVar", this.getIdentNode().getIdent(), this.type.getType(), 0);
    }
}

