/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.model.type.ArbitraryEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import java.util.Collection;
import java.util.Vector;

public class TypeDeclNode
extends DeclNode {
    private DeclaredTypeNode type;
    private static DeclarationTypeResolver<DeclaredTypeNode> typeResolver;

    public TypeDeclNode(IdentNode identNode, BaseNode baseNode) {
        super(identNode, baseNode);
        if (baseNode instanceof DeclaredTypeNode) {
            DeclaredTypeNode declaredTypeNode = (DeclaredTypeNode)baseNode;
            declaredTypeNode.setDecl(this);
        }
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = (DeclaredTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkNoConflictingEdgeParents();
    }

    private boolean checkNoConflictingEdgeParents() {
        if (!(this.type instanceof EdgeTypeNode)) {
            return true;
        }
        EdgeTypeNode edgeTypeNode = (EdgeTypeNode)this.type;
        InheritanceTypeNode inheritanceTypeNode = TypeDeclNode.extendsEdge(edgeTypeNode);
        InheritanceTypeNode inheritanceTypeNode2 = TypeDeclNode.extendsUEdge(edgeTypeNode);
        if (inheritanceTypeNode != null && inheritanceTypeNode2 != null) {
            this.reportError("An edge class cannot extend a directed and an undirected edge class (but this occurs for " + this.getIdentNode() + " with " + inheritanceTypeNode.toStringWithDeclarationCoords() + " and " + inheritanceTypeNode2.toStringWithDeclarationCoords() + ")");
            return false;
        }
        if (this.type instanceof ArbitraryEdgeTypeNode && inheritanceTypeNode != null) {
            this.reportError("An arbitrary edge class cannot extend a directed edge class (but this occurs for " + this.getIdentNode() + " with " + inheritanceTypeNode.toStringWithDeclarationCoords() + ")");
            return false;
        }
        if (this.type instanceof ArbitraryEdgeTypeNode && inheritanceTypeNode2 != null) {
            this.reportError("An arbitrary edge class cannot extend an undirected edge class (but this occurs for " + this.getIdentNode() + " with " + inheritanceTypeNode2.toStringWithDeclarationCoords() + ")");
            return false;
        }
        if (this.type instanceof UndirectedEdgeTypeNode && inheritanceTypeNode != null) {
            this.reportError("An undirected edge class cannot extend a directed edge class (but this occurs for " + this.getIdentNode() + " with " + inheritanceTypeNode.toStringWithDeclarationCoords() + ")");
            return false;
        }
        if (this.type instanceof DirectedEdgeTypeNode && inheritanceTypeNode2 != null) {
            this.reportError("A directed edge class cannot extend an undirected edge class (but this occurs for " + this.getIdentNode() + " with " + inheritanceTypeNode2.toStringWithDeclarationCoords() + ")");
            return false;
        }
        return true;
    }

    private static InheritanceTypeNode extendsEdge(EdgeTypeNode edgeTypeNode) {
        for (InheritanceTypeNode inheritanceTypeNode : edgeTypeNode.getDirectSuperTypes()) {
            if (!(inheritanceTypeNode instanceof DirectedEdgeTypeNode)) continue;
            return inheritanceTypeNode;
        }
        return null;
    }

    private static InheritanceTypeNode extendsUEdge(EdgeTypeNode edgeTypeNode) {
        for (InheritanceTypeNode inheritanceTypeNode : edgeTypeNode.getDirectSuperTypes()) {
            if (!(inheritanceTypeNode instanceof UndirectedEdgeTypeNode)) continue;
            return inheritanceTypeNode;
        }
        return null;
    }

    @Override
    protected IR constructIR() {
        return this.getDeclType().getIR();
    }

    public static String getKindStr() {
        return "type";
    }

    @Override
    public DeclaredTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    static {
        TypeDeclNode.setName(TypeDeclNode.class, "type declaration");
        typeResolver = new DeclarationTypeResolver<DeclaredTypeNode>(DeclaredTypeNode.class);
    }
}

