/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoSuppliedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.TopLevelMatcherDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.DeclExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.executable.FilterAutoGenerated;
import de.unika.ipd.grgen.ir.executable.FilterAutoSupplied;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.expr.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public abstract class ActionDeclNode
extends TopLevelMatcherDeclNode {
    protected CollectNode<BaseNode> returnFormalParametersUnresolved;
    public CollectNode<TypeNode> returnFormalParameters;
    protected ArrayList<FilterAutoDeclNode> filters;
    protected CollectNode<IdentNode> implementedMatchTypesUnresolved;
    protected CollectNode<DefinedMatchTypeNode> implementedMatchTypes;
    private static final CollectResolver<DefinedMatchTypeNode> matchTypeResolver;
    private static final CollectResolver<TypeNode> retTypeResolver;

    protected ActionDeclNode(IdentNode identNode, TypeNode typeNode, PatternGraphLhsNode patternGraphLhsNode, CollectNode<IdentNode> collectNode, CollectNode<BaseNode> collectNode2) {
        super(identNode, typeNode, patternGraphLhsNode);
        this.returnFormalParametersUnresolved = collectNode2;
        this.becomeParent(this.returnFormalParametersUnresolved);
        this.implementedMatchTypesUnresolved = collectNode;
        this.becomeParent(this.implementedMatchTypesUnresolved);
        this.filters = new ArrayList();
    }

    public void addFilters(ArrayList<FilterAutoDeclNode> arrayList) {
        this.filters.addAll(arrayList);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.returnFormalParametersUnresolved, this.returnFormalParameters));
        vector.add(this.pattern);
        vector.add(this.getValidVersion(this.implementedMatchTypesUnresolved, this.implementedMatchTypes));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("ret");
        vector.add("pattern");
        vector.add("implementedMatchTypes");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        for (IdentNode identNode : this.implementedMatchTypesUnresolved.getChildren()) {
            if (identNode instanceof PackageIdentNode) continue;
            ActionDeclNode.fixupDefinition(identNode, identNode.getScope());
        }
        this.implementedMatchTypes = matchTypeResolver.resolve(this.implementedMatchTypesUnresolved, this);
        this.returnFormalParameters = retTypeResolver.resolve(this.returnFormalParametersUnresolved, this);
        return this.returnFormalParameters != null & this.implementedMatchTypes != null & ActionDeclNode.resolveFilters(this.filters);
    }

    protected boolean checkReturns(CollectNode<ExprNode> collectNode) {
        boolean bl = true;
        int n = this.returnFormalParameters.size();
        int n2 = collectNode.size();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            ExprNode exprNode = collectNode.get(i);
            TypeNode typeNode = this.returnFormalParameters.get(i);
            bl &= this.checkReturns(i, exprNode, typeNode);
        }
        if (n2 != n) {
            bl = false;
            if (n == 0) {
                collectNode.reportError("No return parameters are declared in " + this.getKind() + " " + this.ident + ", but " + n2 + " return arguments are given.");
            } else if (n2 == 0) {
                this.reportError("A return statement is missing in " + this.getKind() + " " + this.ident + ", which is declared with " + n + " return parameters.");
            } else {
                collectNode.reportError("The return statement in " + this.getKind() + " " + this.ident + " has a wrong number of arguments, given are " + n2 + " arguments, but declared are " + n + " parameters.");
            }
        }
        return bl;
    }

    private boolean checkReturns(int n, ExprNode exprNode, TypeNode typeNode) {
        boolean bl = true;
        TypeNode typeNode2 = exprNode.getType();
        TypeNode typeNode3 = this.returnFormalParameters.get(n);
        if (!typeNode2.isCompatibleTo(typeNode)) {
            bl = false;
            String string = typeNode2.getTypeName();
            String string2 = typeNode3.getTypeName();
            this.ident.reportError("Cannot convert " + (n + 1) + ". return argument from " + string + " to the expected " + string2 + " (in " + this.getKind() + " " + this.ident + ")" + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode3.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
            return bl;
        }
        if (!(exprNode instanceof DeclExprNode)) {
            return bl;
        }
        ConstraintDeclNode constraintDeclNode = ((DeclExprNode)exprNode).getConstraintDeclNode();
        if (constraintDeclNode == null) {
            return bl;
        }
        InheritanceTypeNode inheritanceTypeNode = constraintDeclNode.getDeclType();
        Set<ConstraintDeclNode> set = constraintDeclNode instanceof NodeDeclNode ? this.pattern.getHomomorphic((NodeDeclNode)constraintDeclNode) : this.pattern.getHomomorphic((EdgeDeclNode)constraintDeclNode);
        for (ConstraintDeclNode constraintDeclNode2 : set) {
            InheritanceTypeNode inheritanceTypeNode2;
            ConstraintDeclNode constraintDeclNode3;
            if (constraintDeclNode2 == constraintDeclNode || (constraintDeclNode3 = constraintDeclNode2.getRetypedElement()) == null || (inheritanceTypeNode2 = constraintDeclNode3.getDeclType()).isA(inheritanceTypeNode)) continue;
            bl = false;
            exprNode.reportError("Return argument " + constraintDeclNode.getIdentNode() + " is homomorphic to " + constraintDeclNode2.getIdentNode() + ", which gets retyped to the incompatible type " + inheritanceTypeNode2.toStringWithDeclarationCoords() + " (in " + this.getKind() + " " + this.ident + ").");
            return bl;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkLeft() & this.checkFilters(this.pattern, this.filters) & this.checkMatchTypesImplemented();
    }

    public boolean checkMatchTypesImplemented() {
        boolean bl = true;
        for (DefinedMatchTypeNode definedMatchTypeNode : this.implementedMatchTypes.getChildren()) {
            bl &= this.checkMatchTypeImplemented(definedMatchTypeNode);
        }
        return bl;
    }

    public boolean checkMatchTypeImplemented(DefinedMatchTypeNode definedMatchTypeNode) {
        boolean bl = true;
        HashMap<String, NodeDeclNode> hashMap = new HashMap<String, NodeDeclNode>();
        for (NodeDeclNode object2 : this.pattern.getNodes()) {
            hashMap.put(object2.getIdentNode().toString(), object2);
        }
        for (NodeDeclNode nodeDeclNode : definedMatchTypeNode.getNodes()) {
            bl = this.checkNodeImplemented(nodeDeclNode, definedMatchTypeNode, hashMap);
        }
        HashMap hashMap2 = new HashMap();
        for (EdgeDeclNode edgeDeclNode : this.pattern.getEdges()) {
            hashMap2.put(edgeDeclNode.getIdentNode().toString(), edgeDeclNode);
        }
        for (EdgeDeclNode edgeDeclNode : definedMatchTypeNode.getEdges()) {
            bl = this.checkEdgeImplemented(edgeDeclNode, definedMatchTypeNode, hashMap2);
        }
        HashMap<String, VarDeclNode> hashMap3 = new HashMap<String, VarDeclNode>();
        for (VarDeclNode varDeclNode : this.pattern.getDefVariablesToBeYieldedTo().getChildren()) {
            hashMap3.put(varDeclNode.getIdentNode().toString(), varDeclNode);
        }
        for (DeclNode declNode : this.pattern.getParamDecls()) {
            if (!(declNode instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)declNode;
            hashMap3.put(varDeclNode.getIdentNode().toString(), varDeclNode);
        }
        for (VarDeclNode varDeclNode : definedMatchTypeNode.getVariables()) {
            bl = this.checkVariableImplemented(varDeclNode, definedMatchTypeNode, hashMap3);
        }
        return bl;
    }

    private boolean checkNodeImplemented(NodeDeclNode nodeDeclNode, DefinedMatchTypeNode definedMatchTypeNode, HashMap<String, NodeDeclNode> hashMap) {
        boolean bl = true;
        String string = this.getKind() + " " + this.getIdentNode().toString();
        String string2 = definedMatchTypeNode.getIdentNode().toString() + definedMatchTypeNode.getDecl().getDeclarationCoords();
        String string3 = nodeDeclNode.getIdentNode().toString();
        if (!hashMap.containsKey(string3)) {
            this.getIdentNode().reportError("The " + string + " does not implement the node " + string3 + " expected from the match class " + string2 + ".");
            bl = false;
        } else {
            NodeTypeNode nodeTypeNode;
            NodeDeclNode nodeDeclNode2 = hashMap.get(string3);
            NodeTypeNode nodeTypeNode2 = nodeDeclNode.getDeclType();
            if (!nodeTypeNode2.isEqual(nodeTypeNode = nodeDeclNode2.getDeclType())) {
                this.getIdentNode().reportError("The type of the node " + string3 + " from the " + string + " does not equal the type of the node from the match class " + string2 + ". In the match class, " + nodeTypeNode2.getTypeName() + " is declared, but in the pattern, " + nodeTypeNode.getTypeName() + " is declared.");
                bl = false;
            }
            if (nodeDeclNode2.defEntityToBeYieldedTo && !nodeDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The node " + string3 + " from the " + string + " is a def node, while it is a node in the match class " + string2 + ".");
                bl = false;
            }
            if (!nodeDeclNode2.defEntityToBeYieldedTo && nodeDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The node " + string3 + " from the " + string + " is a node, while it is a def node in the match class " + string2 + ".");
                bl = false;
            }
        }
        return bl;
    }

    private boolean checkEdgeImplemented(EdgeDeclNode edgeDeclNode, DefinedMatchTypeNode definedMatchTypeNode, HashMap<String, EdgeDeclNode> hashMap) {
        boolean bl = true;
        String string = this.getKind() + " " + this.getIdentNode().toString();
        String string2 = definedMatchTypeNode.getIdentNode().toString() + definedMatchTypeNode.getDecl().getDeclarationCoords();
        String string3 = edgeDeclNode.getIdentNode().toString();
        if (!hashMap.containsKey(string3)) {
            this.getIdentNode().reportError("The " + string + " does not implement the edge " + string3 + " expected from the match class " + string2 + ".");
            bl = false;
        } else {
            EdgeTypeNode edgeTypeNode;
            EdgeDeclNode edgeDeclNode2 = hashMap.get(string3);
            EdgeTypeNode edgeTypeNode2 = edgeDeclNode.getDeclType();
            if (!edgeTypeNode2.isEqual(edgeTypeNode = edgeDeclNode2.getDeclType())) {
                this.getIdentNode().reportError("The type of the edge " + string3 + " from the " + string + " does not equal the type of the edge from the match class " + string2 + ". In the match class, " + edgeTypeNode2.getTypeName() + " is declared, but in the pattern, " + edgeTypeNode.getTypeName() + " is declared.");
                bl = false;
            }
            if (edgeDeclNode2.defEntityToBeYieldedTo && !edgeDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The edge " + string3 + " from the " + string + " is a def edge, while it is an edge in the match class " + string2 + ".");
                bl = false;
            }
            if (!edgeDeclNode2.defEntityToBeYieldedTo && edgeDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The edge " + string3 + " from the " + string + " is an edge, while it is a def edge in the match class " + string2 + ".");
                bl = false;
            }
        }
        return bl;
    }

    private boolean checkVariableImplemented(VarDeclNode varDeclNode, DefinedMatchTypeNode definedMatchTypeNode, HashMap<String, VarDeclNode> hashMap) {
        boolean bl = true;
        String string = this.getKind() + " " + this.getIdentNode().toString();
        String string2 = definedMatchTypeNode.getIdentNode().toString() + definedMatchTypeNode.getDecl().getDeclarationCoords();
        String string3 = varDeclNode.getIdentNode().toString();
        if (!hashMap.containsKey(string3)) {
            this.getIdentNode().reportError("The " + string + " does not implement the variable " + string3 + " expected from the match class " + string2 + ".");
            bl = false;
        } else {
            TypeNode typeNode;
            VarDeclNode varDeclNode2 = hashMap.get(string3);
            TypeNode typeNode2 = varDeclNode.getDeclType();
            if (!typeNode2.isEqual(typeNode = varDeclNode2.getDeclType())) {
                this.getIdentNode().reportError("The type of the variable " + string3 + " from the " + string + " does not equal the type of the variable from the match class " + string2 + ". In the match class, " + typeNode2.getTypeName() + " is declared, but in the pattern, " + typeNode.getTypeName() + " is declared.");
                bl = false;
            }
            if (varDeclNode2.defEntityToBeYieldedTo && !varDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The variable " + string3 + " from the " + string + " is a def variable, while it is a variable in the match class " + string2 + ".");
                bl = false;
            }
            if (!varDeclNode2.defEntityToBeYieldedTo && varDeclNode.defEntityToBeYieldedTo) {
                this.getIdentNode().reportError("The variable " + string3 + " from the " + string + " is a variable, while it is a def variable in the match class " + string2 + ".");
                bl = false;
            }
        }
        return bl;
    }

    public Collection<DefinedMatchTypeNode> getImplementedMatchClasses() {
        return this.implementedMatchTypes.getChildren();
    }

    protected void constructIRaux(MatchingAction matchingAction, CollectNode<ExprNode> collectNode) {
        this.addParams(matchingAction);
        for (ExprNode baseNode : collectNode.getChildren()) {
            ExprNode exprNode = baseNode.evaluate();
            Expression expression = exprNode.checkIR(Expression.class);
            matchingAction.addReturn(expression);
        }
        for (FilterAutoDeclNode filterAutoDeclNode : this.filters) {
            if (filterAutoDeclNode instanceof FilterAutoSuppliedDeclNode) {
                ((FilterAutoSuppliedDeclNode)filterAutoDeclNode).checkIR(FilterAutoSupplied.class);
                continue;
            }
            ((FilterAutoGeneratedDeclNode)filterAutoDeclNode).checkIR(FilterAutoGenerated.class);
        }
    }

    public static String getKindStr() {
        return "action";
    }

    static {
        ActionDeclNode.setName(ActionDeclNode.class, "action declaration");
        matchTypeResolver = new CollectResolver<DefinedMatchTypeNode>(new DeclarationTypeResolver<DefinedMatchTypeNode>(DefinedMatchTypeNode.class));
        retTypeResolver = new CollectResolver<TypeNode>(new DeclarationTypeResolver<TypeNode>(TypeNode.class));
    }
}

