/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.ExternalFunctionTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.executable.ExternalFunctionMethod;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ExternalFunctionDeclNode
extends FunctionDeclBaseNode {
    protected CollectNode<BaseNode> parameterTypesUnresolved;
    protected CollectNode<TypeNode> parameterTypesCollectNode;
    boolean isMethod;
    private static final ExternalFunctionTypeNode externalFunctionType;
    private static final CollectResolver<TypeNode> parametersTypeResolver;

    public ExternalFunctionDeclNode(IdentNode identNode, CollectNode<BaseNode> collectNode, BaseNode baseNode, boolean bl) {
        super(identNode, externalFunctionType);
        this.parameterTypesUnresolved = collectNode;
        this.becomeParent(this.parameterTypesUnresolved);
        this.resultUnresolved = baseNode;
        this.becomeParent(this.resultUnresolved);
        this.isMethod = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.parameterTypesUnresolved, this.parameterTypesCollectNode));
        vector.add(this.getValidVersion(this.resultUnresolved, this.resultType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("paramTypes");
        vector.add("ret");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.parameterTypesCollectNode = parametersTypeResolver.resolve(this.parameterTypesUnresolved, this);
        this.parameterTypes = this.parameterTypesCollectNode.getChildrenAsVector();
        return this.parameterTypesCollectNode != null & super.resolveLocal();
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return externalFunctionType;
    }

    @Override
    protected IR constructIR() {
        ExternalFunction externalFunction = this.isMethod ? new ExternalFunctionMethod(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.resultType.checkIR(Type.class)) : new ExternalFunction(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.resultType.checkIR(Type.class));
        for (TypeNode typeNode : this.parameterTypesCollectNode.getChildren()) {
            externalFunction.addParameterType(typeNode.checkIR(Type.class));
        }
        return externalFunction;
    }

    public static String getKindStr() {
        return "external function";
    }

    static {
        ExternalFunctionDeclNode.setName(ExternalFunctionDeclNode.class, "external function declaration");
        externalFunctionType = new ExternalFunctionTypeNode();
        parametersTypeResolver = new CollectResolver<TypeNode>(new DeclarationTypeResolver<TypeNode>(TypeNode.class));
    }
}

