/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.ExternalProcedureTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.executable.ExternalProcedureMethod;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ExternalProcedureDeclNode
extends ProcedureDeclBaseNode {
    protected CollectNode<BaseNode> parameterTypesUnresolved;
    protected CollectNode<TypeNode> parameterTypesCollectNode;
    boolean isMethod;
    private static final ExternalProcedureTypeNode externalProcedureType;
    private static final CollectResolver<TypeNode> parametersTypeResolver;

    public ExternalProcedureDeclNode(IdentNode identNode, CollectNode<BaseNode> collectNode, CollectNode<BaseNode> collectNode2, boolean bl) {
        super(identNode, externalProcedureType);
        this.parameterTypesUnresolved = collectNode;
        this.becomeParent(this.parameterTypesUnresolved);
        this.resultsUnresolved = collectNode2;
        this.becomeParent(this.resultsUnresolved);
        this.isMethod = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.parameterTypesUnresolved, this.parameterTypesCollectNode));
        vector.add(this.getValidVersion(this.resultsUnresolved, this.resultTypesCollectNode));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("paramTypes");
        vector.add("ret");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.parameterTypesCollectNode = parametersTypeResolver.resolve(this.parameterTypesUnresolved, this);
        this.parameterTypes = this.parameterTypesCollectNode.getChildrenAsVector();
        return this.parameterTypesCollectNode != null & super.resolveLocal();
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return externalProcedureType;
    }

    @Override
    protected IR constructIR() {
        ExternalProcedure externalProcedure = this.isMethod ? new ExternalProcedureMethod(this.getIdentNode().toString(), this.getIdentNode().getIdent()) : new ExternalProcedure(this.getIdentNode().toString(), this.getIdentNode().getIdent());
        for (TypeNode typeNode : this.resultTypesCollectNode.getChildren()) {
            externalProcedure.addReturnType(typeNode.checkIR(Type.class));
        }
        for (TypeNode typeNode : this.parameterTypesCollectNode.getChildren()) {
            externalProcedure.addParameterType(typeNode.checkIR(Type.class));
        }
        return externalProcedure;
    }

    public static String getKindStr() {
        return "external procedure";
    }

    static {
        ExternalProcedureDeclNode.setName(ExternalProcedureDeclNode.class, "external procedure declaration");
        externalProcedureType = new ExternalProcedureTypeNode();
        parametersTypeResolver = new CollectResolver<TypeNode>(new DeclarationTypeResolver<TypeNode>(TypeNode.class));
    }
}

