/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.FilterCharacter;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.FilterFunctionTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.FilterFunction;
import de.unika.ipd.grgen.ir.executable.FilterFunctionExternal;
import de.unika.ipd.grgen.ir.executable.FilterFunctionInternal;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import java.util.Collection;
import java.util.Vector;

public class FilterFunctionDeclNode
extends DeclNode
implements FilterCharacter {
    protected CollectNode<BaseNode> paramsUnresolved;
    protected CollectNode<DeclNode> params;
    public CollectNode<EvalStatementNode> evalStatements;
    static final FilterFunctionTypeNode filterFunctionType;
    protected IdentNode actionUnresolved;
    public ActionDeclNode action;
    private static final DeclarationResolver<ActionDeclNode> actionResolver;

    public FilterFunctionDeclNode(IdentNode identNode, CollectNode<EvalStatementNode> collectNode, CollectNode<BaseNode> collectNode2, IdentNode identNode2) {
        super(identNode, filterFunctionType);
        this.evalStatements = collectNode;
        this.becomeParent(this.evalStatements);
        this.paramsUnresolved = collectNode2;
        this.becomeParent(this.paramsUnresolved);
        this.actionUnresolved = identNode2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        if (this.evalStatements != null) {
            vector.add(this.evalStatements);
        }
        vector.add(this.paramsUnresolved);
        vector.add(this.actionUnresolved);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        if (this.evalStatements != null) {
            vector.add("evals");
        }
        vector.add("params");
        vector.add("action");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!(this.actionUnresolved instanceof PackageIdentNode)) {
            FilterFunctionDeclNode.fixupDefinition(this.actionUnresolved, this.actionUnresolved.getScope());
        }
        this.action = (ActionDeclNode)actionResolver.resolve(this.actionUnresolved, this);
        return this.action != null;
    }

    @Override
    protected boolean checkLocal() {
        this.params = new CollectNode();
        for (BaseNode baseNode : this.paramsUnresolved.getChildren()) {
            BaseNode baseNode2;
            if (baseNode instanceof ConnectionNode) {
                baseNode2 = (ConnectionNode)baseNode;
                this.params.addChild(baseNode2.getEdge().getDecl());
                continue;
            }
            if (baseNode instanceof SingleNodeConnNode) {
                baseNode2 = ((SingleNodeConnNode)baseNode).getNode();
                this.params.addChild((DeclNode)baseNode2);
                continue;
            }
            if (baseNode instanceof VarDeclNode) {
                this.params.addChild((VarDeclNode)baseNode);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported parameter (" + baseNode + ")");
        }
        return true;
    }

    @Override
    public String getFilterName() {
        return this.getIdentNode().toString();
    }

    @Override
    public ActionDeclNode getActionNode() {
        return this.action;
    }

    public FilterFunction getFilterFunction() {
        return this.checkIR(FilterFunction.class);
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return filterFunctionType;
    }

    public Vector<TypeNode> getParameterTypes() {
        assert (this.isChecked());
        Vector<TypeNode> vector = new Vector<TypeNode>();
        for (DeclNode declNode : this.params.getChildren()) {
            vector.add(declNode.getDeclType());
        }
        return vector;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        FilterFunction filterFunction = this.evalStatements != null ? new FilterFunctionInternal(this.getIdentNode().toString(), this.getIdentNode().getIdent()) : new FilterFunctionExternal(this.getIdentNode().toString(), this.getIdentNode().getIdent());
        this.setIR(filterFunction);
        filterFunction.setAction(this.action.getMatcher());
        this.action.getMatcher().addFilter(filterFunction);
        for (DeclNode baseNode : this.params.getChildren()) {
            filterFunction.addParameter(baseNode.checkIR(Entity.class));
        }
        if (this.evalStatements != null) {
            for (EvalStatementNode evalStatementNode : this.evalStatements.getChildren()) {
                ((FilterFunctionInternal)filterFunction).addStatement(evalStatementNode.checkIR(EvalStatement.class));
            }
        }
        return filterFunction;
    }

    public static String getKindStr() {
        return "filter function";
    }

    static {
        FilterFunctionDeclNode.setName(FilterFunctionDeclNode.class, "filter function declaration");
        filterFunctionType = new FilterFunctionTypeNode();
        actionResolver = new DeclarationResolver<ActionDeclNode>(ActionDeclNode.class);
    }
}

