/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CallActionNode;
import de.unika.ipd.grgen.ast.ExecNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoSuppliedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeCaseDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAccumulationMethodNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.ImplicitNegComputer;
import de.unika.ipd.grgen.ast.pattern.ImplicitNegComputerInduced;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public abstract class MatcherDeclNode
extends DeclNode {
    public PatternGraphLhsNode pattern;

    public MatcherDeclNode(IdentNode identNode, TypeNode typeNode, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, typeNode);
        this.pattern = patternGraphLhsNode;
        this.becomeParent(this.pattern);
    }

    public Rule getMatcher() {
        return this.checkIR(Rule.class);
    }

    protected static boolean resolveFilters(ArrayList<FilterAutoDeclNode> arrayList) {
        boolean bl = true;
        for (FilterAutoDeclNode filterAutoDeclNode : arrayList) {
            if (filterAutoDeclNode instanceof FilterAutoSuppliedDeclNode) {
                bl &= ((FilterAutoSuppliedDeclNode)filterAutoDeclNode).resolve();
                continue;
            }
            bl &= ((FilterAutoGeneratedDeclNode)filterAutoDeclNode).resolve();
        }
        return bl;
    }

    protected boolean checkFilters(PatternGraphLhsNode patternGraphLhsNode, ArrayList<FilterAutoDeclNode> arrayList) {
        boolean bl = true;
        for (FilterAutoDeclNode object2 : arrayList) {
            if (object2 instanceof FilterAutoSuppliedDeclNode) {
                bl &= ((FilterAutoSuppliedDeclNode)object2).check();
                continue;
            }
            bl &= ((FilterAutoGeneratedDeclNode)object2).check();
        }
        boolean bl2 = true;
        HashSet<String> hashSet = new HashSet<String>();
        for (FilterAutoDeclNode filterAutoDeclNode : arrayList) {
            if (!(filterAutoDeclNode instanceof FilterAutoGeneratedDeclNode)) continue;
            FilterAutoGeneratedDeclNode filterAutoGeneratedDeclNode = (FilterAutoGeneratedDeclNode)filterAutoDeclNode;
            String string = filterAutoGeneratedDeclNode.getFilterNameWithEntitySuffix();
            if (hashSet.contains(string)) {
                this.reportError("The filter " + string + " was already declared for " + patternGraphLhsNode.nameOfGraph + ", only one declaration is admissible.");
                bl2 = false;
            } else {
                hashSet.add(string);
            }
            bl2 &= this.checkAutoGeneratedFilter(filterAutoGeneratedDeclNode);
        }
        return bl & bl2;
    }

    protected boolean checkAutoGeneratedFilter(FilterAutoGeneratedDeclNode filterAutoGeneratedDeclNode) {
        String string = filterAutoGeneratedDeclNode.getFilterNameWithEntitySuffix();
        switch (filterAutoGeneratedDeclNode.name) {
            case "orderAscendingBy": 
            case "orderDescendingBy": {
                boolean bl = true;
                for (String string2 : filterAutoGeneratedDeclNode.entities) {
                    bl &= this.pattern.checkFilterVariable(this.getIdentNode(), string, string2);
                }
                return bl;
            }
            case "keepOneForEach": 
            case "groupBy": 
            case "keepSameAsFirst": 
            case "keepSameAsLast": {
                boolean bl = true;
                for (String string3 : filterAutoGeneratedDeclNode.entities) {
                    bl &= this.pattern.checkFilterEntity(this.getIdentNode(), string, string3);
                }
                if (filterAutoGeneratedDeclNode.entities.size() != 1) {
                    this.reportError("The filter " + filterAutoGeneratedDeclNode.getFilterName() + " must be declared with exactly one variable, but is declared with " + filterAutoGeneratedDeclNode.entities.size() + " variables" + this.filterSpecification(string) + ".");
                    bl = false;
                }
                return bl;
            }
            case "keepOneForEachAccumulateBy": {
                if (filterAutoGeneratedDeclNode.entities.size() != 3) {
                    this.getIdentNode().reportError("The filter " + filterAutoGeneratedDeclNode.getFilterName() + " must be declared with exactly one variable, one accumulation variable, and one accumulation method, but is declared with " + filterAutoGeneratedDeclNode.entities.size() + " entities" + this.filterSpecification(string) + ".");
                    return false;
                }
                if (filterAutoGeneratedDeclNode.entities.get(0).equals(filterAutoGeneratedDeclNode.entities.get(1))) {
                    this.getIdentNode().reportError("The accumulation variable must be different from the variable " + filterAutoGeneratedDeclNode.entities.get(0) + this.filterSpecification(string) + ".");
                    return false;
                }
                boolean bl = this.pattern.checkFilterEntity(this.getIdentNode(), string, filterAutoGeneratedDeclNode.entities.get(0));
                if (!bl) {
                    return false;
                }
                ArrayAccumulationMethodNode arrayAccumulationMethodNode = ArrayAccumulationMethodNode.getArrayMethodNode(filterAutoGeneratedDeclNode.entities.get(2));
                if (arrayAccumulationMethodNode == null) {
                    this.getIdentNode().reportError("The array accumulation method " + filterAutoGeneratedDeclNode.entities.get(2) + " is not known" + this.filterSpecification(string) + ".");
                    return false;
                }
                VarDeclNode varDeclNode = this.pattern.tryGetVar(filterAutoGeneratedDeclNode.entities.get(1));
                if (varDeclNode == null) {
                    this.getIdentNode().reportError("Unknown accumulation variable " + filterAutoGeneratedDeclNode.entities.get(1) + this.filterSpecification(string) + ".");
                    return false;
                }
                TypeNode typeNode = varDeclNode.getDeclType();
                if (!arrayAccumulationMethodNode.isValidTargetTypeOfAccumulation(typeNode)) {
                    this.getIdentNode().reportError("The array accumulation method " + filterAutoGeneratedDeclNode.entities.get(2) + " is not applicable to the type " + typeNode.getTypeName() + " of the accumulation variable " + filterAutoGeneratedDeclNode.entities.get(1) + " / its result cannot be assigned to the accumulation variable. (Allowed are: " + arrayAccumulationMethodNode.getValidTargetTypesOfAccumulation() + ")" + this.filterSpecification(string) + ".");
                    return false;
                }
                return true;
            }
            case "auto": {
                return true;
            }
        }
        assert (false);
        return false;
    }

    private String filterSpecification(String string) {
        return " (in filter " + string + " for " + this.pattern.nameOfGraph + ")";
    }

    protected boolean checkNonAction(RhsDeclNode rhsDeclNode) {
        boolean bl = this.checkLeft();
        boolean bl2 = true;
        if (rhsDeclNode != null) {
            bl2 = rhsDeclNode.checkAgainstLhsPattern(this.pattern);
        }
        boolean bl3 = true;
        if (this.pattern.returns.size() > 0) {
            this.reportError("A return statement is not allowed in a " + this.getKind() + ".");
            bl3 = false;
        }
        boolean bl4 = true;
        if (rhsDeclNode != null && rhsDeclNode.patternGraph.returns.size() > 0) {
            this.reportError("A return statement is not allowed in a " + this.getKind() + ".");
            bl4 = false;
        }
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = this.sameNumberOfRewriteParts(rhsDeclNode, this.getKind());
        boolean bl8 = true;
        if (rhsDeclNode != null) {
            bl5 = this.checkRhsReuse(rhsDeclNode);
            bl6 = this.checkExecParamsNotDeleted(rhsDeclNode);
            bl8 = this.noNestedRewriteParameters(rhsDeclNode, this.getKind());
        }
        return bl & bl2 & bl7 & bl8 & bl5 & bl3 & bl4 & bl6;
    }

    protected boolean checkLeft() {
        boolean bl = true;
        LinkedList<PatternGraphLhsNode> linkedList = new LinkedList<PatternGraphLhsNode>();
        linkedList.add(this.pattern);
        for (PatternGraphLhsNode object2 : this.pattern.negs.getChildren()) {
            linkedList.add(object2);
        }
        for (PatternGraphLhsNode patternGraphLhsNode : this.pattern.idpts.getChildren()) {
            linkedList.add(patternGraphLhsNode);
        }
        PatternGraphLhsNode[] patternGraphLhsNodeArray = linkedList.toArray(new PatternGraphLhsNode[0]);
        HashSet<EdgeDeclNode> hashSet = new HashSet<EdgeDeclNode>();
        for (int i = 0; i < patternGraphLhsNodeArray.length; ++i) {
            for (ConnectionCharacter connectionCharacter : patternGraphLhsNodeArray[i].getConnections()) {
                if (!(connectionCharacter instanceof ConnectionNode)) continue;
                ConnectionNode connectionNode = (ConnectionNode)connectionCharacter;
                for (int j = i + 1; j < patternGraphLhsNodeArray.length; ++j) {
                    for (ConnectionCharacter connectionCharacter2 : patternGraphLhsNodeArray[j].getConnections()) {
                        if (!(connectionCharacter2 instanceof ConnectionNode)) continue;
                        ConnectionNode connectionNode2 = (ConnectionNode)connectionCharacter2;
                        if (!connectionNode.getEdge().equals(connectionNode2.getEdge()) || hashSet.contains(connectionNode.getEdge())) continue;
                        bl &= MatcherDeclNode.isLhsEdgeReuseOk(hashSet, connectionNode, connectionNode2);
                    }
                }
            }
        }
        return bl;
    }

    private static boolean isLhsEdgeReuseOk(Collection<EdgeDeclNode> collection, ConnectionNode connectionNode, ConnectionNode connectionNode2) {
        boolean bl = true;
        NodeDeclNode nodeDeclNode = connectionNode.getSrc();
        NodeDeclNode nodeDeclNode2 = connectionNode.getTgt();
        NodeDeclNode nodeDeclNode3 = connectionNode2.getSrc();
        NodeDeclNode nodeDeclNode4 = connectionNode2.getTgt();
        assert (!(nodeDeclNode instanceof NodeTypeChangeDeclNode)) : "no type changes in test actions";
        assert (!(nodeDeclNode2 instanceof NodeTypeChangeDeclNode)) : "no type changes in test actions";
        assert (!(nodeDeclNode3 instanceof NodeTypeChangeDeclNode)) : "no type changes in test actions";
        assert (!(nodeDeclNode4 instanceof NodeTypeChangeDeclNode)) : "no type changes in test actions";
        if (!(nodeDeclNode instanceof NodeDeclNode && nodeDeclNode.isDummy() || nodeDeclNode3 instanceof NodeDeclNode && nodeDeclNode3.isDummy() || nodeDeclNode == nodeDeclNode3)) {
            collection.add(connectionNode.getEdge());
            connectionNode2.reportError("Reused edge " + connectionNode.getEdge() + " does not connect the same source nodes" + MatcherDeclNode.differsFromSpecification(nodeDeclNode, nodeDeclNode3, true) + ".");
            bl = false;
        }
        if (!(nodeDeclNode2 instanceof NodeDeclNode && nodeDeclNode2.isDummy() || nodeDeclNode4 instanceof NodeDeclNode && nodeDeclNode4.isDummy() || nodeDeclNode2 == nodeDeclNode4 || collection.contains(connectionNode.getEdge()))) {
            collection.add(connectionNode.getEdge());
            connectionNode2.reportError("Reused edge " + connectionNode.getEdge() + " does not connect the same target nodes" + MatcherDeclNode.differsFromSpecification(nodeDeclNode2, nodeDeclNode4, true) + ".");
            bl = false;
        }
        if (connectionNode.getConnectionKind() != connectionNode2.getConnectionKind()) {
            collection.add(connectionNode.getEdge());
            connectionNode2.reportError("Reused edge " + connectionNode.getEdge() + " does not have the same connection kind (" + ConnectionNode.toString(connectionNode.getConnectionKind()) + " differs from nested " + ConnectionNode.toString(connectionNode2.getConnectionKind()) + ").");
            bl = false;
        }
        return bl;
    }

    private static String differsFromSpecification(NodeDeclNode nodeDeclNode, NodeDeclNode nodeDeclNode2, boolean bl) {
        return " (" + nodeDeclNode.userFriendlyToString() + " differs from " + (bl ? "nested " : "") + nodeDeclNode2.userFriendlyToString() + ")";
    }

    protected boolean checkRhsReuse(RhsDeclNode rhsDeclNode) {
        boolean bl = true;
        HashMap<EdgeDeclNode, NodeDeclNode> hashMap = new HashMap<EdgeDeclNode, NodeDeclNode>();
        HashMap<EdgeDeclNode, NodeDeclNode> hashMap2 = new HashMap<EdgeDeclNode, NodeDeclNode>();
        HashSet<EdgeDeclNode> hashSet = new HashSet<EdgeDeclNode>();
        for (ConnectionNode connectionNode : rhsDeclNode.getConnectionsToReuse(this.pattern)) {
            EdgeDeclNode edgeDeclNode = connectionNode.getEdge();
            if (edgeDeclNode instanceof EdgeTypeChangeDeclNode) {
                edgeDeclNode = ((EdgeTypeChangeDeclNode)edgeDeclNode).getOldEdge();
            }
            for (ConnectionCharacter connectionCharacter : this.pattern.getConnections()) {
                ConnectionNode connectionNode2;
                EdgeDeclNode edgeDeclNode2;
                if (!(connectionCharacter instanceof ConnectionNode) || !(edgeDeclNode2 = (connectionNode2 = (ConnectionNode)connectionCharacter).getEdge()).equals(edgeDeclNode)) continue;
                if (connectionNode2.getConnectionKind() != connectionNode.getConnectionKind()) {
                    bl = false;
                    connectionNode.reportError("Reused edge " + edgeDeclNode + " does not have the same connection kind (in pattern: " + ConnectionNode.toString(connectionNode2.getConnectionKind()) + ", but in rewrite part: " + ConnectionNode.toString(connectionNode.getConnectionKind()) + ").");
                    hashSet.add(edgeDeclNode);
                }
                bl &= this.isLhsRhsReuseOk(hashSet, hashMap, hashMap2, rhsDeclNode, connectionNode2, connectionNode);
            }
        }
        return bl;
    }

    private boolean isLhsRhsReuseOk(Collection<EdgeDeclNode> collection, HashMap<EdgeDeclNode, NodeDeclNode> hashMap, HashMap<EdgeDeclNode, NodeDeclNode> hashMap2, RhsDeclNode rhsDeclNode, ConnectionNode connectionNode, ConnectionNode connectionNode2) {
        NodeDeclNode nodeDeclNode = connectionNode2.getSrc();
        NodeDeclNode nodeDeclNode2 = connectionNode2.getTgt();
        HashSet<BaseNode> hashSet = new HashSet<BaseNode>();
        hashSet.addAll(rhsDeclNode.getNodesToReuse(this.pattern));
        if (nodeDeclNode instanceof NodeTypeChangeDeclNode) {
            nodeDeclNode = ((NodeTypeChangeDeclNode)nodeDeclNode).getOldNode();
            hashSet.add(nodeDeclNode);
        }
        if (nodeDeclNode2 instanceof NodeTypeChangeDeclNode) {
            nodeDeclNode2 = ((NodeTypeChangeDeclNode)nodeDeclNode2).getOldNode();
            hashSet.add(nodeDeclNode2);
        }
        boolean bl = true;
        bl &= this.isLhsRhsSourceReuseOk(collection, hashMap, connectionNode, connectionNode2, nodeDeclNode, hashSet);
        return bl &= this.isLhsRhsTargetReuseOk(collection, hashMap2, connectionNode, connectionNode2, nodeDeclNode2, hashSet);
    }

    private boolean isLhsRhsSourceReuseOk(Collection<EdgeDeclNode> collection, HashMap<EdgeDeclNode, NodeDeclNode> hashMap, ConnectionNode connectionNode, ConnectionNode connectionNode2, NodeDeclNode nodeDeclNode, HashSet<BaseNode> hashSet) {
        boolean bl = true;
        EdgeDeclNode edgeDeclNode = connectionNode.getEdge();
        EdgeDeclNode edgeDeclNode2 = connectionNode2.getEdge();
        NodeDeclNode nodeDeclNode2 = connectionNode.getSrc();
        if (!nodeDeclNode2.isDummy()) {
            if (nodeDeclNode.isDummy()) {
                if (hashSet.contains(nodeDeclNode2)) {
                    connectionNode2.setSrc(nodeDeclNode2);
                } else if (!collection.contains(edgeDeclNode2)) {
                    bl = false;
                    connectionNode2.reportError("The source node" + nodeDeclNode2.emptyWhenAnonymousInParenthesis(" ") + " of reused/referenced edge " + edgeDeclNode + " must be reused/referenced, too.");
                    collection.add(edgeDeclNode2);
                }
            } else if (nodeDeclNode2 != nodeDeclNode && (connectionNode2.getRedirectionKind() & 1) != 1 && !collection.contains(edgeDeclNode2)) {
                bl = false;
                connectionNode2.reportError("Reused/referenced edge " + edgeDeclNode + " does not connect the same (source) nodes (and is not declared to redirect source)" + MatcherDeclNode.differsFromSpecification(nodeDeclNode2, nodeDeclNode, false) + ".");
                collection.add(edgeDeclNode2);
            }
        }
        if ((connectionNode2.getRedirectionKind() & 1) == 1) {
            if (nodeDeclNode.isDummy()) {
                bl = false;
                connectionNode2.reportError("A source redirection is specified for edge " + edgeDeclNode + ", but no source node is given.");
            }
            if (nodeDeclNode2.equals(nodeDeclNode)) {
                connectionNode2.reportWarning("Redirecting edge " + edgeDeclNode + " to the same source node again (" + nodeDeclNode + ").");
            }
            if (hashMap.containsKey(edgeDeclNode)) {
                bl = false;
                NodeDeclNode nodeDeclNode3 = hashMap.get(edgeDeclNode);
                connectionNode2.reportError("The source of edge " + edgeDeclNode + " is redirected more than once (to " + nodeDeclNode.userFriendlyToString() + " and to " + nodeDeclNode3.userFriendlyToString() + ").");
            }
            hashMap.put(edgeDeclNode, nodeDeclNode);
        }
        if (!collection.contains(edgeDeclNode2) && nodeDeclNode2.isDummy() && !nodeDeclNode.isDummy() && (connectionNode2.getRedirectionKind() & 1) != 1) {
            bl = false;
            connectionNode2.reportError("Reused edge " + edgeDeclNode + " dangles on LHS, but has a source node on RHS" + nodeDeclNode.emptyWhenAnonymousInParenthesis(" ") + ".");
            collection.add(edgeDeclNode2);
        }
        return bl;
    }

    private boolean isLhsRhsTargetReuseOk(Collection<EdgeDeclNode> collection, HashMap<EdgeDeclNode, NodeDeclNode> hashMap, ConnectionNode connectionNode, ConnectionNode connectionNode2, NodeDeclNode nodeDeclNode, HashSet<BaseNode> hashSet) {
        boolean bl = true;
        EdgeDeclNode edgeDeclNode = connectionNode.getEdge();
        EdgeDeclNode edgeDeclNode2 = connectionNode2.getEdge();
        NodeDeclNode nodeDeclNode2 = connectionNode.getTgt();
        if (!nodeDeclNode2.isDummy()) {
            if (nodeDeclNode.isDummy()) {
                if (hashSet.contains(nodeDeclNode2)) {
                    connectionNode2.setTgt(nodeDeclNode2);
                } else if (!collection.contains(edgeDeclNode2)) {
                    bl = false;
                    connectionNode2.reportError("The target node" + nodeDeclNode2.emptyWhenAnonymousInParenthesis(" ") + " of reused/referenced edge " + edgeDeclNode + " must be reused/referenced, too.");
                    collection.add(edgeDeclNode2);
                }
            } else if (nodeDeclNode2 != nodeDeclNode && (connectionNode2.getRedirectionKind() & 2) != 2 && !collection.contains(edgeDeclNode2)) {
                bl = false;
                connectionNode2.reportError("Reused/referenced edge " + edgeDeclNode + " does not connect the same (target) nodes (and is not declared to redirect target)" + MatcherDeclNode.differsFromSpecification(nodeDeclNode2, nodeDeclNode, false) + ".");
                collection.add(edgeDeclNode2);
            }
        }
        if ((connectionNode2.getRedirectionKind() & 2) == 2) {
            if (nodeDeclNode.isDummy()) {
                bl = false;
                connectionNode2.reportError("A target redirection is specified for edge " + edgeDeclNode + ", but no target node is given.");
            }
            if (nodeDeclNode2.equals(nodeDeclNode)) {
                connectionNode2.reportWarning("Redirecting edge " + edgeDeclNode + " to the same target node again (" + nodeDeclNode + ").");
            }
            if (hashMap.containsKey(edgeDeclNode)) {
                bl = false;
                NodeDeclNode nodeDeclNode3 = hashMap.get(edgeDeclNode);
                connectionNode2.reportError("The target of edge " + edgeDeclNode + " is redirected more than once (to " + nodeDeclNode.userFriendlyToString() + " and to " + nodeDeclNode3.userFriendlyToString() + ").");
            }
            hashMap.put(edgeDeclNode, nodeDeclNode);
        }
        if (!collection.contains(edgeDeclNode2) && nodeDeclNode2.isDummy() && !nodeDeclNode.isDummy() && (connectionNode2.getRedirectionKind() & 2) != 2) {
            bl = false;
            connectionNode2.reportError("Reused edge " + edgeDeclNode + " dangles on LHS, but has a target node on RHS" + nodeDeclNode.emptyWhenAnonymousInParenthesis(" ") + ".");
            collection.add(edgeDeclNode2);
        }
        return bl;
    }

    protected boolean checkExecParamsNotDeleted(RhsDeclNode rhsDeclNode) {
        assert (this.isResolved());
        boolean bl = true;
        Set<ConstraintDeclNode> set = rhsDeclNode.getElementsToDelete(this.pattern);
        Set<ConstraintDeclNode> set2 = rhsDeclNode.getMaybeDeletedElements(this.pattern);
        for (BaseNode baseNode : rhsDeclNode.patternGraph.imperativeStmts.getChildren()) {
            if (!(baseNode instanceof ExecNode)) continue;
            ExecNode execNode = (ExecNode)baseNode;
            for (CallActionNode callActionNode : execNode.callActions.getChildren()) {
                for (ExprNode exprNode : callActionNode.params.getChildren()) {
                    HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
                    exprNode.getPotentiallyResultingElements(hashSet);
                    for (ConstraintDeclNode constraintDeclNode : hashSet) {
                        bl &= MatcherDeclNode.checkExecParamNotDeleted(constraintDeclNode, set, set2);
                    }
                }
            }
        }
        return bl;
    }

    private static boolean checkExecParamNotDeleted(ConstraintDeclNode constraintDeclNode, Set<ConstraintDeclNode> set, Set<ConstraintDeclNode> set2) {
        if (set.contains(constraintDeclNode)) {
            constraintDeclNode.reportError("The deleted " + constraintDeclNode.getKind() + " " + constraintDeclNode + " is not allowed to be passed to an exec statement.");
            return false;
        }
        if (set2.contains(constraintDeclNode)) {
            constraintDeclNode.maybeDeleted = true;
            if (!constraintDeclNode.getIdentNode().getAnnotations().isFlagSet("maybeDeleted")) {
                String string = "The parameter " + constraintDeclNode + " of the exec statement may be deleted.";
                string = string + " Possibly it is homomorphic with a deleted " + constraintDeclNode.getKind();
                string = string + " (use a [maybeDeleted] annotation if you think that this does not cause problems)";
                if (constraintDeclNode instanceof EdgeDeclNode) {
                    string = string + ", or " + constraintDeclNode + " is a dangling edge and a deleted node exists";
                }
                string = string + ".";
                constraintDeclNode.reportError(string);
                return false;
            }
        }
        return true;
    }

    protected boolean sameNumberOfRewriteParts(RhsDeclNode rhsDeclNode, String string) {
        boolean bl = true;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : declNode.getChildren()) {
                if (rhsDeclNode == null && alternativeCaseDeclNode.right != null) {
                    alternativeCaseDeclNode.reportError("No rewrite part is specified in the " + string + (this.ident.getCurrOcc().isAnonymous() ? "" : " " + this.ident) + ", but one is given in the nested " + alternativeCaseDeclNode.getKind() + " " + alternativeCaseDeclNode.ident + ".");
                    bl = false;
                }
                if (rhsDeclNode == null || alternativeCaseDeclNode.right != null) continue;
                alternativeCaseDeclNode.reportError("A rewrite part is specified in the " + string + (this.ident.getCurrOcc().isAnonymous() ? "" : " " + this.ident) + ", but none is given in the nested " + alternativeCaseDeclNode.getKind() + " " + alternativeCaseDeclNode.ident + ".");
                bl = false;
            }
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            if (rhsDeclNode == null && iteratedDeclNode.right != null) {
                iteratedDeclNode.reportError("No rewrite part is specified in the " + string + (this.ident.getCurrOcc().isAnonymous() ? "" : " " + this.ident) + ", but one is given in the nested " + iteratedDeclNode.getKind() + iteratedDeclNode.emptyWhenAnonymousPostfix(" ") + ".");
                bl = false;
            }
            if (rhsDeclNode == null || iteratedDeclNode.right != null) continue;
            iteratedDeclNode.reportError("A rewrite part is specified in the " + string + (this.ident.getCurrOcc().isAnonymous() ? "" : " " + this.ident) + ", but none is given in the nested " + iteratedDeclNode.getKind() + iteratedDeclNode.emptyWhenAnonymousPostfix(" ") + ".");
            bl = false;
        }
        return bl;
    }

    protected boolean noNestedRewriteParameters(RhsDeclNode rhsDeclNode, String string) {
        Object object;
        boolean bl = true;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            object = declNode.getChildren().iterator();
            while (object.hasNext()) {
                Vector<DeclNode> vector;
                AlternativeCaseDeclNode alternativeCaseDeclNode = object.next();
                if (alternativeCaseDeclNode.right == null || (vector = alternativeCaseDeclNode.right.patternGraph.getParamDecls()).size() == 0) continue;
                alternativeCaseDeclNode.reportError("No rewrite parameters are allowed in nested alternative cases, but " + vector.size() + " are given in " + alternativeCaseDeclNode.ident + ".");
                bl = false;
            }
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            if (iteratedDeclNode.right == null || ((Vector)(object = iteratedDeclNode.right.patternGraph.getParamDecls())).size() == 0) continue;
            iteratedDeclNode.reportError("No rewrite parameters are allowed in nested " + iteratedDeclNode.getKind() + " parts, but " + ((Vector)object).size() + " are given" + iteratedDeclNode.emptyWhenAnonymous(" in " + iteratedDeclNode.ident) + ".");
            bl = false;
        }
        return bl;
    }

    protected boolean noAmbiguousRetypes(RhsDeclNode rhsDeclNode) {
        if (rhsDeclNode == null) {
            return false;
        }
        boolean bl = true;
        for (NodeDeclNode declNode : this.pattern.getNodes()) {
            if (declNode.directlyNestingLHSGraph != this.pattern) continue;
            bl &= this.noAmbiguousRetypes(rhsDeclNode, declNode);
        }
        for (EdgeDeclNode edgeDeclNode : this.pattern.getEdges()) {
            if (edgeDeclNode.directlyNestingLHSGraph != this.pattern) continue;
            bl &= this.noAmbiguousRetypes(rhsDeclNode, edgeDeclNode);
        }
        for (AlternativeDeclNode alternativeDeclNode : this.pattern.alts.getChildren()) {
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : alternativeDeclNode.getChildren()) {
                bl &= alternativeCaseDeclNode.noAmbiguousRetypes(alternativeCaseDeclNode.right);
            }
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            bl &= iteratedDeclNode.noAmbiguousRetypes(iteratedDeclNode.right);
        }
        return bl;
    }

    protected boolean noAmbiguousRetypes(RhsDeclNode rhsDeclNode, NodeDeclNode nodeDeclNode) {
        boolean bl = true;
        NodeTypeChangeDeclNode nodeTypeChangeDeclNode = null;
        Pair<Boolean, NodeTypeChangeDeclNode> pair = rhsDeclNode.getRhsGraph().noAmbiguousRetypes(nodeDeclNode, nodeTypeChangeDeclNode);
        bl &= ((Boolean)pair.first).booleanValue();
        nodeTypeChangeDeclNode = (NodeTypeChangeDeclNode)pair.second;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            NodeTypeChangeDeclNode nodeTypeChangeDeclNode2 = null;
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : declNode.getChildren()) {
                pair = alternativeCaseDeclNode.noAmbiguousRetypes(alternativeCaseDeclNode.right, nodeDeclNode, nodeTypeChangeDeclNode);
                bl &= ((Boolean)pair.first).booleanValue();
                if (nodeTypeChangeDeclNode2 != null) continue;
                nodeTypeChangeDeclNode2 = (NodeTypeChangeDeclNode)pair.second;
            }
            if (nodeTypeChangeDeclNode != null) continue;
            nodeTypeChangeDeclNode = nodeTypeChangeDeclNode2;
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            pair = iteratedDeclNode.noAmbiguousRetypes(iteratedDeclNode.right, nodeDeclNode, nodeTypeChangeDeclNode);
            bl &= ((Boolean)pair.first).booleanValue();
            if (nodeTypeChangeDeclNode != null) continue;
            nodeTypeChangeDeclNode = (NodeTypeChangeDeclNode)pair.second;
        }
        return bl;
    }

    protected boolean noAmbiguousRetypes(RhsDeclNode rhsDeclNode, EdgeDeclNode edgeDeclNode) {
        boolean bl = true;
        EdgeTypeChangeDeclNode edgeTypeChangeDeclNode = null;
        Pair<Boolean, EdgeTypeChangeDeclNode> pair = rhsDeclNode.getRhsGraph().noAmbiguousRetypes(edgeDeclNode, edgeTypeChangeDeclNode);
        bl &= ((Boolean)pair.first).booleanValue();
        edgeTypeChangeDeclNode = (EdgeTypeChangeDeclNode)pair.second;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            EdgeTypeChangeDeclNode edgeTypeChangeDeclNode2 = null;
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : declNode.getChildren()) {
                pair = alternativeCaseDeclNode.noAmbiguousRetypes(alternativeCaseDeclNode.right, edgeDeclNode, edgeTypeChangeDeclNode);
                bl &= ((Boolean)pair.first).booleanValue();
                if (edgeTypeChangeDeclNode2 != null) continue;
                edgeTypeChangeDeclNode2 = (EdgeTypeChangeDeclNode)pair.second;
            }
            if (edgeTypeChangeDeclNode != null) continue;
            edgeTypeChangeDeclNode = edgeTypeChangeDeclNode2;
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            pair = iteratedDeclNode.noAmbiguousRetypes(iteratedDeclNode.right, edgeDeclNode, edgeTypeChangeDeclNode);
            bl &= ((Boolean)pair.first).booleanValue();
            if (edgeTypeChangeDeclNode != null) continue;
            edgeTypeChangeDeclNode = (EdgeTypeChangeDeclNode)pair.second;
        }
        return bl;
    }

    protected Pair<Boolean, NodeTypeChangeDeclNode> noAmbiguousRetypes(RhsDeclNode rhsDeclNode, NodeDeclNode nodeDeclNode, NodeTypeChangeDeclNode nodeTypeChangeDeclNode) {
        if (rhsDeclNode == null) {
            return new Pair<Boolean, NodeTypeChangeDeclNode>(false, nodeTypeChangeDeclNode);
        }
        boolean bl = true;
        Pair<Boolean, NodeTypeChangeDeclNode> pair = rhsDeclNode.getRhsGraph().noAmbiguousRetypes(nodeDeclNode, nodeTypeChangeDeclNode);
        bl &= ((Boolean)pair.first).booleanValue();
        nodeTypeChangeDeclNode = (NodeTypeChangeDeclNode)pair.second;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            NodeTypeChangeDeclNode nodeTypeChangeDeclNode2 = null;
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : declNode.getChildren()) {
                pair = alternativeCaseDeclNode.noAmbiguousRetypes(alternativeCaseDeclNode.right, nodeDeclNode, nodeTypeChangeDeclNode);
                bl &= ((Boolean)pair.first).booleanValue();
                if (nodeTypeChangeDeclNode2 != null) continue;
                nodeTypeChangeDeclNode2 = (NodeTypeChangeDeclNode)pair.second;
            }
            if (nodeTypeChangeDeclNode != null) continue;
            nodeTypeChangeDeclNode = nodeTypeChangeDeclNode2;
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            pair = iteratedDeclNode.noAmbiguousRetypes(iteratedDeclNode.right, nodeDeclNode, nodeTypeChangeDeclNode);
            bl &= ((Boolean)pair.first).booleanValue();
            if (nodeTypeChangeDeclNode != null) continue;
            nodeTypeChangeDeclNode = (NodeTypeChangeDeclNode)pair.second;
        }
        return new Pair<Boolean, NodeTypeChangeDeclNode>(bl, nodeTypeChangeDeclNode);
    }

    protected Pair<Boolean, EdgeTypeChangeDeclNode> noAmbiguousRetypes(RhsDeclNode rhsDeclNode, EdgeDeclNode edgeDeclNode, EdgeTypeChangeDeclNode edgeTypeChangeDeclNode) {
        if (rhsDeclNode == null) {
            return new Pair<Boolean, EdgeTypeChangeDeclNode>(false, edgeTypeChangeDeclNode);
        }
        boolean bl = true;
        Pair<Boolean, EdgeTypeChangeDeclNode> pair = rhsDeclNode.getRhsGraph().noAmbiguousRetypes(edgeDeclNode, edgeTypeChangeDeclNode);
        bl &= ((Boolean)pair.first).booleanValue();
        edgeTypeChangeDeclNode = (EdgeTypeChangeDeclNode)pair.second;
        for (AlternativeDeclNode declNode : this.pattern.alts.getChildren()) {
            EdgeTypeChangeDeclNode edgeTypeChangeDeclNode2 = null;
            for (AlternativeCaseDeclNode alternativeCaseDeclNode : declNode.getChildren()) {
                pair = alternativeCaseDeclNode.noAmbiguousRetypes(alternativeCaseDeclNode.right, edgeDeclNode, edgeTypeChangeDeclNode);
                bl &= ((Boolean)pair.first).booleanValue();
                if (edgeTypeChangeDeclNode2 != null) continue;
                edgeTypeChangeDeclNode2 = (EdgeTypeChangeDeclNode)pair.second;
            }
            if (edgeTypeChangeDeclNode != null) continue;
            edgeTypeChangeDeclNode = edgeTypeChangeDeclNode2;
        }
        for (IteratedDeclNode iteratedDeclNode : this.pattern.iters.getChildren()) {
            pair = iteratedDeclNode.noAmbiguousRetypes(iteratedDeclNode.right, edgeDeclNode, edgeTypeChangeDeclNode);
            bl &= ((Boolean)pair.first).booleanValue();
            if (edgeTypeChangeDeclNode != null) continue;
            edgeTypeChangeDeclNode = (EdgeTypeChangeDeclNode)pair.second;
        }
        return new Pair<Boolean, EdgeTypeChangeDeclNode>(bl, edgeTypeChangeDeclNode);
    }

    protected void constructIRaux(Rule rule, RhsDeclNode rhsDeclNode) {
        this.addParams(rule);
        PatternGraphRhs patternGraphRhs = null;
        if (rhsDeclNode == null) {
            return;
        }
        patternGraphRhs = rhsDeclNode.getPatternGraph(this.pattern.getPatternGraph());
        for (DeclNode declNode : rhsDeclNode.patternGraph.getParamDecls()) {
            if (declNode instanceof NodeDeclNode) {
                patternGraphRhs.addReplParameter(declNode.checkIR(Node.class));
                patternGraphRhs.addSingleNode(((NodeDeclNode)declNode).getNode());
                continue;
            }
            if (declNode instanceof VarDeclNode) {
                patternGraphRhs.addReplParameter(declNode.checkIR(Variable.class));
                patternGraphRhs.addVariable(((VarDeclNode)declNode).getVariable());
                continue;
            }
            throw new IllegalArgumentException("unknown Class: " + declNode);
        }
        MatcherDeclNode.addReplacementParamsToNestedAlternativesAndIterateds(rule, rhsDeclNode);
    }

    protected void addParams(MatchingAction matchingAction) {
        PatternGraphLhs patternGraphLhs = matchingAction.getPattern();
        for (DeclNode declNode : this.pattern.getParamDecls()) {
            Entity entity = declNode.checkIR(Entity.class);
            if (entity.isDefToBeYieldedTo()) {
                matchingAction.addDefParameter(entity);
            } else {
                matchingAction.addParameter(entity);
            }
            if (!(declNode instanceof VarDeclNode)) continue;
            patternGraphLhs.addVariable(((VarDeclNode)declNode).getVariable());
        }
    }

    protected static void addReplacementParamsToNestedAlternativesAndIterateds(Rule rule, RhsDeclNode rhsDeclNode) {
        PatternGraphLhs patternGraphLhs = rule.getPattern();
        for (DeclNode declNode : rhsDeclNode.patternGraph.getParamDecls()) {
            if (declNode instanceof NodeDeclNode) {
                MatcherDeclNode.addReplacementNodeParamToNestedAlternativesAndIterateds((NodeDeclNode)declNode, patternGraphLhs);
                continue;
            }
            if (declNode instanceof VarDeclNode) {
                MatcherDeclNode.addReplacementVarParamToNestedAlternativesAndIterateds((VarDeclNode)declNode, patternGraphLhs);
                continue;
            }
            throw new IllegalArgumentException("unknown Class: " + declNode);
        }
    }

    private static void addReplacementNodeParamToNestedAlternativesAndIterateds(NodeDeclNode nodeDeclNode, PatternGraphLhs patternGraphLhs) {
        for (Alternative identifiable : patternGraphLhs.getAlts()) {
            for (Rule rule : identifiable.getAlternativeCases()) {
                rule.getRight().addReplParameter(nodeDeclNode.checkIR(Node.class));
                rule.getRight().addSingleNode(nodeDeclNode.getNode());
            }
        }
        for (Rule rule : patternGraphLhs.getIters()) {
            rule.getRight().addReplParameter(nodeDeclNode.checkIR(Node.class));
            rule.getRight().addSingleNode(nodeDeclNode.getNode());
        }
    }

    private static void addReplacementVarParamToNestedAlternativesAndIterateds(VarDeclNode varDeclNode, PatternGraphLhs patternGraphLhs) {
        for (Alternative identifiable : patternGraphLhs.getAlts()) {
            for (Rule rule : identifiable.getAlternativeCases()) {
                rule.getRight().addReplParameter(varDeclNode.checkIR(Variable.class));
                rule.getRight().addVariable(varDeclNode.getVariable());
            }
        }
        for (Rule rule : patternGraphLhs.getIters()) {
            rule.getRight().addReplParameter(varDeclNode.checkIR(Variable.class));
            rule.getRight().addVariable(varDeclNode.getVariable());
        }
    }

    protected void constructImplicitNegs(PatternGraphLhs patternGraphLhs) {
        PatternGraphLhsNode patternGraphLhsNode = this.pattern;
        ImplicitNegComputer implicitNegComputer = new ImplicitNegComputer(patternGraphLhsNode);
        ImplicitNegComputerInduced implicitNegComputerInduced = new ImplicitNegComputerInduced(patternGraphLhsNode);
        for (PatternGraphLhs patternGraphLhs2 : implicitNegComputer.getImplicitNegGraphs()) {
            patternGraphLhs.addNegGraph(patternGraphLhs2);
        }
        for (PatternGraphLhs patternGraphLhs2 : implicitNegComputerInduced.getImplicitNegGraphs()) {
            patternGraphLhs.addNegGraph(patternGraphLhs2);
        }
    }
}

