/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.ArithmeticOperatorNode;
import de.unika.ipd.grgen.ast.expr.BoolConstNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.MemberAccessExprNode;
import de.unika.ipd.grgen.ast.expr.TypeConstNode;
import de.unika.ipd.grgen.ast.expr.TypeofNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayInitNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeInitNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ObjectTypeNode;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.util.Base;

public class OperatorEvaluator {
    public static final OperatorEvaluator objectEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            ObjectTypeNode.Value value;
            ObjectTypeNode.Value value2;
            if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) != 2) {
                throw new NotEvaluatableException(coords);
            }
            try {
                value2 = (ObjectTypeNode.Value)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                value = (ObjectTypeNode.Value)this.getArgValue(exprNodeArray, operatorDeclNode, 1);
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, value2.equals(value));
                }
                case NE: {
                    return new BoolConstNode(coords, !value2.equals(value));
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator subgraphEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator nullEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) != 2) {
                throw new NotEvaluatableException(coords);
            }
            try {
                this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                this.getArgValue(exprNodeArray, operatorDeclNode, 1);
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, true);
                }
                case NE: {
                    return new BoolConstNode(coords, false);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator stringEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            Object object;
            String string;
            try {
                string = (String)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                object = this.getArgValue(exprNodeArray, operatorDeclNode, 1);
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            if (operatorDeclNode.getOperator() == OperatorDeclNode.Operator.ADD) {
                return new StringConstNode(coords, string + object);
            }
            String string2 = (String)object;
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, string.equals(string2));
                }
                case NE: {
                    return new BoolConstNode(coords, !string.equals(string2));
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator intEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            int n;
            int n2;
            try {
                n2 = (Integer)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                n = 0;
                if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) > 1) {
                    n = (Integer)this.getArgValue(exprNodeArray, operatorDeclNode, 1);
                }
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, n2 == n);
                }
                case NE: {
                    return new BoolConstNode(coords, n2 != n);
                }
                case LT: {
                    return new BoolConstNode(coords, n2 < n);
                }
                case LE: {
                    return new BoolConstNode(coords, n2 <= n);
                }
                case GT: {
                    return new BoolConstNode(coords, n2 > n);
                }
                case GE: {
                    return new BoolConstNode(coords, n2 >= n);
                }
                case ADD: {
                    return new IntConstNode(coords, n2 + n);
                }
                case SUB: {
                    return new IntConstNode(coords, n2 - n);
                }
                case MUL: {
                    return new IntConstNode(coords, n2 * n);
                }
                case DIV: {
                    return new IntConstNode(coords, n2 / n);
                }
                case MOD: {
                    return new IntConstNode(coords, n2 % n);
                }
                case SHL: {
                    return new IntConstNode(coords, n2 << n);
                }
                case SHR: {
                    return new IntConstNode(coords, n2 >> n);
                }
                case BIT_SHR: {
                    return new IntConstNode(coords, n2 >>> n);
                }
                case BIT_OR: {
                    return new IntConstNode(coords, n2 | n);
                }
                case BIT_AND: {
                    return new IntConstNode(coords, n2 & n);
                }
                case BIT_XOR: {
                    return new IntConstNode(coords, n2 ^ n);
                }
                case BIT_NOT: {
                    return new IntConstNode(coords, ~n2);
                }
                case NEG: {
                    return new IntConstNode(coords, -n2);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator longEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            long l;
            long l2;
            try {
                l2 = (Long)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                l = 0L;
                if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) > 1) {
                    l = (Long)this.getArgValue(exprNodeArray, operatorDeclNode, 1);
                }
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, l2 == l);
                }
                case NE: {
                    return new BoolConstNode(coords, l2 != l);
                }
                case LT: {
                    return new BoolConstNode(coords, l2 < l);
                }
                case LE: {
                    return new BoolConstNode(coords, l2 <= l);
                }
                case GT: {
                    return new BoolConstNode(coords, l2 > l);
                }
                case GE: {
                    return new BoolConstNode(coords, l2 >= l);
                }
                case ADD: {
                    return new LongConstNode(coords, l2 + l);
                }
                case SUB: {
                    return new LongConstNode(coords, l2 - l);
                }
                case MUL: {
                    return new LongConstNode(coords, l2 * l);
                }
                case DIV: {
                    return new LongConstNode(coords, l2 / l);
                }
                case MOD: {
                    return new LongConstNode(coords, l2 % l);
                }
                case SHL: {
                    return new LongConstNode(coords, l2 << (int)l);
                }
                case SHR: {
                    return new LongConstNode(coords, l2 >> (int)l);
                }
                case BIT_SHR: {
                    return new LongConstNode(coords, l2 >>> (int)l);
                }
                case BIT_OR: {
                    return new LongConstNode(coords, l2 | l);
                }
                case BIT_AND: {
                    return new LongConstNode(coords, l2 & l);
                }
                case BIT_XOR: {
                    return new LongConstNode(coords, l2 ^ l);
                }
                case BIT_NOT: {
                    return new LongConstNode(coords, l2 ^ 0xFFFFFFFFFFFFFFFFL);
                }
                case NEG: {
                    return new LongConstNode(coords, -l2);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator floatEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            float f;
            float f2;
            try {
                f2 = ((Float)this.getArgValue(exprNodeArray, operatorDeclNode, 0)).floatValue();
                f = 0.0f;
                if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) > 1) {
                    f = ((Float)this.getArgValue(exprNodeArray, operatorDeclNode, 1)).floatValue();
                }
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, f2 == f);
                }
                case NE: {
                    return new BoolConstNode(coords, f2 != f);
                }
                case LT: {
                    return new BoolConstNode(coords, f2 < f);
                }
                case LE: {
                    return new BoolConstNode(coords, f2 <= f);
                }
                case GT: {
                    return new BoolConstNode(coords, f2 > f);
                }
                case GE: {
                    return new BoolConstNode(coords, f2 >= f);
                }
                case ADD: {
                    return new FloatConstNode(coords, f2 + f);
                }
                case SUB: {
                    return new FloatConstNode(coords, f2 - f);
                }
                case MUL: {
                    return new FloatConstNode(coords, f2 * f);
                }
                case DIV: {
                    return new FloatConstNode(coords, f2 / f);
                }
                case MOD: {
                    return new FloatConstNode(coords, f2 % f);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator doubleEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            double d;
            double d2;
            try {
                d2 = (Double)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                d = 0.0;
                if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) > 1) {
                    d = (Double)this.getArgValue(exprNodeArray, operatorDeclNode, 1);
                }
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, d2 == d);
                }
                case NE: {
                    return new BoolConstNode(coords, d2 != d);
                }
                case LT: {
                    return new BoolConstNode(coords, d2 < d);
                }
                case LE: {
                    return new BoolConstNode(coords, d2 <= d);
                }
                case GT: {
                    return new BoolConstNode(coords, d2 > d);
                }
                case GE: {
                    return new BoolConstNode(coords, d2 >= d);
                }
                case ADD: {
                    return new DoubleConstNode(coords, d2 + d);
                }
                case SUB: {
                    return new DoubleConstNode(coords, d2 - d);
                }
                case MUL: {
                    return new DoubleConstNode(coords, d2 * d);
                }
                case DIV: {
                    return new DoubleConstNode(coords, d2 / d);
                }
                case MOD: {
                    return new DoubleConstNode(coords, d2 % d);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator typeEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            boolean bl;
            boolean bl2;
            TypeNode typeNode;
            if (exprNodeArray[0] instanceof TypeConstNode) {
                typeNode = (TypeNode)((TypeConstNode)exprNodeArray[0]).getValue();
                bl2 = typeNode instanceof NodeTypeNode;
            } else if (exprNodeArray[0] instanceof TypeofNode) {
                typeNode = ((TypeofNode)exprNodeArray[0]).getEntity().getDeclType();
                bl2 = typeNode instanceof NodeTypeNode;
            } else {
                throw new NotEvaluatableException(coords);
            }
            if (exprNodeArray[1] instanceof TypeConstNode) {
                typeNode = (TypeNode)((TypeConstNode)exprNodeArray[1]).getValue();
                bl = typeNode instanceof NodeTypeNode;
            } else if (exprNodeArray[1] instanceof TypeofNode) {
                typeNode = ((TypeofNode)exprNodeArray[1]).getEntity().getDeclType();
                bl = typeNode instanceof NodeTypeNode;
            } else {
                throw new NotEvaluatableException(coords);
            }
            if (bl2 != bl) {
                Base.error.warning(coords, "comparison between node and edge types will always fail");
                switch (operatorDeclNode.getOperator()) {
                    case EQ: 
                    case LT: 
                    case LE: 
                    case GT: 
                    case GE: {
                        return new BoolConstNode(coords, false);
                    }
                    case NE: {
                        return new BoolConstNode(coords, true);
                    }
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator booleanEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            boolean bl;
            boolean bl2;
            try {
                bl2 = (Boolean)this.getArgValue(exprNodeArray, operatorDeclNode, 0);
                bl = false;
                if (OperatorDeclNode.getArity(operatorDeclNode.getOperator()) > 1) {
                    bl = (Boolean)this.getArgValue(exprNodeArray, operatorDeclNode, 1);
                }
            }
            catch (ValueException valueException) {
                throw new NotEvaluatableException(coords);
            }
            switch (operatorDeclNode.getOperator()) {
                case EQ: {
                    return new BoolConstNode(coords, bl2 == bl);
                }
                case NE: {
                    return new BoolConstNode(coords, bl2 != bl);
                }
                case LOG_AND: {
                    return new BoolConstNode(coords, bl2 && bl);
                }
                case LOG_OR: {
                    return new BoolConstNode(coords, bl2 || bl);
                }
                case LOG_NOT: {
                    return new BoolConstNode(coords, !bl2);
                }
                case BIT_OR: {
                    return new BoolConstNode(coords, bl2 | bl);
                }
                case BIT_AND: {
                    return new BoolConstNode(coords, bl2 & bl);
                }
                case BIT_XOR: {
                    return new BoolConstNode(coords, bl2 ^ bl);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator condEvaluator = new OperatorEvaluator(){

        @Override
        public ExprNode evaluate(ExprNode exprNode, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) {
            try {
                return (Boolean)this.getArgValue(exprNodeArray, operatorDeclNode, 0) != false ? exprNodeArray[1] : exprNodeArray[2];
            }
            catch (ValueException valueException) {
                return exprNode;
            }
        }
    };
    public static final OperatorEvaluator mapEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            switch (operatorDeclNode.getOperator()) {
                case IN: {
                    MemberDeclNode memberDeclNode;
                    if (exprNodeArray[1] instanceof ArithmeticOperatorNode) {
                        ArithmeticOperatorNode arithmeticOperatorNode = (ArithmeticOperatorNode)exprNodeArray[1];
                        if (arithmeticOperatorNode.getOperator() == OperatorDeclNode.Operator.BIT_AND) {
                            ExprNode exprNode = (ExprNode)arithmeticOperatorNode.children.get(0);
                            ExprNode exprNode2 = (ExprNode)arithmeticOperatorNode.children.get(1);
                            ExprNode exprNode3 = new ArithmeticOperatorNode(exprNode.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode).evaluate();
                            ExprNode exprNode4 = new ArithmeticOperatorNode(exprNode2.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode2).evaluate();
                            return new ArithmeticOperatorNode(arithmeticOperatorNode.getCoords(), OperatorDeclNode.Operator.LOG_AND, exprNode3, exprNode4).evaluate();
                        }
                        if (arithmeticOperatorNode.getOperator() != OperatorDeclNode.Operator.BIT_OR) break;
                        ExprNode exprNode = (ExprNode)arithmeticOperatorNode.children.get(0);
                        ExprNode exprNode5 = (ExprNode)arithmeticOperatorNode.children.get(1);
                        ExprNode exprNode6 = new ArithmeticOperatorNode(exprNode.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode).evaluate();
                        ExprNode exprNode7 = new ArithmeticOperatorNode(exprNode5.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode5).evaluate();
                        return new ArithmeticOperatorNode(arithmeticOperatorNode.getCoords(), OperatorDeclNode.Operator.LOG_OR, exprNode6, exprNode7).evaluate();
                    }
                    if (!(exprNodeArray[0] instanceof ConstNode)) break;
                    ConstNode constNode = (ConstNode)exprNodeArray[0];
                    MapInitNode mapInitNode = null;
                    if (exprNodeArray[1] instanceof MapInitNode) {
                        mapInitNode = (MapInitNode)exprNodeArray[1];
                    } else if (exprNodeArray[1] instanceof MemberAccessExprNode && (memberDeclNode = ((MemberAccessExprNode)exprNodeArray[1]).getDecl()).isConst() && memberDeclNode.getConstInitializer() != null) {
                        mapInitNode = (MapInitNode)memberDeclNode.getConstInitializer();
                    }
                    if (mapInitNode == null) break;
                    if (mapInitNode.contains(constNode)) {
                        return new BoolConstNode(coords, true);
                    }
                    if (!mapInitNode.areKeysConstant()) break;
                    return new BoolConstNode(coords, false);
                }
                case INDEX: {
                    BaseNode baseNode;
                    if (!(exprNodeArray[1] instanceof ConstNode)) break;
                    ConstNode constNode = (ConstNode)exprNodeArray[1];
                    MapInitNode mapInitNode = null;
                    if (exprNodeArray[0] instanceof MapInitNode) {
                        mapInitNode = (MapInitNode)exprNodeArray[0];
                    } else if (exprNodeArray[0] instanceof MemberAccessExprNode && ((MemberDeclNode)(baseNode = ((MemberAccessExprNode)exprNodeArray[0]).getDecl())).isConst() && ((MemberDeclNode)baseNode).getConstInitializer() != null) {
                        mapInitNode = (MapInitNode)((MemberDeclNode)baseNode).getConstInitializer();
                    }
                    if (mapInitNode == null) break;
                    baseNode = mapInitNode.getAtIndex(constNode);
                    if (!mapInitNode.isConstant() || !(baseNode instanceof ConstNode)) break;
                    return baseNode;
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator setEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            switch (operatorDeclNode.getOperator()) {
                case IN: {
                    MemberDeclNode memberDeclNode;
                    if (exprNodeArray[1] instanceof ArithmeticOperatorNode) {
                        ArithmeticOperatorNode arithmeticOperatorNode = (ArithmeticOperatorNode)exprNodeArray[1];
                        if (arithmeticOperatorNode.getOperator() == OperatorDeclNode.Operator.BIT_AND) {
                            ExprNode exprNode = (ExprNode)arithmeticOperatorNode.children.get(0);
                            ExprNode exprNode2 = (ExprNode)arithmeticOperatorNode.children.get(1);
                            ExprNode exprNode3 = new ArithmeticOperatorNode(exprNode.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode).evaluate();
                            ExprNode exprNode4 = new ArithmeticOperatorNode(exprNode2.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode2).evaluate();
                            return new ArithmeticOperatorNode(arithmeticOperatorNode.getCoords(), OperatorDeclNode.Operator.LOG_AND, exprNode3, exprNode4).evaluate();
                        }
                        if (arithmeticOperatorNode.getOperator() != OperatorDeclNode.Operator.BIT_OR) break;
                        ExprNode exprNode = (ExprNode)arithmeticOperatorNode.children.get(0);
                        ExprNode exprNode5 = (ExprNode)arithmeticOperatorNode.children.get(1);
                        ExprNode exprNode6 = new ArithmeticOperatorNode(exprNode.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode).evaluate();
                        ExprNode exprNode7 = new ArithmeticOperatorNode(exprNode5.getCoords(), OperatorDeclNode.Operator.IN, exprNodeArray[0], exprNode5).evaluate();
                        return new ArithmeticOperatorNode(arithmeticOperatorNode.getCoords(), OperatorDeclNode.Operator.LOG_OR, exprNode6, exprNode7).evaluate();
                    }
                    if (!(exprNodeArray[0] instanceof ConstNode)) break;
                    ConstNode constNode = (ConstNode)exprNodeArray[0];
                    SetInitNode setInitNode = null;
                    if (exprNodeArray[1] instanceof SetInitNode) {
                        setInitNode = (SetInitNode)exprNodeArray[1];
                    } else if (exprNodeArray[1] instanceof MemberAccessExprNode && (memberDeclNode = ((MemberAccessExprNode)exprNodeArray[1]).getDecl()).isConst() && memberDeclNode.getConstInitializer() != null) {
                        setInitNode = (SetInitNode)memberDeclNode.getConstInitializer();
                    }
                    if (setInitNode == null) break;
                    if (setInitNode.contains(constNode)) {
                        return new BoolConstNode(coords, true);
                    }
                    if (!setInitNode.isConstant()) break;
                    return new BoolConstNode(coords, false);
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator arrayEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            switch (operatorDeclNode.getOperator()) {
                case INDEX: {
                    BaseNode baseNode;
                    if (!(exprNodeArray[1] instanceof ConstNode)) break;
                    ConstNode constNode = (ConstNode)exprNodeArray[1];
                    ArrayInitNode arrayInitNode = null;
                    if (exprNodeArray[0] instanceof ArrayInitNode) {
                        arrayInitNode = (ArrayInitNode)exprNodeArray[0];
                    } else if (exprNodeArray[0] instanceof MemberAccessExprNode && ((MemberDeclNode)(baseNode = ((MemberAccessExprNode)exprNodeArray[0]).getDecl())).isConst() && ((MemberDeclNode)baseNode).getConstInitializer() != null) {
                        arrayInitNode = (ArrayInitNode)((MemberDeclNode)baseNode).getConstInitializer();
                    }
                    if (arrayInitNode == null || !((baseNode = arrayInitNode.getAtIndex(constNode)) instanceof ConstNode)) break;
                    return baseNode;
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator dequeEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            switch (operatorDeclNode.getOperator()) {
                case INDEX: {
                    BaseNode baseNode;
                    if (!(exprNodeArray[1] instanceof ConstNode)) break;
                    ConstNode constNode = (ConstNode)exprNodeArray[1];
                    DequeInitNode dequeInitNode = null;
                    if (exprNodeArray[0] instanceof DequeInitNode) {
                        dequeInitNode = (DequeInitNode)exprNodeArray[0];
                    } else if (exprNodeArray[0] instanceof MemberAccessExprNode && ((MemberDeclNode)(baseNode = ((MemberAccessExprNode)exprNodeArray[0]).getDecl())).isConst() && ((MemberDeclNode)baseNode).getConstInitializer() != null) {
                        dequeInitNode = (DequeInitNode)((MemberDeclNode)baseNode).getConstInitializer();
                    }
                    if (dequeInitNode == null || !((baseNode = dequeInitNode.getAtIndex(constNode)) instanceof ConstNode)) break;
                    return baseNode;
                }
            }
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator untypedEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            throw new NotEvaluatableException(coords);
        }
    };
    public static final OperatorEvaluator emptyEvaluator = new OperatorEvaluator(){

        @Override
        protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
            throw new NotEvaluatableException(coords);
        }
    };

    public ExprNode evaluate(ExprNode exprNode, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) {
        Base.debug.report(4, "id: " + (Object)((Object)operatorDeclNode.getOperator()) + ", name: " + OperatorDeclNode.getName(operatorDeclNode.getOperator()));
        ExprNode exprNode2 = exprNode;
        TypeNode[] typeNodeArray = operatorDeclNode.getOperandTypes();
        if (exprNodeArray.length == typeNodeArray.length) {
            for (int i = 0; i < exprNodeArray.length; ++i) {
                Base.debug.report(4, "parameter type: " + typeNodeArray[i] + " argument type: " + exprNodeArray[i].getType());
                if (typeNodeArray[i].isEqual(exprNodeArray[i].getType())) continue;
                return exprNode2;
            }
            try {
                exprNode2 = this.eval(exprNode.getCoords(), operatorDeclNode, exprNodeArray);
            }
            catch (NotEvaluatableException notEvaluatableException) {
                Base.debug.report(4, notEvaluatableException.toString());
            }
        }
        if (Base.debug.willReport(4)) {
            ConstNode constNode = exprNode2 instanceof ConstNode ? (ConstNode)exprNode2 : ConstNode.getInvalid();
            Base.debug.report(4, "result: " + exprNode2.getClass() + ", value: " + constNode.getValue());
        }
        return exprNode2;
    }

    protected ExprNode eval(Coords coords, OperatorDeclNode operatorDeclNode, ExprNode[] exprNodeArray) throws NotEvaluatableException {
        return null;
    }

    private Object checkValue(ExprNode exprNode, Class<?> clazz) throws ValueException {
        if (!(exprNode instanceof ConstNode)) {
            throw new ValueException(exprNode.getCoords());
        }
        Object object = ((ConstNode)exprNode).getValue();
        if (!clazz.isInstance(object)) {
            throw new ValueException(exprNode.getCoords());
        }
        return object;
    }

    protected Object getArgValue(ExprNode[] exprNodeArray, OperatorDeclNode operatorDeclNode, int n) throws ValueException {
        TypeNode[] typeNodeArray = operatorDeclNode.getOperandTypes();
        if (typeNodeArray[n].isBasic()) {
            BasicTypeNode basicTypeNode = (BasicTypeNode)typeNodeArray[n];
            return this.checkValue(exprNodeArray[n], basicTypeNode.getValueType());
        }
        throw new ValueException(exprNodeArray[n].getCoords());
    }

    class ValueException
    extends Exception {
        private static final long serialVersionUID = 991159946682342406L;
        private Coords coords;

        public ValueException(Coords coords) {
            this.coords = coords;
        }

        @Override
        public String getMessage() {
            return "Expression not constant or value has wrong type at " + this.coords.toString();
        }
    }

    class NotEvaluatableException
    extends Exception {
        private static final long serialVersionUID = -4866769730405704919L;
        private Coords coords;

        public NotEvaluatableException(Coords coords) {
            this.coords = coords;
        }

        @Override
        public String getMessage() {
            return "Expression not evaluatable at " + this.coords.toString();
        }
    }
}

