/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.ProcedureSignature;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import java.util.Vector;

public abstract class ProcedureDeclBaseNode
extends DeclNode
implements ProcedureSignature {
    protected CollectNode<BaseNode> resultsUnresolved;
    public CollectNode<TypeNode> resultTypesCollectNode;
    public Vector<TypeNode> resultTypes;
    protected Vector<TypeNode> parameterTypes;
    private static final CollectResolver<TypeNode> resultTypeResolver = new CollectResolver<TypeNode>(new DeclarationTypeResolver<TypeNode>(TypeNode.class));

    public ProcedureDeclBaseNode(IdentNode identNode, BaseNode baseNode) {
        super(identNode, baseNode);
    }

    @Override
    protected boolean resolveLocal() {
        this.resultTypesCollectNode = resultTypeResolver.resolve(this.resultsUnresolved, this);
        if (this.resultTypesCollectNode != null) {
            this.resultTypes = this.resultTypesCollectNode.getChildrenAsVector();
        }
        return this.resultTypes != null;
    }

    @Override
    public Vector<TypeNode> getParameterTypes() {
        assert (this.isResolved());
        return this.parameterTypes;
    }

    @Override
    public Vector<TypeNode> getResultTypes() {
        assert (this.isResolved());
        return this.resultTypes;
    }

    @Override
    public int getDistance(Vector<TypeNode> vector) {
        if (vector.size() == this.parameterTypes.size()) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            debug.report(4, "" + i + ": arg type: " + vector.get(i) + ", op type: " + this.parameterTypes.get(i));
            boolean bl = vector.get(i).isEqual(this.parameterTypes.get(i));
            boolean bl2 = vector.get(i).isCompatibleTo(this.parameterTypes.get(i));
            debug.report(4, "equal: " + bl + ", compatible: " + bl2);
            int n2 = vector.get(i).compatibilityDistance(this.parameterTypes.get(i));
            if (n2 == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            n += n2;
        }
        return n;
    }
}

