/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.EmitNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoSuppliedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.DeclExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.MemberAccessExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphRhsNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.RuleTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class RuleDeclNode
extends ActionDeclNode {
    public RhsDeclNode right;
    private RuleTypeNode type;
    private static final TypeNode ruleType;
    protected static final DeclarationTypeResolver<RuleTypeNode> typeResolver;

    public RuleDeclNode(IdentNode identNode, PatternGraphLhsNode patternGraphLhsNode, CollectNode<IdentNode> collectNode, RhsDeclNode rhsDeclNode, CollectNode<BaseNode> collectNode2) {
        super(identNode, ruleType, patternGraphLhsNode, collectNode, collectNode2);
        this.right = rhsDeclNode;
        this.becomeParent(this.right);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.getValidVersion(this.returnFormalParametersUnresolved, this.returnFormalParameters));
        vector.add(this.pattern);
        vector.add(this.getValidVersion(this.implementedMatchTypesUnresolved, this.implementedMatchTypes));
        vector.add(this.right);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("ret");
        vector.add("pattern");
        vector.add("implementedMatchTypes");
        vector.add("right");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.type = (RuleTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        boolean bl2 = true;
        for (FilterAutoDeclNode filterAutoDeclNode : this.filters) {
            if (filterAutoDeclNode instanceof FilterAutoSuppliedDeclNode) {
                bl2 &= ((FilterAutoSuppliedDeclNode)filterAutoDeclNode).resolve();
                continue;
            }
            bl2 &= ((FilterAutoGeneratedDeclNode)filterAutoDeclNode).resolve();
        }
        return bl & this.type != null & bl2;
    }

    public Set<ConstraintDeclNode> getDeletedElements() {
        return this.right.getElementsToDelete(this.pattern);
    }

    private boolean checkReturnedElementsNotDeleted() {
        assert (this.isResolved());
        boolean bl = true;
        Set<ConstraintDeclNode> set = this.right.getElementsToDelete(this.pattern);
        Set<ConstraintDeclNode> set2 = this.right.getMaybeDeletedElements(this.pattern);
        for (ExprNode exprNode : this.right.patternGraph.returns.getChildren()) {
            HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
            exprNode.getPotentiallyResultingElements(hashSet);
            for (ConstraintDeclNode constraintDeclNode : hashSet) {
                bl &= RuleDeclNode.checkReturnedElementNotDeleted(constraintDeclNode, set, set2);
            }
        }
        return bl;
    }

    private static boolean checkReturnedElementNotDeleted(ConstraintDeclNode constraintDeclNode, Set<ConstraintDeclNode> set, Set<ConstraintDeclNode> set2) {
        if (set.contains(constraintDeclNode)) {
            constraintDeclNode.reportError("The deleted " + constraintDeclNode.getKind() + " " + constraintDeclNode + " is not allowed to be returned.");
            return false;
        }
        if (set2.contains(constraintDeclNode)) {
            constraintDeclNode.maybeDeleted = true;
            if (!constraintDeclNode.getIdentNode().getAnnotations().isFlagSet("maybeDeleted")) {
                String string = "Returning " + constraintDeclNode.getKind() + " " + constraintDeclNode + " that may be deleted.";
                string = string + " Possibly it is homomorphic with a deleted " + constraintDeclNode.getKind();
                string = string + " (use a [maybeDeleted] annotation if you think that this does not cause problems)";
                if (constraintDeclNode instanceof EdgeDeclNode) {
                    string = string + ", or " + constraintDeclNode + " is a dangling edge and a deleted node exists";
                }
                string = string + ".";
                constraintDeclNode.reportError(string);
                return false;
            }
        }
        return true;
    }

    private boolean checkReturnedElementsNotRetyped() {
        assert (this.isResolved());
        boolean bl = true;
        for (ExprNode exprNode : this.right.patternGraph.returns.getChildren()) {
            ConstraintDeclNode constraintDeclNode;
            if (!(exprNode instanceof DeclExprNode) || (constraintDeclNode = ((DeclExprNode)exprNode).getConstraintDeclNode()) == null || constraintDeclNode.getRetypedElement() == null) continue;
            bl = false;
            exprNode.reportError("The retyped " + constraintDeclNode.getKind() + " " + constraintDeclNode + " is not allowed to be returned.");
        }
        return bl;
    }

    private boolean checkElementsNotRetypedToDifferentTypes() {
        assert (this.isResolved());
        boolean bl = true;
        for (Set<ConstraintDeclNode> set : this.pattern.getHoms()) {
            bl &= RuleDeclNode.checkElementsInHomSetNotRetypedToDifferentTypes(set);
        }
        return bl;
    }

    private static boolean checkElementsInHomSetNotRetypedToDifferentTypes(Set<ConstraintDeclNode> set) {
        boolean bl;
        BaseNode baseNode = null;
        ConstraintDeclNode constraintDeclNode = null;
        ConstraintDeclNode constraintDeclNode2 = null;
        ConstraintDeclNode constraintDeclNode3 = null;
        for (ConstraintDeclNode constraintDeclNode4 : set) {
            ConstraintDeclNode constraintDeclNode5 = constraintDeclNode4.getRetypedElement();
            if (constraintDeclNode5 == null) continue;
            InheritanceTypeNode inheritanceTypeNode = constraintDeclNode5.getDeclType();
            if (constraintDeclNode == null) {
                baseNode = constraintDeclNode4;
                constraintDeclNode = constraintDeclNode5;
                continue;
            }
            if (inheritanceTypeNode == constraintDeclNode.getDeclType()) continue;
            constraintDeclNode2 = constraintDeclNode4;
            constraintDeclNode3 = constraintDeclNode5;
            break;
        }
        boolean bl2 = bl = constraintDeclNode2 != null;
        if (bl) {
            constraintDeclNode.reportError("The " + baseNode.getKind() + " " + baseNode + " is retyped to " + constraintDeclNode.getDeclType().getTypeName() + ", but the " + constraintDeclNode2.getKind() + " " + constraintDeclNode2 + " it may be homomorphic to is retyped to " + constraintDeclNode3.getDeclType().getTypeName() + ".");
        }
        return !bl;
    }

    private boolean checkRetypedElementsNotDeleted() {
        assert (this.isResolved());
        boolean bl = true;
        for (DeclNode declNode : this.getDeletedElements()) {
            ConstraintDeclNode constraintDeclNode;
            if (!(declNode instanceof ConstraintDeclNode) || (constraintDeclNode = (ConstraintDeclNode)declNode).getRetypedElement() == null) continue;
            bl = false;
            constraintDeclNode.reportError("The retyped " + constraintDeclNode.getKind() + " " + constraintDeclNode + " is not allowed to be deleted.");
        }
        return bl;
    }

    private HashSet<ConstraintDeclNode> collectNeededElements(ExprNode exprNode) {
        HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
        if (exprNode instanceof MemberAccessExprNode) {
            return hashSet;
        }
        for (BaseNode baseNode : exprNode.getChildren()) {
            if (baseNode instanceof ExprNode) {
                hashSet.addAll(this.collectNeededElements((ExprNode)baseNode));
            }
            if (baseNode instanceof DeclExprNode) {
                hashSet.add(((DeclExprNode)baseNode).getConstraintDeclNode());
                continue;
            }
            if (!(baseNode instanceof ConstraintDeclNode)) continue;
            hashSet.add((ConstraintDeclNode)baseNode);
        }
        return hashSet;
    }

    private boolean checkEmitElementsNotDeleted() {
        assert (this.isResolved());
        boolean bl = true;
        Set<ConstraintDeclNode> set = this.right.getElementsToDelete(this.pattern);
        Set<ConstraintDeclNode> set2 = this.right.getMaybeDeletedElements(this.pattern);
        for (BaseNode baseNode : this.right.patternGraph.imperativeStmts.getChildren()) {
            if (!(baseNode instanceof EmitNode)) continue;
            EmitNode emitNode = (EmitNode)baseNode;
            for (BaseNode baseNode2 : emitNode.getChildren()) {
                ExprNode exprNode = (ExprNode)baseNode2;
                for (ConstraintDeclNode constraintDeclNode : this.collectNeededElements(exprNode)) {
                    bl &= RuleDeclNode.checkEmitElementNotDeleted(constraintDeclNode, exprNode, set, set2, emitNode);
                }
            }
        }
        return bl;
    }

    private static boolean checkEmitElementNotDeleted(ConstraintDeclNode constraintDeclNode, ExprNode exprNode, Set<ConstraintDeclNode> set, Set<ConstraintDeclNode> set2, EmitNode emitNode) {
        String string;
        String string2 = emitNode.isDebug ? "emitdebug" : "emit";
        String string3 = string = emitNode.isDebug ? "emitheredebug" : "emithere";
        if (set.contains(constraintDeclNode)) {
            exprNode.reportError("The deleted " + constraintDeclNode.getKind() + " " + constraintDeclNode + " is not allowed to be referenced in an " + string2 + " statement (you may use an " + string + " instead).");
            return false;
        }
        if (set2.contains(constraintDeclNode)) {
            constraintDeclNode.maybeDeleted = true;
            if (!constraintDeclNode.getIdentNode().getAnnotations().isFlagSet("maybeDeleted")) {
                String string4 = "The " + constraintDeclNode.getKind() + " " + constraintDeclNode + " used in an " + string2 + " statement may be deleted.";
                string4 = string4 + " Possibly it is homomorphic with a deleted " + constraintDeclNode.getKind();
                string4 = string4 + " (use a [maybeDeleted] annotation if you think that this does not cause problems)";
                if (constraintDeclNode instanceof EdgeDeclNode) {
                    string4 = string4 + ", or " + constraintDeclNode + " is a dangling edge and a deleted node exists";
                }
                string4 = string4 + " (you may use an " + string + " instead).";
                exprNode.reportError(string4);
                return false;
            }
        }
        return true;
    }

    private void calcMaybeRetyped() {
        for (Set<ConstraintDeclNode> set : this.pattern.getHoms()) {
            boolean bl = false;
            for (ConstraintDeclNode constraintDeclNode : set) {
                if (constraintDeclNode.getRetypedElement() == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            for (ConstraintDeclNode constraintDeclNode : set) {
                if (constraintDeclNode.getRetypedElement() != null) continue;
                constraintDeclNode.maybeRetyped = true;
            }
        }
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        boolean bl2 = this.right.checkAgainstLhsPattern(this.pattern);
        PatternGraphRhsNode patternGraphRhsNode = this.right.patternGraph;
        String string = this.ident.toString();
        if (!patternGraphRhsNode.nameOfGraph.equals(string)) {
            this.right.reportError("Named rewrite parts are not allowed in rules (only in (sub)patterns).");
        }
        if (patternGraphRhsNode.params.getChildren().size() > 0) {
            this.right.reportError("Parameters for the rewrite part are not allowed in rules (only in (sub)patterns).");
        }
        boolean bl3 = true;
        if (this.pattern.returns.size() > 0) {
            this.reportError("A return statement is not allowed in the pattern part of a rule.");
            bl3 = false;
        }
        this.calcMaybeRetyped();
        return bl & bl2 & this.checkRhsReuse(this.right) & this.sameNumberOfRewriteParts(this.right, "rule") & bl3 & this.noAbstractElementInstantiated(this.right) & this.checkRetypedElementsNotDeleted() & this.checkReturnedElementsNotDeleted() & this.checkElementsNotRetypedToDifferentTypes() & this.checkReturnedElementsNotRetyped() & this.checkExecParamsNotDeleted(this.right) & this.checkEmitElementsNotDeleted() & this.checkReturns(patternGraphRhsNode.returns) & this.noAmbiguousRetypes(this.right);
    }

    public NodeDeclNode tryGetNode(IdentNode identNode) {
        for (NodeDeclNode nodeDeclNode : this.pattern.getNodes()) {
            if (!nodeDeclNode.ident.toString().equals(identNode.toString())) continue;
            return nodeDeclNode;
        }
        for (NodeDeclNode nodeDeclNode : this.right.patternGraph.getNodes()) {
            if (!nodeDeclNode.ident.toString().equals(identNode.toString())) continue;
            return nodeDeclNode;
        }
        return null;
    }

    public EdgeDeclNode tryGetEdge(IdentNode identNode) {
        for (EdgeDeclNode edgeDeclNode : this.pattern.getEdges()) {
            if (!edgeDeclNode.ident.toString().equals(identNode.toString())) continue;
            return edgeDeclNode;
        }
        for (EdgeDeclNode edgeDeclNode : this.right.patternGraph.getEdges()) {
            if (!edgeDeclNode.ident.toString().equals(identNode.toString())) continue;
            return edgeDeclNode;
        }
        return null;
    }

    public VarDeclNode tryGetVar(IdentNode identNode) {
        VarDeclNode varDeclNode;
        for (VarDeclNode declNode2 : this.pattern.defVariablesToBeYieldedTo.getChildren()) {
            if (!declNode2.ident.toString().equals(identNode.toString())) continue;
            return declNode2;
        }
        for (DeclNode declNode : this.pattern.getParamDecls()) {
            if (!(declNode instanceof VarDeclNode)) continue;
            varDeclNode = (VarDeclNode)declNode;
            if (!varDeclNode.ident.toString().equals(identNode.toString())) continue;
            return varDeclNode;
        }
        for (VarDeclNode varDeclNode2 : this.right.patternGraph.defVariablesToBeYieldedTo.getChildren()) {
            if (!varDeclNode2.ident.toString().equals(identNode.toString())) continue;
            return varDeclNode2;
        }
        for (DeclNode declNode : this.right.patternGraph.getParamDecls()) {
            if (!(declNode instanceof VarDeclNode)) continue;
            varDeclNode = (VarDeclNode)declNode;
            if (!varDeclNode.ident.toString().equals(identNode.toString())) continue;
            return varDeclNode;
        }
        return null;
    }

    public static String getKindStr() {
        return "rule";
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Rule rule = new Rule(this.getIdentNode().getIdent(), Rule.RuleKind.Rule);
        this.setIR(rule);
        PatternGraphLhs patternGraphLhs = this.pattern.getPatternGraph();
        for (DeclNode object : this.pattern.getParamDecls()) {
            if (!(object instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)object;
            patternGraphLhs.addVariable(varDeclNode.checkIR(Variable.class));
        }
        PatternGraphRhs patternGraphRhs = this.right.getPatternGraph(patternGraphLhs);
        rule.initialize(patternGraphLhs, patternGraphRhs);
        for (DefinedMatchTypeNode definedMatchTypeNode : this.implementedMatchTypes.getChildren()) {
            DefinedMatchType definedMatchType = definedMatchTypeNode.checkIR(DefinedMatchType.class);
            rule.addImplementedMatchClass(definedMatchType);
        }
        this.constructImplicitNegs(patternGraphLhs);
        this.constructIRaux((MatchingAction)rule, this.right.patternGraph.returns);
        for (EvalStatements evalStatements : this.right.getRhsGraph().getEvalStatements()) {
            rule.addEval(evalStatements);
        }
        return rule;
    }

    @Override
    public RuleTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    static {
        RuleDeclNode.setName(RuleDeclNode.class, "rule declaration");
        ruleType = new RuleTypeNode();
        typeResolver = new DeclarationTypeResolver<RuleTypeNode>(RuleTypeNode.class);
    }
}

