/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.ExecNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.ExecVarDeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.SequenceTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.ExecVariable;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Sequence;
import java.util.Collection;
import java.util.Vector;

public class SequenceDeclNode
extends DeclNode {
    protected SequenceTypeNode type;
    protected ExecNode exec;
    public CollectNode<ExecVarDeclNode> inParams;
    public CollectNode<ExecVarDeclNode> outParams;
    private static final TypeNode sequenceType;
    protected static final DeclarationTypeResolver<SequenceTypeNode> typeResolver;

    public SequenceDeclNode(IdentNode identNode, ExecNode execNode, CollectNode<ExecVarDeclNode> collectNode, CollectNode<ExecVarDeclNode> collectNode2) {
        super(identNode, sequenceType);
        this.exec = execNode;
        this.becomeParent(this.exec);
        this.inParams = collectNode;
        this.becomeParent(this.inParams);
        this.outParams = collectNode2;
        this.becomeParent(this.outParams);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.exec);
        vector.add(this.inParams);
        vector.add(this.outParams);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("exec");
        vector.add("inParams");
        vector.add("outParams");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = (SequenceTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    public Sequence getSequence() {
        return this.checkIR(Sequence.class);
    }

    @Override
    protected IR constructIR() {
        Sequence sequence = new Sequence(this.getIdentNode().getIdent(), this.exec.checkIR(Exec.class));
        for (ExecVarDeclNode execVarDeclNode : this.inParams.getChildren()) {
            sequence.addInParam(execVarDeclNode.checkIR(ExecVariable.class));
        }
        for (ExecVarDeclNode execVarDeclNode : this.outParams.getChildren()) {
            sequence.addOutParam(execVarDeclNode.checkIR(ExecVariable.class));
        }
        return sequence;
    }

    @Override
    public SequenceTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    public static String getKindStr() {
        return "sequence";
    }

    static {
        SequenceDeclNode.setName(SequenceDeclNode.class, "sequence declaration");
        sequenceType = new SequenceTypeNode();
        typeResolver = new DeclarationTypeResolver<SequenceTypeNode>(SequenceTypeNode.class);
    }
}

