/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.NestedMatcherDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.AlternativeCaseTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import java.util.Collection;
import java.util.Vector;

public class AlternativeCaseDeclNode
extends NestedMatcherDeclNode {
    private AlternativeCaseTypeNode type;
    private static final TypeNode alternativeCaseType;
    private static final DeclarationTypeResolver<AlternativeCaseTypeNode> typeResolver;

    public AlternativeCaseDeclNode(IdentNode identNode, PatternGraphLhsNode patternGraphLhsNode, RhsDeclNode rhsDeclNode) {
        super(identNode, alternativeCaseType, patternGraphLhsNode, rhsDeclNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.pattern);
        if (this.right != null) {
            vector.add(this.right);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("pattern");
        if (this.right != null) {
            vector.add("right");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = (AlternativeCaseTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Rule rule = new Rule(this.getIdentNode().getIdent(), Rule.RuleKind.AlternativeCase);
        this.setIR(rule);
        PatternGraphLhs patternGraphLhs = this.pattern.getPatternGraph();
        PatternGraphRhs patternGraphRhs = null;
        if (this.right != null) {
            patternGraphRhs = this.right.getPatternGraph(patternGraphLhs);
        }
        rule.initialize(patternGraphLhs, patternGraphRhs);
        this.constructImplicitNegs(patternGraphLhs);
        this.constructIRaux(rule, this.right);
        if (this.right != null) {
            for (EvalStatements evalStatements : this.right.getRhsGraph().getEvalStatements()) {
                rule.addEval(evalStatements);
            }
        }
        return rule;
    }

    @Override
    public AlternativeCaseTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    public static String getKindStr() {
        return "alternative case";
    }

    static {
        AlternativeCaseDeclNode.setName(AlternativeCaseDeclNode.class, "alternative case");
        alternativeCaseType = new AlternativeCaseTypeNode();
        typeResolver = new DeclarationTypeResolver<AlternativeCaseTypeNode>(AlternativeCaseTypeNode.class);
    }
}

