/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.NameOrAttributeInitializationNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.type.TypeExpr;
import java.util.HashSet;

public abstract class ConstraintDeclNode
extends DeclNode {
    protected TypeExprNode constraints;
    public int context;
    public PatternGraphLhsNode directlyNestingLHSGraph;
    public boolean defEntityToBeYieldedTo;
    protected CopyKind copyKind;
    protected ConstraintDeclNode retypedElem = null;
    public boolean maybeDeleted = false;
    public boolean maybeRetyped = false;
    protected boolean maybeNull = false;
    ExprNode initialization = null;
    CollectNode<NameOrAttributeInitializationNode> nameOrAttributeInits = new CollectNode();

    protected ConstraintDeclNode(IdentNode identNode, BaseNode baseNode, CopyKind copyKind, int n, TypeExprNode typeExprNode, PatternGraphLhsNode patternGraphLhsNode, boolean bl, boolean bl2) {
        super(identNode, baseNode);
        this.copyKind = copyKind;
        this.constraints = typeExprNode;
        this.becomeParent(this.constraints);
        this.context = n;
        this.directlyNestingLHSGraph = patternGraphLhsNode;
        this.maybeNull = bl;
        this.defEntityToBeYieldedTo = bl2;
    }

    public void setInitialization(ExprNode exprNode) {
        this.initialization = exprNode;
    }

    public void addNameOrAttributeInitialization(NameOrAttributeInitializationNode nameOrAttributeInitializationNode) {
        this.nameOrAttributeInits.addChild(nameOrAttributeInitializationNode);
    }

    @Override
    protected boolean checkLocal() {
        return this.initializationIsWellTyped() & this.noRhsConstraint() & this.noLhsCopy() & this.noLhsNameOrAttributeInit() & this.atMostOneNameInit();
    }

    private boolean initializationIsWellTyped() {
        if (this.initialization == null) {
            return true;
        }
        InheritanceTypeNode inheritanceTypeNode = this.getDeclType();
        TypeNode typeNode = this.initialization.getType();
        if (typeNode.isEqual(inheritanceTypeNode)) {
            return true;
        }
        if (inheritanceTypeNode instanceof NodeTypeNode && typeNode instanceof NodeTypeNode || inheritanceTypeNode instanceof EdgeTypeNode && typeNode instanceof EdgeTypeNode) {
            HashSet<TypeNode> hashSet = new HashSet<TypeNode>();
            typeNode.doGetCompatibleToTypes(hashSet);
            if (hashSet.contains(inheritanceTypeNode)) {
                return true;
            }
        }
        this.reportError("Cannot initialize " + this.getKind() + " " + this.getIdentNode() + " of type " + inheritanceTypeNode.toStringWithDeclarationCoords() + " with a value of type " + typeNode.toStringWithDeclarationCoords() + ".");
        return false;
    }

    private boolean noRhsConstraint() {
        if ((this.context & 1) == 0) {
            return true;
        }
        if (this.constraints != TypeExprNode.getEmpty()) {
            this.constraints.reportError("A rewrite part element is not allowed to be type constrained (only pattern elements are) (but the rewrite part " + this.getKind() + " " + this.getIdentNode() + " is endowed with a type constraint).");
            return false;
        }
        return true;
    }

    private boolean noLhsCopy() {
        if ((this.context & 1) == 1) {
            return true;
        }
        if (this.copyKind != CopyKind.None) {
            this.reportError("A copy<> construct is not allowed in the pattern part" + this.emptyWhenAnonymous(" (but comes with the declaration of " + this.getKind() + " " + this.getIdentNode() + ")") + ".");
            return false;
        }
        return true;
    }

    private boolean noLhsNameOrAttributeInit() {
        if ((this.context & 1) == 1) {
            return true;
        }
        if (this.nameOrAttributeInits.size() > 0) {
            NameOrAttributeInitializationNode nameOrAttributeInitializationNode = this.nameOrAttributeInits.get(0);
            if (nameOrAttributeInitializationNode.attributeUnresolved != null) {
                this.reportError("An attribute initialization is not allowed in the pattern part (but occurs for " + nameOrAttributeInitializationNode.attributeUnresolved + " of " + this.getKind() + " " + this.getIdentNode() + ").");
            } else {
                this.reportError("A name initialization ($=) is not allowed in the pattern part (but occurs for " + this.getKind() + " " + this.getIdentNode() + ").");
            }
            return false;
        }
        return true;
    }

    private boolean atMostOneNameInit() {
        boolean bl = true;
        boolean bl2 = false;
        for (NameOrAttributeInitializationNode nameOrAttributeInitializationNode : this.nameOrAttributeInits.getChildren()) {
            if (nameOrAttributeInitializationNode.attributeUnresolved != null) continue;
            if (!bl2) {
                bl2 = true;
                continue;
            }
            this.reportError("Only one name initialization ($=) is allowed (but multiple ones are given for " + this.getKind() + " " + this.getIdentNode() + ").");
            bl = false;
        }
        return bl;
    }

    protected final TypeExpr getConstraints() {
        return this.constraints.checkIR(TypeExpr.class);
    }

    protected boolean isMaybeDeleted() {
        return this.maybeDeleted;
    }

    protected boolean isMaybeRetyped() {
        return this.maybeRetyped;
    }

    public ConstraintDeclNode getRetypedElement() {
        return this.retypedElem;
    }

    @Override
    public abstract InheritanceTypeNode getDeclType();

    public static String getKindStr() {
        return "node or edge";
    }

    public static enum CopyKind {
        None,
        Clone,
        Copy;

    }
}

