/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.MatchByIndexAccessOrderingPartNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.pattern.Edge;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class MatchEdgeByIndexAccessMultipleDeclNode
extends EdgeDeclNode {
    protected CollectNode<MatchByIndexAccessOrderingPartNode> indexAccessParts = new CollectNode();

    public MatchEdgeByIndexAccessMultipleDeclNode(IdentNode identNode, BaseNode baseNode, int n, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode);
    }

    public void addIndexAccessPart(MatchByIndexAccessOrderingPartNode matchByIndexAccessOrderingPartNode) {
        this.indexAccessParts.addChild(matchByIndexAccessOrderingPartNode);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.indexAccessParts);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("indexAccessParts");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        if ((this.context & 1) == 1) {
            this.reportError("Cannot employ match edge by index multiple in the rewrite part (as it occurs in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by multiple index access).");
            bl = false;
        }
        EdgeTypeNode edgeTypeNode = this.getDeclType();
        for (MatchByIndexAccessOrderingPartNode object : this.indexAccessParts.getChildren()) {
            InheritanceTypeNode inheritanceTypeNode = object.index.getType();
            if (inheritanceTypeNode.isCompatibleTo(edgeTypeNode) || edgeTypeNode.isCompatibleTo(inheritanceTypeNode)) continue;
            bl = false;
        }
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.indexAccessParts.getChildren().size(); ++i) {
            MatchByIndexAccessOrderingPartNode matchByIndexAccessOrderingPartNode = this.indexAccessParts.get(i);
            InheritanceTypeNode inheritanceTypeNode = matchByIndexAccessOrderingPartNode.index.getType();
            for (int j = i + 1; j < this.indexAccessParts.getChildren().size(); ++j) {
                MatchByIndexAccessOrderingPartNode matchByIndexAccessOrderingPartNode2 = this.indexAccessParts.get(j);
                InheritanceTypeNode inheritanceTypeNode2 = matchByIndexAccessOrderingPartNode2.index.getType();
                if (InheritanceTypeNode.hasCommonSubtype(inheritanceTypeNode, inheritanceTypeNode2)) continue;
                this.reportWarning("The indexed type " + inheritanceTypeNode.toStringWithDeclarationCoords() + " and the indexed type " + inheritanceTypeNode2.toStringWithDeclarationCoords() + " have no common subtype, thus the content of these indices is disjoint, and the index join will always be empty.");
            }
        }
        HashSet<IndexDeclNode> hashSet = new HashSet<IndexDeclNode>();
        for (MatchByIndexAccessOrderingPartNode matchByIndexAccessOrderingPartNode : this.indexAccessParts.getChildren()) {
            if (hashSet.contains(matchByIndexAccessOrderingPartNode.index)) {
                this.reportWarning("The match edge by index multiple uses the index " + matchByIndexAccessOrderingPartNode.index.toStringWithDeclarationCoords() + " for another time (combine the queried ranges into one).");
                continue;
            }
            hashSet.add(matchByIndexAccessOrderingPartNode.index);
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Edge edge = (Edge)super.constructIR();
        this.setIR(edge);
        for (MatchByIndexAccessOrderingPartNode matchByIndexAccessOrderingPartNode : this.indexAccessParts.getChildren()) {
            edge.addIndex(matchByIndexAccessOrderingPartNode.constructIRPart());
        }
        return edge;
    }

    static {
        MatchEdgeByIndexAccessMultipleDeclNode.setName(MatchEdgeByIndexAccessMultipleDeclNode.class, "match edge by index access multiple decl");
    }
}

