/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.MatchEdgeFromByStorageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.StorageAccess;
import de.unika.ipd.grgen.ir.pattern.Variable;
import java.util.Collection;
import java.util.Vector;

public class MatchEdgeFromStorageDeclNode
extends MatchEdgeFromByStorageDeclNode {
    public MatchEdgeFromStorageDeclNode(IdentNode identNode, BaseNode baseNode, int n, BaseNode baseNode2, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, n, baseNode2, patternGraphLhsNode);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.storageUnresolved, this.storage, this.storageAttribute, this.storageGlobalVariable));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("storage");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        if (this.storageUnresolved instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)this.storageUnresolved;
            if (identExprNode.resolve()) {
                if (identExprNode.decl instanceof VarDeclNode) {
                    this.storage = (VarDeclNode)identExprNode.decl;
                } else if (identExprNode.decl instanceof EdgeDeclNode) {
                    this.storageGlobalVariable = (EdgeDeclNode)identExprNode.decl;
                } else {
                    this.reportError("Match edge from storage expects an edge storage parameter or an edge global variable (but" + this.emptyWhenAnonymousPostfix(" ") + " is given neither).");
                    bl = false;
                }
            } else {
                this.reportError("Match edge from storage expects an edge storage parameter or an edge global variable (but" + this.emptyWhenAnonymousPostfix(" ") + " is given neither).");
                bl = false;
            }
        } else if (this.storageUnresolved instanceof QualIdentNode) {
            QualIdentNode qualIdentNode = (QualIdentNode)this.storageUnresolved;
            if (qualIdentNode.resolve()) {
                this.storageAttribute = qualIdentNode;
            } else {
                this.reportError("Match edge from storage attribute expects a storage attribute (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + qualIdentNode + ").");
                bl = false;
            }
        } else {
            this.reportError("Internal error - invalid match edge from storage attribute (for " + this.getIdentNode() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        if ((this.context & 1) == 1) {
            this.reportError("Cannot employ match edge from storage in the rewrite part (as it occurs in match edge" + this.emptyWhenAnonymousPostfix(" ") + " from " + this.getStorageName() + ").");
            return false;
        }
        TypeNode typeNode = this.getStorageType();
        if (!(typeNode instanceof ContainerTypeNode) && this.storageGlobalVariable == null) {
            this.reportError("Match edge from storage expects a collection type (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + typeNode.getTypeName() + " by " + this.getStorageName() + ").");
            return false;
        }
        TypeNode typeNode2 = null;
        typeNode2 = typeNode instanceof ContainerTypeNode ? ((ContainerTypeNode)typeNode).getElementType() : this.storageGlobalVariable.getDeclType();
        if (!(typeNode2 instanceof EdgeTypeNode)) {
            if (this.storageGlobalVariable == null) {
                this.reportError("Match edge from storage expects the element type to be an edge type (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + typeNode2.getKind() + " " + typeNode2.toStringWithDeclarationCoords() + " accessing " + this.getStorageName() + ").");
                return false;
            }
            this.reportError("Match edge from storage global variable expects an edge type (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + typeNode2.getKind() + " " + typeNode2.toStringWithDeclarationCoords() + " accessing " + this.getStorageName() + ").");
            return false;
        }
        EdgeTypeNode edgeTypeNode = (EdgeTypeNode)typeNode2;
        EdgeTypeNode edgeTypeNode2 = this.getDeclType();
        if (!edgeTypeNode2.isCompatibleTo(edgeTypeNode)) {
            String string = edgeTypeNode2.toStringWithDeclarationCoords();
            String string2 = edgeTypeNode.toStringWithDeclarationCoords();
            this.ident.reportError("Cannot convert storage element type from " + string2 + " to the expected " + string + " in match edge from storage (" + this.emptyWhenAnonymous("of " + this.getIdentNode() + " ") + "accessing " + this.getStorageName() + ").");
            return false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        Edge edge = (Edge)super.constructIR();
        if (this.storage != null) {
            edge.setStorage(new StorageAccess(this.storage.checkIR(Variable.class)));
        } else if (this.storageAttribute != null) {
            edge.setStorage(new StorageAccess(this.storageAttribute.checkIR(Qualification.class)));
        }
        return edge;
    }

    static {
        MatchEdgeFromStorageDeclNode.setName(MatchEdgeFromStorageDeclNode.class, "match edge from storage decl");
    }
}

