/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.NameLookup;
import de.unika.ipd.grgen.ir.pattern.Node;
import java.util.Collection;
import java.util.Vector;

public class MatchNodeByNameLookupDeclNode
extends NodeDeclNode {
    private ExprNode expr;

    public MatchNodeByNameLookupDeclNode(IdentNode identNode, BaseNode baseNode, int n, ExprNode exprNode, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode);
        this.expr = exprNode;
        this.becomeParent(this.expr);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.expr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("expression");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        return bl &= this.expr.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        if ((this.context & 1) == 1) {
            this.reportError("Cannot employ match node by name index lookup in the rewrite part" + this.emptyWhenAnonymous(" (as it occurs in match node " + this.getIdentNode() + ")") + ".");
            return false;
        }
        BasicTypeNode basicTypeNode = StringTypeNode.stringType;
        TypeNode typeNode = this.expr.getType();
        if (!typeNode.isCompatibleTo(basicTypeNode)) {
            String string = ((TypeNode)basicTypeNode).getTypeName();
            String string2 = typeNode.getTypeName();
            this.ident.reportError("Cannot convert type used in accessing name index from " + string2 + " to the expected " + string + " in match node" + this.emptyWhenAnonymousPostfix(" ") + " by name index lookup.");
            return false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Node node = (Node)super.constructIR();
        this.setIR(node);
        this.expr = this.expr.evaluate();
        node.setNameMapAccess(new NameLookup(this.expr.checkIR(Expression.class)));
        return node;
    }

    static {
        MatchNodeByNameLookupDeclNode.setName(MatchNodeByNameLookupDeclNode.class, "match node by name lookup decl");
    }
}

