/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphRhsNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.util.CollectTripleResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTripleResolver;
import de.unika.ipd.grgen.ast.util.Triple;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacement;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacements;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.SubpatternDependentReplacement;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class ModifyDeclNode
extends RhsDeclNode {
    private CollectNode<IdentNode> deletesUnresolved;
    private CollectNode<DeclNode> deletes = new CollectNode();
    private static final CollectTripleResolver<NodeDeclNode, EdgeDeclNode, SubpatternUsageDeclNode> deleteResolver;

    public ModifyDeclNode(IdentNode identNode, PatternGraphRhsNode patternGraphRhsNode, CollectNode<IdentNode> collectNode) {
        super(identNode, patternGraphRhsNode);
        this.deletesUnresolved = collectNode;
        this.becomeParent(this.deletesUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.patternGraph);
        vector.add(this.getValidVersion(this.deletesUnresolved, this.deletes));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("right");
        vector.add("delete");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        Triple<CollectNode<NodeDeclNode>, CollectNode<EdgeDeclNode>, CollectNode<SubpatternUsageDeclNode>> triple = deleteResolver.resolve(this.deletesUnresolved);
        if (triple != null) {
            if (triple.first != null) {
                for (DeclNode declNode : ((CollectNode)triple.first).getChildren()) {
                    this.deletes.addChild(declNode);
                }
            }
            if (triple.second != null) {
                for (DeclNode declNode : ((CollectNode)triple.second).getChildren()) {
                    this.deletes.addChild(declNode);
                }
            }
            if (triple.third != null) {
                for (DeclNode declNode : ((CollectNode)triple.third).getChildren()) {
                    this.deletes.addChild(declNode);
                }
            }
            this.becomeParent(this.deletes);
        }
        return super.resolveLocal() && triple != null;
    }

    @Override
    public boolean checkAgainstLhsPattern(PatternGraphLhsNode patternGraphLhsNode) {
        this.warnIfElementAppearsInsideAndOutsideOfDelete(patternGraphLhsNode);
        return true;
    }

    @Override
    public PatternGraphRhs getPatternGraph(PatternGraphLhs patternGraphLhs) {
        PatternGraphRhs patternGraphRhs = this.patternGraph.getGraph();
        Set<Entity> set = this.insertElementsToDeleteToLhsIfNotFromLhs(patternGraphLhs, patternGraphRhs);
        ModifyDeclNode.insertLhsElementsToRhs(patternGraphLhs, set, patternGraphRhs);
        ModifyDeclNode.insertElementsFromTypeofToRhsIfNotYetContained(patternGraphRhs, set);
        for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
            if (ModifyDeclNode.isSubpatternRewritePartUsed(subpatternUsage, patternGraphRhs) || this.isSubpatternUsageToBeDeleted(subpatternUsage)) continue;
            patternGraphRhs.addSubpatternUsage(subpatternUsage);
        }
        this.insertElementsFromEvalsIntoRhs(patternGraphLhs, patternGraphRhs);
        this.insertElementsFromOrderedReplacementsIntoRhs(patternGraphLhs, patternGraphRhs);
        return patternGraphRhs;
    }

    private Set<Entity> insertElementsToDeleteToLhsIfNotFromLhs(PatternGraphLhs patternGraphLhs, PatternGraphBase patternGraphBase) {
        HashSet<Entity> hashSet = new HashSet<Entity>();
        for (DeclNode declNode : this.deletes.getChildren()) {
            GraphEntity graphEntity;
            if (declNode instanceof SubpatternUsageDeclNode) continue;
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)declNode;
            Entity entity = constraintDeclNode.checkIR(Entity.class);
            hashSet.add(entity);
            if (constraintDeclNode.defEntityToBeYieldedTo) {
                entity.setPatternGraphDefYieldedIsToBeDeleted(patternGraphBase);
            }
            if (entity instanceof Node) {
                graphEntity = constraintDeclNode.checkIR(Node.class);
                if (patternGraphLhs.hasNode((Node)graphEntity) || graphEntity.directlyNestingLHSGraph == patternGraphLhs) continue;
                patternGraphLhs.addSingleNode((Node)graphEntity);
                patternGraphLhs.addHomToAll((Node)graphEntity);
                continue;
            }
            graphEntity = constraintDeclNode.checkIR(Edge.class);
            if (patternGraphLhs.hasEdge((Edge)graphEntity) || ((Edge)graphEntity).directlyNestingLHSGraph == patternGraphLhs) continue;
            patternGraphLhs.addSingleEdge((Edge)graphEntity);
            patternGraphLhs.addHomToAll((Edge)graphEntity);
        }
        return hashSet;
    }

    private static void insertLhsElementsToRhs(PatternGraphLhs patternGraphLhs, Set<Entity> set, PatternGraphRhs patternGraphRhs) {
        for (Node graphEntity : patternGraphLhs.getNodes()) {
            if (!set.contains(graphEntity)) {
                patternGraphRhs.addSingleNode(graphEntity);
                continue;
            }
            patternGraphRhs.addDeletedElement(graphEntity);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            if (!(set.contains(edge) || set.contains(patternGraphLhs.getSource(edge)) || set.contains(patternGraphLhs.getTarget(edge)))) {
                patternGraphRhs.addConnection(patternGraphLhs.getSource(edge), edge, patternGraphLhs.getTarget(edge), edge.hasFixedDirection(), false, false);
                continue;
            }
            patternGraphRhs.addDeletedElement(edge);
        }
    }

    private static void insertElementsFromTypeofToRhsIfNotYetContained(PatternGraphRhs patternGraphRhs, Set<Entity> set) {
        GraphEntity graphEntity;
        for (Node graphEntity2 : patternGraphRhs.getNodes()) {
            if (!graphEntity2.inheritsType() || set.contains(graphEntity = (Node)graphEntity2.getTypeof())) continue;
            patternGraphRhs.addNodeIfNotYetContained((Node)graphEntity);
        }
        for (Edge edge : patternGraphRhs.getEdges()) {
            if (!edge.inheritsType() || set.contains(graphEntity = (Edge)edge.getTypeof())) continue;
            patternGraphRhs.addEdgeIfNotYetContained((Edge)graphEntity);
        }
    }

    private static boolean isSubpatternRewritePartUsed(SubpatternUsage subpatternUsage, PatternGraphRhs patternGraphRhs) {
        for (OrderedReplacements orderedReplacements : patternGraphRhs.getOrderedReplacements()) {
            for (OrderedReplacement orderedReplacement : orderedReplacements.orderedReplacements) {
                SubpatternDependentReplacement subpatternDependentReplacement;
                if (!(orderedReplacement instanceof SubpatternDependentReplacement) || subpatternUsage != (subpatternDependentReplacement = (SubpatternDependentReplacement)orderedReplacement).getSubpatternUsage()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSubpatternUsageToBeDeleted(SubpatternUsage subpatternUsage) {
        for (DeclNode declNode : this.deletes.getChildren()) {
            SubpatternUsage subpatternUsage2;
            if (!(declNode instanceof SubpatternUsageDeclNode) || subpatternUsage != (subpatternUsage2 = declNode.checkIR(SubpatternUsage.class))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ConstraintDeclNode> getElementsToDeleteImpl(PatternGraphLhsNode patternGraphLhsNode) {
        ConnectionNode connectionNode;
        assert (this.isResolved());
        LinkedHashSet<ConstraintDeclNode> linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
        for (DeclNode baseNode : this.deletes.getChildren()) {
            if (baseNode instanceof SubpatternUsageDeclNode) continue;
            linkedHashSet.add((ConstraintDeclNode)baseNode);
        }
        for (ConnectionCharacter connectionCharacter : patternGraphLhsNode.getConnections()) {
            if (!(connectionCharacter instanceof ConnectionNode) || !linkedHashSet.contains((connectionNode = (ConnectionNode)connectionCharacter).getSrc()) && !linkedHashSet.contains(connectionNode.getTgt())) continue;
            linkedHashSet.add(connectionNode.getEdge());
        }
        for (ConnectionCharacter connectionCharacter : this.patternGraph.getConnections()) {
            if (!(connectionCharacter instanceof ConnectionNode) || !linkedHashSet.contains((connectionNode = (ConnectionNode)connectionCharacter).getSrc()) && !linkedHashSet.contains(connectionNode.getTgt())) continue;
            linkedHashSet.add(connectionNode.getEdge());
        }
        return linkedHashSet;
    }

    @Override
    public Set<ConnectionNode> getConnectionsToReuseImpl(PatternGraphLhsNode patternGraphLhsNode) {
        EdgeDeclNode edgeDeclNode;
        ConnectionNode connectionNode;
        LinkedHashSet<ConnectionNode> linkedHashSet = new LinkedHashSet<ConnectionNode>();
        Set<EdgeDeclNode> set = patternGraphLhsNode.getEdges();
        for (ConnectionCharacter connectionCharacter : this.patternGraph.getConnections()) {
            if (!(connectionCharacter instanceof ConnectionNode)) continue;
            connectionNode = (ConnectionNode)connectionCharacter;
            edgeDeclNode = connectionNode.getEdge();
            while (edgeDeclNode instanceof EdgeTypeChangeDeclNode) {
                edgeDeclNode = ((EdgeTypeChangeDeclNode)edgeDeclNode).getOldEdge();
            }
            if (!set.contains(edgeDeclNode) || ModifyDeclNode.sourceOrTargetNodeIncluded(edgeDeclNode, patternGraphLhsNode, this.deletes.getChildren())) continue;
            linkedHashSet.add(connectionNode);
        }
        for (ConnectionCharacter connectionCharacter : patternGraphLhsNode.getConnections()) {
            if (!(connectionCharacter instanceof ConnectionNode)) continue;
            connectionNode = (ConnectionNode)connectionCharacter;
            edgeDeclNode = connectionNode.getEdge();
            while (edgeDeclNode instanceof EdgeTypeChangeDeclNode) {
                edgeDeclNode = ((EdgeTypeChangeDeclNode)edgeDeclNode).getOldEdge();
            }
            if (this.deletes.getChildren().contains(edgeDeclNode) || ModifyDeclNode.sourceOrTargetNodeIncluded(edgeDeclNode, patternGraphLhsNode, this.deletes.getChildren())) continue;
            linkedHashSet.add(connectionNode);
        }
        return linkedHashSet;
    }

    @Override
    public Set<NodeDeclNode> getNodesToReuseImpl(PatternGraphLhsNode patternGraphLhsNode) {
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        Set<NodeDeclNode> set = patternGraphLhsNode.getNodes();
        Set<NodeDeclNode> set2 = this.patternGraph.getNodes();
        for (NodeDeclNode nodeDeclNode : set) {
            if (!set2.contains(nodeDeclNode) && this.deletes.getChildren().contains(nodeDeclNode)) continue;
            linkedHashSet.add(nodeDeclNode);
        }
        return linkedHashSet;
    }

    private void warnIfElementAppearsInsideAndOutsideOfDelete(PatternGraphLhsNode patternGraphLhsNode) {
        Set<ConstraintDeclNode> set = this.getElementsToDelete(patternGraphLhsNode);
        HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
        for (ConnectionCharacter connectionCharacter : this.patternGraph.getConnections()) {
            Object object;
            ConstraintDeclNode constraintDeclNode = null;
            if (connectionCharacter instanceof SingleNodeConnNode) {
                object = (SingleNodeConnNode)connectionCharacter;
                constraintDeclNode = ((SingleNodeConnNode)object).getNode();
            } else {
                object = (ConnectionNode)connectionCharacter;
                constraintDeclNode = ((ConnectionNode)object).getEdge();
            }
            if (hashSet.contains(constraintDeclNode)) continue;
            for (ConstraintDeclNode constraintDeclNode2 : set) {
                if (!constraintDeclNode.equals(constraintDeclNode2) || constraintDeclNode.defEntityToBeYieldedTo) continue;
                connectionCharacter.reportWarning("\"" + constraintDeclNode2 + "\" appears inside as well as outside a delete statement");
                hashSet.add(constraintDeclNode);
            }
        }
    }

    @Override
    protected Set<ConnectionNode> getConnectionsNotDeleted(PatternGraphLhsNode patternGraphLhsNode) {
        LinkedHashSet<ConnectionNode> linkedHashSet = new LinkedHashSet<ConnectionNode>();
        Set<ConstraintDeclNode> set = this.getElementsToDelete(patternGraphLhsNode);
        for (ConnectionCharacter connectionCharacter : patternGraphLhsNode.getConnections()) {
            ConnectionNode connectionNode;
            if (!(connectionCharacter instanceof ConnectionNode) || set.contains((connectionNode = (ConnectionNode)connectionCharacter).getEdge()) || set.contains(connectionNode.getSrc()) || set.contains(connectionNode.getTgt())) continue;
            linkedHashSet.add(connectionNode);
        }
        return linkedHashSet;
    }

    static {
        ModifyDeclNode.setName(ModifyDeclNode.class, "modify declaration");
        deleteResolver = new CollectTripleResolver(new DeclarationTripleResolver<NodeDeclNode, EdgeDeclNode, SubpatternUsageDeclNode>(NodeDeclNode.class, EdgeDeclNode.class, SubpatternUsageDeclNode.class));
    }
}

