/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.DummyNodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.NameOrAttributeInitializationNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.pattern.NameOrAttributeInitialization;
import de.unika.ipd.grgen.ir.pattern.Node;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class NodeDeclNode
extends ConstraintDeclNode {
    protected NodeDeclNode typeNodeDecl = null;
    protected TypeDeclNode typeTypeDecl = null;
    private static DeclarationPairResolver<NodeDeclNode, TypeDeclNode> typeResolver;
    private static final Checker typeChecker;

    public NodeDeclNode(IdentNode identNode, BaseNode baseNode, ConstraintDeclNode.CopyKind copyKind, int n, TypeExprNode typeExprNode, PatternGraphLhsNode patternGraphLhsNode, boolean bl, boolean bl2) {
        super(identNode, baseNode, copyKind, n, typeExprNode, patternGraphLhsNode, bl, bl2);
    }

    public NodeDeclNode(IdentNode identNode, BaseNode baseNode, ConstraintDeclNode.CopyKind copyKind, int n, TypeExprNode typeExprNode, PatternGraphLhsNode patternGraphLhsNode) {
        this(identNode, baseNode, copyKind, n, typeExprNode, patternGraphLhsNode, false, false);
    }

    public NodeDeclNode cloneForAuto(PatternGraphLhsNode patternGraphLhsNode) {
        NodeDeclNode nodeDeclNode = new NodeDeclNode(this.ident, this.typeUnresolved, this.copyKind, this.context, this.constraints, patternGraphLhsNode, this.maybeNull, this.defEntityToBeYieldedTo);
        nodeDeclNode.resolve();
        if (this.typeNodeDecl != null) {
            this.reportError("A typeof node cannot be used in an auto statement (as is the case for " + this.getIdentNode() + ").");
        }
        return nodeDeclNode;
    }

    @Override
    public NodeTypeNode getDeclType() {
        assert (this.isResolved());
        DeclNode declNode = this.getValidResolvedVersion(this.typeNodeDecl, this.typeTypeDecl);
        TypeNode typeNode = declNode.getDeclType();
        return (NodeTypeNode)typeNode;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.nameOrAttributeInits);
        if (this.initialization != null) {
            vector.add(this.initialization);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("nameOrAttributeInits");
        if (this.initialization != null) {
            vector.add("initialization expression");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        TypeDeclNode typeDeclNode;
        Object object = typeResolver.resolve(this.typeUnresolved, this);
        if (object == null) {
            return false;
        }
        this.typeNodeDecl = (NodeDeclNode)((Pair)object).fst;
        this.typeTypeDecl = (TypeDeclNode)((Pair)object).snd;
        if (this.typeNodeDecl != null) {
            HashSet<NodeDeclNode> hashSet = new HashSet<NodeDeclNode>();
            NodeDeclNode nodeDeclNode = this.typeNodeDecl;
            NodeDeclNode nodeDeclNode2 = this.typeNodeDecl.typeNodeDecl;
            while (nodeDeclNode2 != null) {
                if (hashSet.contains(nodeDeclNode2)) {
                    this.reportError("Circular typeof/copy not allowed (as is the case for " + this.getKind() + " " + this.getIdentNode() + ").");
                    return false;
                }
                hashSet.add(nodeDeclNode2);
                nodeDeclNode = nodeDeclNode2;
                nodeDeclNode2 = nodeDeclNode2.typeNodeDecl;
            }
            if (nodeDeclNode.typeTypeDecl == null && !nodeDeclNode.resolve()) {
                return false;
            }
            typeDeclNode = nodeDeclNode.typeTypeDecl;
        } else {
            typeDeclNode = this.typeTypeDecl;
        }
        if (!typeDeclNode.resolve()) {
            return false;
        }
        if (!(typeDeclNode.getDeclType() instanceof NodeTypeNode)) {
            this.typeUnresolved.reportError("Type of node" + this.emptyWhenAnonymousPostfix(" ") + " must be a node type (given is " + typeDeclNode.getDeclType().getKind() + " " + typeDeclNode.getDeclType().getTypeName() + " - use -edge-> syntax for edges, var for variables, ref for containers).");
            return false;
        }
        return true;
    }

    private void warnOnTypeofOfRhsNodes() {
        if ((this.context & 1) == 0) {
            return;
        }
        boolean bl = true;
        while (this.inheritsType() && (this.typeNodeDecl.context & 1) == 1) {
            if (bl) {
                bl = false;
                this.reportWarning("Type of node " + this.typeNodeDecl.ident + " is statically known (to be " + this.typeNodeDecl.getDeclType().getTypeName() + ", the typeof is thus pointless).");
            }
            this.typeTypeDecl = this.typeNodeDecl.typeTypeDecl;
            this.typeNodeDecl = this.typeNodeDecl.typeNodeDecl;
        }
    }

    @Override
    protected boolean checkLocal() {
        this.warnOnTypeofOfRhsNodes();
        return super.checkLocal() & typeChecker.check(this.getValidResolvedVersion(this.typeNodeDecl, this.typeTypeDecl), error);
    }

    public static NodeDeclNode getDummy(IdentNode identNode, BaseNode baseNode, int n, PatternGraphLhsNode patternGraphLhsNode) {
        return new DummyNodeDeclNode(identNode, baseNode, n, patternGraphLhsNode);
    }

    public boolean isDummy() {
        return false;
    }

    @Override
    public Color getNodeColor() {
        return Color.GREEN;
    }

    public Node getNode() {
        return this.checkIR(Node.class);
    }

    public final boolean inheritsType() {
        assert (this.isResolved());
        return this.typeNodeDecl != null;
    }

    @Override
    protected IR constructIR() {
        NodeTypeNode nodeTypeNode = this.getDeclType();
        NodeType nodeType = nodeTypeNode.getNodeType();
        IdentNode identNode = this.getIdentNode();
        Node node = new Node(identNode.getIdent(), nodeType, identNode.getAnnotations(), this.directlyNestingLHSGraph != null ? this.directlyNestingLHSGraph.getPatternGraph() : null, this.isMaybeDeleted(), this.isMaybeRetyped(), this.defEntityToBeYieldedTo, this.context);
        node.setConstraints(this.getConstraints());
        if (node.getConstraints().contains(node.getType())) {
            this.reportError("The own node type may not be contained in the type constraint list (but " + node.getType() + " is contained for " + this.getIdentNode() + ").");
        }
        if (this.inheritsType()) {
            node.setTypeofCopy(this.typeNodeDecl.checkIR(Node.class), this.copyKind);
        }
        node.setMaybeNull(this.maybeNull);
        if (this.initialization != null) {
            this.initialization = this.initialization.evaluate();
            node.setInitialization(this.initialization.checkIR(Expression.class));
        }
        for (NameOrAttributeInitializationNode nameOrAttributeInitializationNode : this.nameOrAttributeInits.getChildren()) {
            nameOrAttributeInitializationNode.ownerIR = node;
            node.addNameOrAttributeInitialization(nameOrAttributeInitializationNode.checkIR(NameOrAttributeInitialization.class));
        }
        return node;
    }

    public static String getKindStr() {
        return "node";
    }

    static {
        NodeDeclNode.setName(NodeDeclNode.class, "node");
        typeResolver = new DeclarationPairResolver<NodeDeclNode, TypeDeclNode>(NodeDeclNode.class, TypeDeclNode.class);
        typeChecker = new TypeChecker(NodeTypeNode.class);
    }
}

