/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.NameOrAttributeInitializationNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.RetypedNode;
import java.util.Collection;
import java.util.Vector;

public class NodeTypeChangeDeclNode
extends NodeDeclNode {
    private BaseNode oldUnresolved;
    private NodeDeclNode old = null;
    private CollectNode<IdentNode> mergeesUnresolved;
    private CollectNode<NodeDeclNode> mergees;
    private static final DeclarationResolver<NodeDeclNode> nodeResolver;
    private static final CollectResolver<NodeDeclNode> mergeesResolver;

    public NodeTypeChangeDeclNode(IdentNode identNode, BaseNode baseNode, int n, BaseNode baseNode2, CollectNode<IdentNode> collectNode, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode);
        this.oldUnresolved = baseNode2;
        this.becomeParent(this.oldUnresolved);
        this.mergeesUnresolved = collectNode;
        this.becomeParent(this.mergeesUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.oldUnresolved, this.old));
        vector.add(this.getValidVersion(this.mergeesUnresolved, this.mergees));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("old");
        vector.add("mergees");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.old = (NodeDeclNode)nodeResolver.resolve(this.oldUnresolved, this);
        if (this.old != null) {
            this.old.retypedElem = this;
        }
        this.mergees = mergeesResolver.resolve(this.mergeesUnresolved, this);
        return bl && this.old != null && this.mergees != null;
    }

    public final NodeDeclNode getOldNode() {
        assert (this.isResolved());
        return this.old;
    }

    public final Collection<NodeDeclNode> getMergees() {
        assert (this.isResolved());
        return this.mergees.getChildren();
    }

    @Override
    protected boolean checkLocal() {
        TypeChecker typeChecker = new TypeChecker(NodeTypeNode.class);
        boolean bl = super.checkLocal() & typeChecker.check(this.old, error);
        if (!bl) {
            return false;
        }
        if (this.nameOrAttributeInits.size() > 0) {
            NameOrAttributeInitializationNode nameOrAttributeInitializationNode = (NameOrAttributeInitializationNode)this.nameOrAttributeInits.get(0);
            if (nameOrAttributeInitializationNode.attributeUnresolved != null) {
                this.reportError("An attribute initialization is not allowed for a retyped node (but occurs for " + nameOrAttributeInitializationNode.attributeUnresolved + this.emptyWhenAnonymousPostfix(" of ") + ").");
            } else {
                this.reportError("A name initialization ($=) is not allowed for a retyped node" + this.emptyWhenAnonymous(" (but occurs for " + this.getIdentNode() + ")."));
            }
            return false;
        }
        if ((this.old.context & 1) == 1 && !this.old.defEntityToBeYieldedTo) {
            this.reportError("The original node of the retyping may not be declared in the rewrite part (this is violated by the original node " + this.old.getIdentNode() + this.emptyWhenAnonymousPostfix(" of ") + ").");
            bl = false;
        }
        for (NodeDeclNode nodeDeclNode : this.mergees.getChildren()) {
            if ((nodeDeclNode.context & 1) != 1 || nodeDeclNode.defEntityToBeYieldedTo) continue;
            this.reportError("An original node of a (retyping) merge may not be declared in the rewrite part (this is violated by the original node " + nodeDeclNode.getIdentNode() + this.emptyWhenAnonymousPostfix(" of ") + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    public Node getNode() {
        return this.checkIR(Node.class);
    }

    @Override
    protected IR constructIR() {
        NodeTypeNode nodeTypeNode = this.getDeclType();
        NodeType nodeType = nodeTypeNode.getNodeType();
        IdentNode identNode = this.getIdentNode();
        RetypedNode retypedNode = new RetypedNode(identNode.getIdent(), nodeType, identNode.getAnnotations(), this.isMaybeDeleted(), this.isMaybeRetyped(), false, this.context);
        Node node = this.old.getNode();
        retypedNode.setOldNode(node);
        if (this.inheritsType()) {
            assert (this.copyKind == ConstraintDeclNode.CopyKind.None);
            retypedNode.setTypeofCopy(this.typeNodeDecl.checkIR(Node.class), this.copyKind);
        }
        for (NodeDeclNode nodeDeclNode : this.mergees.getChildren()) {
            retypedNode.addMergee(nodeDeclNode.checkIR(Node.class));
        }
        return retypedNode;
    }

    static {
        NodeTypeChangeDeclNode.setName(NodeTypeChangeDeclNode.class, "node type change decl");
        nodeResolver = new DeclarationResolver<NodeDeclNode>(NodeDeclNode.class);
        mergeesResolver = new CollectResolver<NodeDeclNode>(new DeclarationResolver<NodeDeclNode>(NodeDeclNode.class));
    }
}

