/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.DeclaredCharacter;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SubpatternDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;

public class SubpatternUsageDeclNode
extends DeclNode {
    private CollectNode<ExprNode> connections;
    public SubpatternDeclNode type = null;
    public int context;
    private static final DeclarationResolver<SubpatternDeclNode> actionResolver;

    public SubpatternUsageDeclNode(IdentNode identNode, BaseNode baseNode, int n, CollectNode<ExprNode> collectNode) {
        super(identNode, baseNode);
        this.context = n;
        this.connections = collectNode;
        this.becomeParent(this.connections);
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return this.type.getDeclType();
    }

    public SubpatternDeclNode getSubpatternDeclNode() {
        assert (this.isResolved());
        return this.type;
    }

    public int getContext() {
        return this.context;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.connections);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("connections");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!(this.typeUnresolved instanceof PackageIdentNode)) {
            SubpatternUsageDeclNode.fixupDefinition((IdentNode)this.typeUnresolved, this.typeUnresolved.getScope());
        }
        this.type = (SubpatternDeclNode)actionResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkSubpatternSignatureAdhered();
    }

    private boolean checkSubpatternSignatureAdhered() {
        int n;
        int n2 = this.type.pattern.getParamDecls().size();
        if (n2 != (n = this.connections.getChildren().size())) {
            String string = this.type.ident.toString();
            this.ident.reportError("The (sub)pattern " + string + this.type.getDeclarationCoords() + " expects " + n2 + " arguments, given by the subpattern usage" + this.emptyWhenAnonymousPostfix(" ") + " are " + n + " arguments.");
            return false;
        }
        boolean bl = true;
        Vector<DeclNode> vector = this.type.pattern.getParamDecls();
        for (int i = 0; i < this.connections.size(); ++i) {
            ExprNode exprNode = this.connections.get(i);
            DeclNode declNode = vector.get(i);
            bl = exprNode instanceof IdentExprNode && ((IdentExprNode)exprNode).yieldedTo ? (bl &= this.checkYieldedToParameter(i, exprNode, declNode)) : (bl &= this.checkParameter(i, exprNode, declNode));
            bl &= this.checkDefArgument(i, exprNode, declNode);
        }
        return bl;
    }

    private boolean checkYieldedToParameter(int n, ExprNode exprNode, DeclNode declNode) {
        Object object;
        DeclaredCharacter declaredCharacter;
        boolean bl = true;
        TypeNode typeNode = exprNode.getType();
        TypeNode typeNode2 = declNode.getDeclType();
        if (declNode instanceof ConstraintDeclNode) {
            declaredCharacter = (ConstraintDeclNode)declNode;
            if (!declaredCharacter.defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("The " + (n + 1) + ". subpattern usage argument is yielded to, but the parameter at this position is not declared as def" + this.whenUsingSpecification((DeclNode)declaredCharacter) + ".");
            }
        } else {
            declaredCharacter = (VarDeclNode)declNode;
            if (!((VarDeclNode)declaredCharacter).defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("The " + (n + 1) + ". subpattern usage argument is yielded to, but the parameter at this position is not declared as def" + this.whenUsingSpecification((DeclNode)declaredCharacter) + ".");
            }
        }
        declaredCharacter = ((IdentExprNode)exprNode).decl;
        if (declaredCharacter instanceof VarDeclNode) {
            object = (VarDeclNode)declaredCharacter;
            if (!((VarDeclNode)object).defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("Cannot yield to non-def arguments - the " + (n + 1) + ". subpattern usage argument is yielded to but not declared as def" + this.whenUsingSpecification((DeclNode)object) + ".");
            }
        } else {
            object = declaredCharacter;
            if (!((ConstraintDeclNode)object).defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("Cannot yield to non-def arguments - the " + (n + 1) + ". subpattern usage argument is yielded to but not declared as def" + this.whenUsingSpecification((DeclNode)object) + ".");
            }
        }
        if (!typeNode2.isCompatibleTo(typeNode)) {
            bl = false;
            object = typeNode.getTypeName();
            String string = typeNode2.getTypeName();
            this.ident.reportError("The " + (n + 1) + ". subpattern usage argument of type " + (String)object + " cannot be yielded to from the subpattern def parameter of incompatible type " + string + this.whenUsingSpecification(null) + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
        }
        return bl;
    }

    private boolean checkParameter(int n, ExprNode exprNode, DeclNode declNode) {
        Object object;
        boolean bl = true;
        TypeNode typeNode = exprNode.getType();
        TypeNode typeNode2 = declNode.getDeclType();
        if (declNode instanceof ConstraintDeclNode) {
            object = (ConstraintDeclNode)declNode;
            if (((ConstraintDeclNode)object).defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("The " + (n + 1) + ". subpattern usage argument is not yielded to, but the parameter at this position is declared as def" + this.whenUsingSpecification((DeclNode)object) + ".");
            }
        } else {
            object = (VarDeclNode)declNode;
            if (((VarDeclNode)object).defEntityToBeYieldedTo) {
                bl = false;
                this.ident.reportError("The " + (n + 1) + ". subpattern usage argument is not yielded to, but the parameter at this position is declared as def" + this.whenUsingSpecification((DeclNode)object) + ".");
            }
        }
        if (!typeNode.isCompatibleTo(typeNode2)) {
            bl = false;
            object = typeNode.getTypeName();
            String string = typeNode2.getTypeName();
            this.ident.reportError("Cannot convert " + (n + 1) + ". subpattern usage argument from " + (String)object + " to the expected " + string + this.whenUsingSpecification(null) + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
        }
        return bl;
    }

    private boolean checkDefArgument(int n, ExprNode exprNode, DeclNode declNode) {
        if (!(exprNode instanceof IdentExprNode)) {
            return true;
        }
        DeclaredCharacter declaredCharacter = ((IdentExprNode)exprNode).decl;
        if (declaredCharacter instanceof VarDeclNode) {
            VarDeclNode varDeclNode = (VarDeclNode)declaredCharacter;
            if (varDeclNode.defEntityToBeYieldedTo && declNode instanceof VarDeclNode) {
                VarDeclNode varDeclNode2 = (VarDeclNode)declNode;
                if (!varDeclNode2.defEntityToBeYieldedTo) {
                    this.ident.reportError("Cannot use def elements as non-def arguments to subpatterns - the " + (n + 1) + ". subpattern usage argument is declared as def, but the parameter at this position is not declared as def" + this.whenUsingSpecification(varDeclNode2) + ".");
                    return false;
                }
            }
        } else {
            ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)declaredCharacter;
            if (constraintDeclNode.defEntityToBeYieldedTo && declNode instanceof ConstraintDeclNode) {
                ConstraintDeclNode constraintDeclNode2 = (ConstraintDeclNode)declNode;
                if (!constraintDeclNode2.defEntityToBeYieldedTo) {
                    this.ident.reportError("Cannot use def elements as non-def arguments to subpatterns - the " + (n + 1) + ". subpattern usage argument is declared as def, but the parameter at this position is not declared as def" + this.whenUsingSpecification(constraintDeclNode2) + ".");
                    return false;
                }
            }
        }
        return true;
    }

    private String whenUsingSpecification(DeclNode declNode) {
        return " (" + (declNode != null ? declNode.getIdentNode() + " " : "") + "when using " + this.type.toStringWithDeclarationCoords() + this.emptyWhenAnonymous(" by " + this.ident) + ")";
    }

    @Override
    protected IR constructIR() {
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        LinkedList<Expression> linkedList2 = new LinkedList<Expression>();
        for (ExprNode exprNode : this.connections.getChildren()) {
            if ((exprNode = exprNode.evaluate()) instanceof IdentExprNode && ((IdentExprNode)exprNode).yieldedTo) {
                linkedList2.add(exprNode.checkIR(Expression.class));
                continue;
            }
            linkedList.add(exprNode.checkIR(Expression.class));
        }
        return new SubpatternUsage("subpattern", this.getIdentNode().getIdent(), this.type.checkIR(Rule.class), linkedList, linkedList2);
    }

    static {
        SubpatternUsageDeclNode.setName(SubpatternUsageDeclNode.class, "subpattern node");
        actionResolver = new DeclarationResolver<SubpatternDeclNode>(SubpatternDeclNode.class);
    }
}

