/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.InvalidDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.Variable;
import java.util.Collection;
import java.util.Vector;

public class VarDeclNode
extends DeclNode {
    private TypeNode type;
    public PatternGraphLhsNode directlyNestingLHSGraph;
    public boolean defEntityToBeYieldedTo;
    public ExprNode initialization = null;
    public int context;
    private String modifier;
    public boolean lambdaExpressionVariable = false;
    private static final DeclarationResolver<DeclNode> declOfTypeResolver = new DeclarationResolver<DeclNode>(DeclNode.class);

    public VarDeclNode(IdentNode identNode, IdentNode identNode2, PatternGraphLhsNode patternGraphLhsNode, int n, boolean bl, boolean bl2, String string) {
        super(identNode, identNode2);
        this.directlyNestingLHSGraph = patternGraphLhsNode;
        this.defEntityToBeYieldedTo = bl;
        this.context = n;
        this.lambdaExpressionVariable = bl2;
        this.modifier = string;
    }

    public VarDeclNode(IdentNode identNode, IdentNode identNode2, PatternGraphLhsNode patternGraphLhsNode, int n, String string) {
        this(identNode, identNode2, patternGraphLhsNode, n, false, false, string);
    }

    public VarDeclNode(IdentNode identNode, TypeNode typeNode, PatternGraphLhsNode patternGraphLhsNode, int n, boolean bl, boolean bl2, String string) {
        super(identNode, typeNode);
        this.type = typeNode;
        this.directlyNestingLHSGraph = patternGraphLhsNode;
        this.defEntityToBeYieldedTo = bl;
        this.context = n;
        this.lambdaExpressionVariable = bl2;
        this.modifier = string;
    }

    public VarDeclNode(IdentNode identNode, TypeNode typeNode, PatternGraphLhsNode patternGraphLhsNode, int n, String string) {
        this(identNode, typeNode, patternGraphLhsNode, n, false, false, string);
    }

    public VarDeclNode cloneForAuto(PatternGraphLhsNode patternGraphLhsNode) {
        VarDeclNode varDeclNode = new VarDeclNode(this.ident, this.type, patternGraphLhsNode, this.context, this.defEntityToBeYieldedTo, this.lambdaExpressionVariable, this.modifier);
        varDeclNode.resolve();
        varDeclNode.check();
        return varDeclNode;
    }

    public static final VarDeclNode getInvalidVar(PatternGraphLhsNode patternGraphLhsNode, int n) {
        return new VarDeclNode(IdentNode.getInvalid(), IdentNode.getInvalid(), patternGraphLhsNode, n, "");
    }

    public void setInitialization(ExprNode exprNode) {
        this.initialization = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        if (this.initialization != null) {
            vector.add(this.initialization);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        if (this.initialization != null) {
            vector.add("initialization expression");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        DeclNode declNode;
        if (this.type != null) {
            return true;
        }
        if (!(this.typeUnresolved instanceof PackageIdentNode)) {
            VarDeclNode.fixupDefinition(this.typeUnresolved, this.typeUnresolved.getScope());
        }
        if ((declNode = (DeclNode)declOfTypeResolver.resolve(this.typeUnresolved, this)) instanceof InvalidDeclNode) {
            this.typeUnresolved.reportError("The variable " + this.getIdentNode() + " has an unknown type " + this.typeUnresolved + ".");
            return false;
        }
        if (!declNode.resolve()) {
            return false;
        }
        this.type = declNode.getDeclType();
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.modifier != null) {
            if (this.type.isValueType() && !this.modifier.equals("var")) {
                this.reportError("A var keyword is needed before a variable of value type (basic type, enum type, external type) (missing at " + this.getIdentNode() + " of type " + this.type.toStringWithDeclarationCoords() + ").");
                return false;
            }
            if (this.type.isReferenceType() && !this.modifier.equals("ref")) {
                this.reportError("A ref keyword is needed before a variable of reference type (container type, match type, object class type, transient object class type) (missing at " + this.getIdentNode() + " of type " + this.type.toStringWithDeclarationCoords() + ").");
                return false;
            }
        }
        if (this.initialization == null) {
            return true;
        }
        TypeNode typeNode = this.getDeclType();
        TypeNode typeNode2 = this.initialization.getType();
        if (typeNode2.isEqual(typeNode)) {
            return true;
        }
        this.initialization = this.becomeParent(this.initialization.adjustType(typeNode, this.getCoords()));
        return this.initialization != ConstNode.getInvalid();
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    public static String getKindStr() {
        return "variable";
    }

    public Variable getVariable() {
        return this.checkIR(Variable.class);
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return (Variable)this.getIR();
        }
        Variable variable = new Variable("Var", this.getIdentNode().getIdent(), this.type.getType(), this.defEntityToBeYieldedTo, this.directlyNestingLHSGraph != null ? this.directlyNestingLHSGraph.getPatternGraph() : null, this.context, this.lambdaExpressionVariable);
        this.setIR(variable);
        if (this.initialization != null) {
            this.initialization = this.initialization.evaluate();
            variable.setInitialization(this.initialization.checkIR(Expression.class));
        }
        return variable;
    }
}

