/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.InvalidConstNode;
import de.unika.ipd.grgen.ast.expr.OperatorNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public abstract class ConstNode
extends OperatorNode {
    protected Object value;
    protected String name;
    private static final ConstNode INVALID = new InvalidConstNode(Coords.getBuiltin(), "invalid const", "invalid value");

    public static final ConstNode getInvalid() {
        return INVALID;
    }

    public ConstNode(Coords coords, String string, Object object) {
        super(coords, OperatorDeclNode.Operator.CONST);
        this.value = object;
        this.name = string;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return OperatorDeclNode.getName(this.getOperator()) + " " + this.value.toString();
    }

    @Override
    public String getNodeLabel() {
        return this.toString();
    }

    protected Constant getConstant() {
        return this.checkIR(Constant.class);
    }

    @Override
    protected IR constructIR() {
        return new Constant(this.getType().getType(), this.value);
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.errorType;
    }

    public final ConstNode castTo(TypeNode typeNode) {
        ConstNode constNode = ConstNode.getInvalid();
        try {
            if (this.getType().isEqual(typeNode)) {
                constNode = this;
            } else if (this.getType().isCastableTo(typeNode)) {
                constNode = this.doCastTo(typeNode);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.reportError("The cast from " + this.toString() + " to type " + typeNode.toStringWithDeclarationCoords() + " is failing.");
        }
        return constNode;
    }

    protected abstract ConstNode doCastTo(TypeNode var1);
}

