/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ContainerInitNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public abstract class ContainerSingleElementInitNode
extends ContainerInitNode {
    protected CollectNode<ExprNode> containerItems = new CollectNode();

    public ContainerSingleElementInitNode(Coords coords) {
        super(coords);
    }

    public void addItem(ExprNode exprNode) {
        this.containerItems.addChild(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<CollectNode<ExprNode>> vector = new Vector<CollectNode<ExprNode>>();
        vector.add(this.containerItems);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("containerItems");
        return vector;
    }

    protected boolean checkContainerItems() {
        boolean bl = true;
        TypeNode typeNode = this.getContainerType().getElementType();
        for (ExprNode exprNode : this.containerItems.getChildren()) {
            if (exprNode.getType() == typeNode) continue;
            if (!this.isInitInModel()) {
                ExprNode exprNode2 = exprNode;
                ExprNode exprNode3 = exprNode.adjustType(typeNode, this.getCoords());
                this.containerItems.replace(exprNode2, exprNode3);
                if (exprNode3 != ConstNode.getInvalid()) continue;
                bl = false;
                exprNode2.reportError("The value type " + exprNode2.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the value type " + typeNode.toStringWithDeclarationCoords() + " of the container (" + this.getContainerType().getTypeName() + ").");
                continue;
            }
            bl = false;
            exprNode.reportError("The value type " + exprNode.getType().toStringWithDeclarationCoords() + " of the initializer does not fit to the value type " + typeNode.toStringWithDeclarationCoords() + " of the container (" + this.getContainerType().getTypeName() + " -- all items must be of exactly the same type).");
        }
        return bl;
    }

    public boolean isConstant() {
        for (ExprNode exprNode : this.containerItems.getChildren()) {
            if (exprNode instanceof ConstNode || ContainerSingleElementInitNode.isEnumValue(exprNode)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ConstNode constNode) {
        for (ExprNode exprNode : this.containerItems.getChildren()) {
            if (!(exprNode instanceof ConstNode)) continue;
            ConstNode constNode2 = (ConstNode)exprNode;
            if (!constNode.getValue().equals(constNode2.getValue())) continue;
            return true;
        }
        return false;
    }

    protected CollectNode<ExprNode> getItems() {
        return this.containerItems;
    }

    protected Vector<Expression> constructItems() {
        Vector<Expression> vector = new Vector<Expression>();
        for (ExprNode exprNode : this.containerItems.getChildren()) {
            exprNode = exprNode.evaluate();
            vector.add(exprNode.checkIR(Expression.class));
        }
        return vector;
    }

    static {
        ContainerSingleElementInitNode.setName(ContainerSingleElementInitNode.class, "container single element init");
    }
}

