/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.decl.EnumItemDeclNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.EnumExpression;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class EnumExprNode
extends QualIdentNode {
    private EnumTypeNode owner;
    private EnumItemDeclNode member;
    private static final DeclarationTypeResolver<EnumTypeNode> ownerResolver;
    private static final DeclarationResolver<EnumItemDeclNode> memberResolver;

    public EnumExprNode(Coords coords, IdentNode identNode, IdentNode identNode2) {
        super(coords, identNode, identNode2);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.ownerUnresolved, this.owner));
        vector.add(this.getValidVersion(this.memberUnresolved, this.member));
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        this.owner = (EnumTypeNode)ownerResolver.resolve(this.ownerUnresolved, this);
        boolean bl2 = bl = this.owner != null && bl;
        if (this.owner != null) {
            this.owner.fixupDefinition(this.memberUnresolved);
            this.member = (EnumItemDeclNode)memberResolver.resolve(this.memberUnresolved, this);
            bl = this.member != null && bl;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public EnumItemDeclNode getDecl() {
        assert (this.isResolved());
        return this.member;
    }

    @Override
    public DeclNode getOwner() {
        assert (this.isResolved());
        return DeclNode.getInvalid();
    }

    @Override
    protected IR constructIR() {
        EnumType enumType = this.owner.checkIR(EnumType.class);
        EnumItem enumItem = this.member.checkIR(EnumItem.class);
        return new EnumExpression(enumType, enumItem);
    }

    static {
        EnumExprNode.setName(EnumExprNode.class, "enum access expression");
        ownerResolver = new DeclarationTypeResolver<EnumTypeNode>(EnumTypeNode.class);
        memberResolver = new DeclarationResolver<EnumItemDeclNode>(EnumItemDeclNode.class);
    }
}

