/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.expr.ArithmeticOperatorNode;
import de.unika.ipd.grgen.ast.expr.CastNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.DeclExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.InvalidExprNode;
import de.unika.ipd.grgen.ast.expr.OperatorNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.NullTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ObjectTypeNode;
import de.unika.ipd.grgen.ast.type.basic.TypeTypeNode;
import de.unika.ipd.grgen.parser.Coords;
import java.awt.Color;
import java.util.Set;
import java.util.Vector;

public abstract class ExprNode
extends BaseNode {
    private static final ExprNode INVALID;

    public ExprNode(Coords coords) {
        super(coords);
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    public static ExprNode getInvalid() {
        return INVALID;
    }

    @Override
    public Color getNodeColor() {
        return Color.PINK;
    }

    public abstract TypeNode getType();

    protected ExprNode adjustType(TypeNode typeNode) {
        TypeNode typeNode2 = this.getType();
        if (typeNode2.isEqual(typeNode) || typeNode2 instanceof NodeTypeNode && typeNode instanceof TypeTypeNode || typeNode2 instanceof EdgeTypeNode && typeNode instanceof TypeTypeNode) {
            return this;
        }
        if (typeNode instanceof MatchTypeNode && typeNode2 instanceof NullTypeNode) {
            return this;
        }
        if (typeNode2.isCompatibleTo(typeNode)) {
            return new CastNode(this.getCoords(), typeNode, this, this);
        }
        for (TypeNode typeNode3 : typeNode2.getCompatibleToTypes()) {
            if (!typeNode3.isCompatibleTo(typeNode) || typeNode3 == BasicTypeNode.untypedType) continue;
            return new CastNode(this.getCoords(), typeNode, new CastNode(this.getCoords(), typeNode3, this, this), this);
        }
        if (typeNode2 instanceof ExternalObjectTypeNode && typeNode instanceof ObjectTypeNode) {
            return new CastNode(this.getCoords(), typeNode, this, this);
        }
        return ConstNode.getInvalid();
    }

    public ExprNode adjustType(TypeNode typeNode, Coords coords) {
        ExprNode exprNode = this.adjustType(typeNode);
        if (exprNode == ConstNode.getInvalid()) {
            TypeNode typeNode2 = this.getType();
            String string = typeNode2.isCastableTo(typeNode) ? "Assignment of " + typeNode2.toStringWithDeclarationCoords() + " to " + typeNode.toStringWithDeclarationCoords() + " without a cast." : "Incompatible assignment from " + typeNode2.toStringWithDeclarationCoords() + " to " + typeNode.toStringWithDeclarationCoords() + ".";
            error.error(coords, string);
            if (typeNode2.toString().equals(typeNode.toString())) {
                error.warning(coords, "Check package prefix.");
            }
        }
        return exprNode;
    }

    public ExprNode evaluate() {
        return this;
    }

    public boolean noDefElement(String string) {
        boolean bl = true;
        for (BaseNode baseNode : this.getChildren()) {
            if (baseNode instanceof ExprNode) {
                bl &= ((ExprNode)baseNode).noDefElement(string);
                continue;
            }
            if (!(baseNode instanceof CollectNode)) continue;
            bl &= ((CollectNode)baseNode).noDefElement(string);
        }
        return bl;
    }

    public boolean noIteratedReference(String string) {
        boolean bl = true;
        for (BaseNode baseNode : this.getChildren()) {
            if (baseNode instanceof ExprNode) {
                bl &= ((ExprNode)baseNode).noIteratedReference(string);
                continue;
            }
            if (!(baseNode instanceof CollectNode)) continue;
            bl &= ((CollectNode)baseNode).noIteratedReference(string);
        }
        return bl;
    }

    public boolean iteratedNotReferenced(String string) {
        boolean bl = true;
        for (BaseNode baseNode : this.getChildren()) {
            if (baseNode instanceof ExprNode) {
                bl &= ((ExprNode)baseNode).iteratedNotReferenced(string);
                continue;
            }
            if (!(baseNode instanceof CollectNode)) continue;
            bl &= ((CollectNode)baseNode).iteratedNotReferenced(string);
        }
        return bl;
    }

    public static IdentNode getEdgeRootOfMatchingDirectedness(ExprNode exprNode) {
        IdentExprNode identExprNode = (IdentExprNode)exprNode;
        TypeNode typeNode = identExprNode.getType();
        if (typeNode.isCompatibleTo(EdgeTypeNode.directedEdgeType)) {
            return EdgeTypeNode.directedEdgeType.getIdentNode();
        }
        if (typeNode.isCompatibleTo(EdgeTypeNode.undirectedEdgeType)) {
            return EdgeTypeNode.undirectedEdgeType.getIdentNode();
        }
        return EdgeTypeNode.arbitraryEdgeType.getIdentNode();
    }

    public static IdentNode getEdgeRoot() {
        return EdgeTypeNode.arbitraryEdgeType.getIdentNode();
    }

    public static IdentNode getNodeRoot(ExprNode exprNode) {
        return NodeTypeNode.nodeType.getIdentNode();
    }

    public static IdentNode getNodeRoot() {
        return NodeTypeNode.nodeType.getIdentNode();
    }

    protected boolean checkCopyConstructorTypes(TypeNode typeNode, TypeNode typeNode2, String string, boolean bl) {
        String string2 = "";
        if (string.equals("map")) {
            string2 = bl ? " key" : " value";
        }
        String string3 = "The " + string + " copy constructor expects a(n) " + string + string2 + " of type " + typeNode.getTypeName() + " but is given a(n) " + string + string2 + " of type " + typeNode2.getTypeName();
        if (typeNode instanceof NodeTypeNode && !(typeNode2 instanceof NodeTypeNode)) {
            this.reportError(string3 + " (which is not a node type).");
            return false;
        }
        if (typeNode instanceof EdgeTypeNode && !(typeNode2 instanceof EdgeTypeNode)) {
            this.reportError(string3 + " (which is not an edge type).");
            return false;
        }
        if (!(typeNode instanceof NodeTypeNode) && !(typeNode instanceof EdgeTypeNode)) {
            if (typeNode2 instanceof NodeTypeNode || typeNode2 instanceof EdgeTypeNode) {
                this.reportError(string3 + ".");
                return false;
            }
            if (!typeNode.isEqual(typeNode2)) {
                this.reportError(string3 + ".");
                return false;
            }
        }
        return true;
    }

    public void collectElements(Set<ConstraintDeclNode> set) {
        Object object;
        assert (this.isResolved());
        if (this instanceof DeclExprNode && (object = ((DeclExprNode)this).getConstraintDeclNode()) != null) {
            set.add((ConstraintDeclNode)object);
        }
        for (BaseNode baseNode : this.getChildren()) {
            if (baseNode instanceof ExprNode) {
                ((ExprNode)baseNode).collectElements(set);
                continue;
            }
            if (!(baseNode instanceof CollectNode)) continue;
            CollectNode collectNode = (CollectNode)baseNode;
            for (BaseNode baseNode2 : collectNode.getChildren()) {
                if (!(baseNode2 instanceof ExprNode)) continue;
                ((ExprNode)baseNode2).collectElements(set);
            }
        }
    }

    public void getPotentiallyResultingElements(Set<ConstraintDeclNode> set) {
        BaseNode baseNode;
        assert (this.isResolved());
        if (this instanceof DeclExprNode && (baseNode = ((DeclExprNode)this).getConstraintDeclNode()) != null) {
            set.add((ConstraintDeclNode)baseNode);
        }
        if (this instanceof ArithmeticOperatorNode && ((OperatorNode)(baseNode = (ArithmeticOperatorNode)this)).getOperator() == OperatorDeclNode.Operator.COND) {
            ((ExprNode)((Vector)((ArithmeticOperatorNode)baseNode).getChildren()).get(1)).getPotentiallyResultingElements(set);
            ((ExprNode)((Vector)((ArithmeticOperatorNode)baseNode).getChildren()).get(2)).getPotentiallyResultingElements(set);
        }
    }

    static {
        ExprNode.setName(ExprNode.class, "expression");
        INVALID = new InvalidExprNode();
    }
}

