/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.AttributeInitializationNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.BaseInternalObjectTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.AttributeInitialization;
import de.unika.ipd.grgen.ir.expr.InternalObjectInit;
import de.unika.ipd.grgen.ir.model.type.BaseInternalObjectType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ObjectInitNode
extends ExprNode {
    private IdentNode objectTypeUnresolved;
    private BaseInternalObjectTypeNode objectType;
    CollectNode<AttributeInitializationNode> attributeInits = new CollectNode();
    private static final DeclarationTypeResolver<BaseInternalObjectTypeNode> objectTypeResolver;

    public ObjectInitNode(Coords coords, IdentNode identNode) {
        super(coords);
        this.objectTypeUnresolved = identNode;
    }

    public void addAttributeInitialization(AttributeInitializationNode attributeInitializationNode) {
        this.attributeInits.addChild(attributeInitializationNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.attributeInits);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("attributeInits");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.objectType = (BaseInternalObjectTypeNode)objectTypeResolver.resolve(this.objectTypeUnresolved, this);
        return this.objectType != null && this.objectType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getObjectType();
    }

    public BaseInternalObjectTypeNode getObjectType() {
        assert (this.isResolved());
        return this.objectType;
    }

    @Override
    protected IR constructIR() {
        BaseInternalObjectType baseInternalObjectType = this.objectType.checkIR(BaseInternalObjectType.class);
        InternalObjectInit internalObjectInit = new InternalObjectInit(baseInternalObjectType);
        for (AttributeInitializationNode attributeInitializationNode : this.attributeInits.getChildren()) {
            attributeInitializationNode.objectInitIR = internalObjectInit;
            internalObjectInit.addAttributeInitialization(attributeInitializationNode.checkIR(AttributeInitialization.class));
        }
        return internalObjectInit;
    }

    public InternalObjectInit getObjectInit() {
        return this.checkIR(InternalObjectInit.class);
    }

    public static String getKindStr() {
        return "internal (transient) object initialization";
    }

    static {
        ObjectInitNode.setName(ObjectInitNode.class, "internal (transient) object init");
        objectTypeResolver = new DeclarationTypeResolver<BaseInternalObjectTypeNode>(BaseInternalObjectTypeNode.class);
    }
}

