/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ByteTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ShortTypeNode;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Vector;

public abstract class OperatorNode
extends ExprNode {
    private OperatorDeclNode.Operator operator;
    private OperatorDeclNode operatorDecl;
    public Vector<ExprNode> children = new Vector();

    public OperatorNode(Coords coords, OperatorDeclNode.Operator operator) {
        super(coords);
        this.operator = operator;
    }

    public void addChild(ExprNode exprNode) {
        this.becomeParent(exprNode);
        this.children.add(exprNode);
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        TypeNode typeNode = this.getType();
        int n = OperatorDeclNode.getArity(this.operator);
        if (this.children.size() != n) {
            this.reportError("Wrong operator arity: " + this.children.size() + " (for " + OperatorDeclNode.getName(this.operator) + " expecting " + n + " operands).");
            bl = false;
        }
        if (typeNode.isEqual(BasicTypeNode.errorType)) {
            bl = false;
        }
        return bl;
    }

    private OperatorDeclNode computeOperator() {
        BaseNode baseNode;
        OperatorDeclNode operatorDeclNode = null;
        Vector<TypeNode> vector = new Vector<TypeNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            ExprNode exprNode = this.children.get(i);
            baseNode = exprNode.getType();
            if ((baseNode instanceof ByteTypeNode || baseNode instanceof ShortTypeNode) && this.children.size() < 3) {
                baseNode = BasicTypeNode.intType;
            }
            vector.add((TypeNode)baseNode);
        }
        operatorDeclNode = OperatorDeclNode.getNearestOperator(this.operator, vector);
        if (!operatorDeclNode.isValid()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            stringBuffer.append('(');
            for (int i = 0; i < this.children.size(); ++i) {
                if (vector.get(i).isEqual(BasicTypeNode.errorType)) {
                    bl = true;
                    continue;
                }
                stringBuffer.append((i > 0 ? ", " : "") + vector.get(i).toString());
            }
            stringBuffer.append(')');
            if (!bl) {
                this.reportError("The operator " + OperatorDeclNode.getName(this.operator) + stringBuffer + " is not known.");
            }
        } else {
            TypeNode[] typeNodeArray = operatorDeclNode.getOperandTypes();
            assert (typeNodeArray.length == vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i).isEqual(typeNodeArray[i])) continue;
                baseNode = this.children.get(i);
                ExprNode exprNode = ((ExprNode)baseNode).adjustType(typeNodeArray[i]);
                this.becomeParent(exprNode);
                this.children.set(i, exprNode);
            }
        }
        return operatorDeclNode;
    }

    public final OperatorDeclNode getOperatorDecl() {
        if (this.operatorDecl == null) {
            this.operatorDecl = this.computeOperator();
        }
        return this.operatorDecl;
    }

    public final OperatorDeclNode.Operator getOperator() {
        return this.operator;
    }

    @Override
    public TypeNode getType() {
        return this.getOperatorDecl().getResultType();
    }
}

