/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.ScanExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ScanExprNode
extends BuiltinFunctionInvocationBaseNode {
    private BaseNode typeUnresolved;
    private TypeNode type;
    private ExprNode stringExpr;
    protected static final DeclarationTypeResolver<TypeNode> typeResolver;

    public ScanExprNode(Coords coords, BaseNode baseNode, ExprNode exprNode) {
        super(coords);
        if (baseNode != null) {
            this.typeUnresolved = baseNode;
            this.becomeParent(this.typeUnresolved);
        }
        this.stringExpr = exprNode;
        this.becomeParent(this.stringExpr);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.stringExpr);
        if (this.typeUnresolved != null) {
            vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string expr");
        if (this.typeUnresolved != null) {
            vector.add("type");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = this.typeUnresolved == null ? BasicTypeNode.objectType : (TypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.stringExpr.getType() instanceof StringTypeNode)) {
            if (this.type != null) {
                this.reportError("The construct scan<" + this.type.getTypeName() + "> expects as argument a value of type string (but is given a value of type " + this.stringExpr.getType().getTypeName() + ").");
            } else {
                this.reportError("The construct scan expects as argument a value of type string (but is given a value of type " + this.stringExpr.getType().getTypeName() + ").");
            }
            return false;
        }
        if (this.type != null) {
            if (this.type instanceof InternalObjectTypeNode) {
                this.reportError("The construct scan<T> disallows a type argument containing a class object type (but is given " + this.type.getKind() + " " + this.type.getTypeName() + ").");
            } else if (this.type instanceof InternalTransientObjectTypeNode) {
                this.reportError("The construct scan<T> disallows a type argument containing a transient class object type (but is given " + this.type.getKind() + " " + this.type.getTypeName() + ").");
            }
            if (this.type instanceof ContainerTypeNode) {
                ContainerTypeNode containerTypeNode = (ContainerTypeNode)this.type;
                if (containerTypeNode.getElementType() instanceof InternalObjectTypeNode) {
                    this.reportError("The construct scan<T> disallows a type argument (of a container type) containing a class object type (but is given type " + this.type.getTypeName() + ").");
                } else if (containerTypeNode.getElementType() instanceof InternalTransientObjectTypeNode) {
                    this.reportError("The construct scan<T> disallows a type argument (of a container type) containing a transient class object type (but is given type " + this.type.getTypeName() + ").");
                }
                if (this.type instanceof MapTypeNode) {
                    MapTypeNode mapTypeNode = (MapTypeNode)this.type;
                    if (mapTypeNode.keyType instanceof InternalObjectTypeNode) {
                        this.reportError("The construct scan<T> disallows a type argument (of a container type) containing a class object type (but is given type " + this.type.getTypeName() + ").");
                    } else if (mapTypeNode.keyType instanceof InternalTransientObjectTypeNode) {
                        this.reportError("The construct scan<T> disallows a type argument (of a container type) containing a transient class object type (but is given type " + this.type.getTypeName() + ").");
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        return new ScanExpr(this.stringExpr.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        if (this.type != null) {
            return this.type;
        }
        return BasicTypeNode.objectType;
    }

    static {
        ScanExprNode.setName(ScanExprNode.class, "scan expr");
        typeResolver = new DeclarationTypeResolver<TypeNode>(TypeNode.class);
    }
}

