/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayAsString;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayAsStringNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private ExprNode valueExpr;

    public ArrayAsStringNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, exprNode);
        this.valueExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.valueExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("valueExpr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.targetExpr.getType().resolve();
        return true;
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof StringTypeNode)) {
            this.targetExpr.reportError("The array function method asString can only be employed on an object of type array<string> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        TypeNode typeNode = this.valueExpr.getType();
        if (!typeNode.isEqual(BasicTypeNode.stringType)) {
            this.valueExpr.reportError("The array function method asString expects as argument a value of type string (but is given a value of type " + typeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.stringType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayAsString(this.targetExpr.checkIR(Expression.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        ArrayAsStringNode.setName(ArrayAsStringNode.class, "array asString");
    }
}

