/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayExtract;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayExtractNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private IdentNode attribute;
    private DeclNode member;
    private ArrayTypeNode extractedArrayType;

    public ArrayExtractNode(Coords coords, ExprNode exprNode, IdentNode identNode) {
        super(coords, exprNode);
        this.attribute = identNode;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = this.targetExpr.resolve();
        if (!bl) {
            return false;
        }
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof InheritanceTypeNode) && !(arrayTypeNode.valueType instanceof MatchTypeNode)) {
            this.targetExpr.reportError("The array function method extract can only be employed on an object of type array<match<T>, match<T.S>, match<class T>, array<T> where T extends node/edge> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        TypeNode typeNode = arrayTypeNode.valueType;
        this.member = Resolver.resolveMember(typeNode, this.attribute);
        if (this.member == null) {
            return false;
        }
        TypeNode typeNode2 = this.getTypeOfElementToBeExtracted();
        if (!(typeNode2 instanceof DeclaredTypeNode) || typeNode2 instanceof ContainerTypeNode || typeNode2 instanceof MatchTypeNode) {
            this.reportError("The type " + typeNode2.getTypeName() + " of the element to be extracted is not an allowed type (basic type or node or edge class - set, map, array, deque, and match are forbidden).");
            return false;
        }
        DeclaredTypeNode declaredTypeNode = (DeclaredTypeNode)typeNode2;
        this.extractedArrayType = new ArrayTypeNode(declaredTypeNode.getIdentNode());
        return this.extractedArrayType.resolve();
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.extractedArrayType;
    }

    private TypeNode getTypeOfElementToBeExtracted() {
        if (this.member != null) {
            return this.member.getDeclType();
        }
        return null;
    }

    @Override
    protected IR constructIR() {
        Entity entity = null;
        if (this.member != null) {
            entity = this.member.checkIR(Entity.class);
        }
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayExtract(this.targetExpr.checkIR(Expression.class), this.extractedArrayType.checkIR(ArrayType.class), entity);
    }

    static {
        ArrayExtractNode.setName(ArrayExtractNode.class, "array extract");
    }
}

