/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayIndexOfByExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayIndexOfByNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private IdentNode attribute;
    private DeclNode member;
    private ExprNode valueExpr;
    private ExprNode startIndexExpr;

    public ArrayIndexOfByNode(Coords coords, ExprNode exprNode, IdentNode identNode, ExprNode exprNode2) {
        super(coords, exprNode);
        this.attribute = identNode;
        this.valueExpr = this.becomeParent(exprNode2);
    }

    public ArrayIndexOfByNode(Coords coords, ExprNode exprNode, IdentNode identNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords, exprNode);
        this.attribute = identNode;
        this.valueExpr = this.becomeParent(exprNode2);
        this.startIndexExpr = this.becomeParent(exprNode3);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.valueExpr);
        if (this.startIndexExpr != null) {
            vector.add(this.startIndexExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("valueExpr");
        if (this.startIndexExpr != null) {
            vector.add("startIndex");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof InheritanceTypeNode) && !(arrayTypeNode.valueType instanceof MatchTypeNode)) {
            this.targetExpr.reportError("The array function method indexOfBy can only be employed on an object of type array<nodes, edges, class objects, transient class objects, match types, match class types> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        this.member = Resolver.resolveMember(arrayTypeNode.valueType, this.attribute);
        if (this.member == null) {
            return false;
        }
        TypeNode typeNode = this.member.getDeclType();
        TypeNode typeNode2 = this.valueExpr.getType();
        if (!typeNode2.isEqual(typeNode)) {
            ExprNode exprNode = this.valueExpr;
            this.valueExpr = this.becomeParent(this.valueExpr.adjustType(typeNode, this.getCoords()));
            if (this.valueExpr == ConstNode.getInvalid()) {
                exprNode.reportError("The array function method indexOfBy expects as 1. argument (valueToSearchFor) a value of type " + typeNode.getTypeName() + " (but is given a value of type " + typeNode2.getTypeName() + ").");
                return false;
            }
        }
        if (this.startIndexExpr != null && !this.startIndexExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.startIndexExpr.reportError("The array function method indexOfBy expects as 2. argument (startIndex) a value of type int (but is given a value of type " + this.startIndexExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.valueExpr = this.valueExpr.evaluate();
        if (this.startIndexExpr != null) {
            this.startIndexExpr = this.startIndexExpr.evaluate();
            return new ArrayIndexOfByExpr(this.targetExpr.checkIR(Expression.class), this.member.checkIR(Entity.class), this.valueExpr.checkIR(Expression.class), this.startIndexExpr.checkIR(Expression.class));
        }
        return new ArrayIndexOfByExpr(this.targetExpr.checkIR(Expression.class), this.member.checkIR(Entity.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        ArrayIndexOfByNode.setName(ArrayIndexOfByNode.class, "array index of by");
    }
}

