/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ContainerSingleElementInitNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Vector;

public class ArrayInitNode
extends ContainerSingleElementInitNode {
    private BaseNode lhsUnresolved;
    private DeclNode lhs;
    private ArrayTypeNode arrayType;
    private static final MemberResolver<DeclNode> lhsResolver;

    public ArrayInitNode(Coords coords, IdentNode identNode, ArrayTypeNode arrayTypeNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.arrayType = arrayTypeNode;
        }
    }

    @Override
    protected boolean resolveLocal() {
        if (this.lhsUnresolved != null) {
            if (!lhsResolver.resolve(this.lhsUnresolved)) {
                return false;
            }
            this.lhs = lhsResolver.getResult(DeclNode.class);
            return lhsResolver.finish();
        }
        if (this.arrayType == null) {
            this.arrayType = this.createArrayType();
        }
        return this.arrayType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = this.checkContainerItems();
        if (!this.isConstant() && this.lhs != null) {
            this.reportError("Only constant items are allowed in an array initialization in the model.");
            bl = false;
        }
        return bl;
    }

    protected ArrayTypeNode createArrayType() {
        TypeNode typeNode = ((ExprNode)this.containerItems.getChildren().iterator().next()).getType();
        IdentNode identNode = ((DeclaredTypeNode)typeNode).getIdentNode();
        return new ArrayTypeNode(identNode);
    }

    @Override
    public ArrayTypeNode getContainerType() {
        assert (this.isResolved());
        if (this.lhs != null) {
            TypeNode typeNode = this.lhs.getDeclType();
            return (ArrayTypeNode)typeNode;
        }
        return this.arrayType;
    }

    @Override
    public boolean isInitInModel() {
        return this.arrayType == null;
    }

    public ExprNode getAtIndex(ConstNode constNode) {
        Integer n = (Integer)constNode.getValue();
        if (n < 0) {
            return null;
        }
        if (n >= this.containerItems.size()) {
            return null;
        }
        return (ExprNode)this.containerItems.getChildrenAsVector().get(n);
    }

    @Override
    protected IR constructIR() {
        Vector<Expression> vector = this.constructItems();
        Entity entity = this.lhs != null ? this.lhs.getEntity() : null;
        ArrayType arrayType = this.arrayType != null ? this.arrayType.checkIR(ArrayType.class) : null;
        return new ArrayInit(vector, entity, arrayType, this.isConstant());
    }

    public ArrayInit getArrayInit() {
        return this.checkIR(ArrayInit.class);
    }

    public static String getKindStr() {
        return "array initialization";
    }

    static {
        ArrayInitNode.setName(ArrayInitNode.class, "array init");
        lhsResolver = new MemberResolver();
    }
}

