/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayMapStartWithAccumulateByExpr;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class ArrayMapStartWithAccumulateByNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private IdentNode resultValueTypeUnresolved;
    private TypeNode resultValueType;
    private VarDeclNode initArrayAccessVar;
    private ExprNode initExpr;
    private VarDeclNode arrayAccessVar;
    private VarDeclNode previousAccumulationAccessVar;
    private VarDeclNode indexVar;
    private VarDeclNode elementVar;
    private ExprNode mappingExpr;
    private ArrayTypeNode resultArrayType;
    private static final DeclarationResolver<TypeDeclNode> typeResolver;

    public ArrayMapStartWithAccumulateByNode(Coords coords, ExprNode exprNode, IdentNode identNode, VarDeclNode varDeclNode, ExprNode exprNode2, VarDeclNode varDeclNode2, VarDeclNode varDeclNode3, VarDeclNode varDeclNode4, VarDeclNode varDeclNode5, ExprNode exprNode3) {
        super(coords, exprNode);
        this.resultValueTypeUnresolved = identNode;
        this.initArrayAccessVar = varDeclNode;
        this.initExpr = exprNode2;
        this.arrayAccessVar = varDeclNode2;
        this.previousAccumulationAccessVar = varDeclNode3;
        this.indexVar = varDeclNode4;
        this.elementVar = varDeclNode5;
        this.mappingExpr = exprNode3;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.targetExpr);
        if (this.initArrayAccessVar != null) {
            vector.add(this.initArrayAccessVar);
        }
        vector.add(this.initExpr);
        if (this.arrayAccessVar != null) {
            vector.add(this.arrayAccessVar);
        }
        vector.add(this.previousAccumulationAccessVar);
        if (this.indexVar != null) {
            vector.add(this.indexVar);
        }
        vector.add(this.elementVar);
        vector.add(this.mappingExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        if (this.initArrayAccessVar != null) {
            vector.add("initArrayAccessVar");
        }
        vector.add("initExpr");
        if (this.arrayAccessVar != null) {
            vector.add("arrayAccessVar");
        }
        vector.add("previousAccumulationAccessVar");
        if (this.indexVar != null) {
            vector.add("indexVar");
        }
        vector.add("elementVar");
        vector.add("mappingExpr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = this.targetExpr.resolve();
        if (!bl) {
            return false;
        }
        this.getTargetType();
        TypeDeclNode typeDeclNode = (TypeDeclNode)typeResolver.resolve(this.resultValueTypeUnresolved, this);
        if (typeDeclNode == null) {
            return false;
        }
        if (!typeDeclNode.resolve()) {
            return false;
        }
        this.resultValueType = typeDeclNode.getDeclType();
        if (!(this.resultValueType instanceof DeclaredTypeNode) || this.resultValueType instanceof ContainerTypeNode) {
            this.reportError("The type " + this.resultValueType.getTypeName() + " is not an allowed type - set, map, array, deque are forbidden.");
            return false;
        }
        DeclaredTypeNode declaredTypeNode = (DeclaredTypeNode)this.resultValueType;
        this.resultArrayType = new ArrayTypeNode(declaredTypeNode.getIdentNode());
        return this.resultArrayType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        Object object;
        Object object2;
        TypeNode typeNode = this.resultArrayType.valueType;
        TypeNode typeNode2 = this.initExpr.getType();
        TypeNode typeNode3 = this.mappingExpr.getType();
        if (this.initArrayAccessVar != null) {
            object2 = this.initArrayAccessVar.getDeclType();
            if (!(object2 instanceof ArrayTypeNode)) {
                this.reportError("The init array access variable of the array mapStartWithAccumulateBy function method must be of array type (but is of type " + ((TypeNode)object2).getTypeName() + ").");
                return false;
            }
            if (!((TypeNode)object2).isEqual(this.targetExpr.getType())) {
                this.reportError("The init array access variable of the array mapStartWithAccumulateBy function method must be of type " + this.targetExpr.getType().getTypeName() + " (but is of type " + ((TypeNode)object2).getTypeName() + ").");
                return false;
            }
        }
        if (!typeNode2.isEqual(typeNode)) {
            this.initExpr = this.becomeParent(this.initExpr.adjustType(this.resultValueType, this.getCoords()));
            if (this.initExpr == ConstNode.getInvalid()) {
                return false;
            }
            if (typeNode instanceof NodeTypeNode && typeNode2 instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof EdgeTypeNode) {
                object2 = new HashSet();
                typeNode2.doGetCompatibleToTypes((Collection<TypeNode>)object2);
                if (!object2.contains(typeNode)) {
                    this.reportError("Type mismatch in the array mapStartWithAccumulateBy function method between the init lambda expression value of type " + typeNode2.toStringWithDeclarationCoords() + " and the expected element type " + typeNode.toStringWithDeclarationCoords() + " of the resulting array.");
                    return false;
                }
            }
            if (typeNode instanceof NodeTypeNode && typeNode2 instanceof EdgeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof NodeTypeNode) {
                this.reportError("Type mismatch in the array mapStartWithAccumulateBy function method between the init lambda expression value of " + typeNode2.getKind() + " " + typeNode2.getTypeName() + " and the expected " + typeNode.getKind() + " element type " + typeNode.getTypeName() + " of the resulting array.");
                return false;
            }
        }
        if (this.arrayAccessVar != null) {
            object2 = this.arrayAccessVar.getDeclType();
            if (!(object2 instanceof ArrayTypeNode)) {
                this.reportError("The array access variable of the array mapStartWithAccumulateBy function method must be of array type (but is of type " + ((TypeNode)object2).getTypeName() + ").");
                return false;
            }
            if (!((TypeNode)object2).isEqual(this.targetExpr.getType())) {
                this.reportError("The array access variable of the array mapStartWithAccumulateBy function method must be of type " + this.targetExpr.getType().getTypeName() + " (but is of type " + ((TypeNode)object2).getTypeName() + ").");
                return false;
            }
        }
        if (!((TypeNode)(object2 = this.previousAccumulationAccessVar.getDeclType())).isEqual(this.resultValueType)) {
            this.reportError("The previous accumulation access variable of the array mapStartWithAccumulateBy function method must be of type " + this.resultValueType.getTypeName() + " (but is of type " + ((TypeNode)object2).getTypeName() + ").");
            return false;
        }
        if (this.indexVar != null && !((TypeNode)(object = this.indexVar.getDeclType())).isEqual(BasicTypeNode.intType)) {
            this.reportError("The index variable of the array mapStartWithAccumulateBy function method must be of int type (but is of type " + ((TypeNode)object).getTypeName() + ").");
            return false;
        }
        if (!typeNode3.isEqual(typeNode)) {
            this.mappingExpr = this.becomeParent(this.mappingExpr.adjustType(this.resultValueType, this.getCoords()));
            if (this.mappingExpr == ConstNode.getInvalid()) {
                return false;
            }
            if (typeNode instanceof NodeTypeNode && typeNode3 instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode && typeNode3 instanceof EdgeTypeNode) {
                object = new HashSet();
                typeNode3.doGetCompatibleToTypes((Collection<TypeNode>)object);
                if (!object.contains(typeNode)) {
                    this.reportError("Type mismatch in the array mapStartWithAccumulateBy function method between the lambda expression value of type " + typeNode3.toStringWithDeclarationCoords() + " and the expected element type " + typeNode.toStringWithDeclarationCoords() + " of the resulting array.");
                    return false;
                }
            }
            if (typeNode instanceof NodeTypeNode && typeNode3 instanceof EdgeTypeNode || typeNode instanceof EdgeTypeNode && typeNode3 instanceof NodeTypeNode) {
                this.reportError("Type mismatch in the array mapStartWithAccumulateBy function method between the lambda expression value of " + typeNode3.getKind() + " " + typeNode3.getTypeName() + " and the expected " + typeNode.getKind() + " element type " + typeNode.getTypeName() + " of the resulting array.");
                return false;
            }
        }
        object = this.elementVar.getDeclType();
        TypeNode typeNode4 = ((ArrayTypeNode)this.targetExpr.getType()).valueType;
        if (typeNode4 instanceof NodeTypeNode && object instanceof EdgeTypeNode || typeNode4 instanceof EdgeTypeNode && object instanceof NodeTypeNode) {
            this.reportError("Cannot bind the element variable of " + ((BaseNode)object).getKind() + " " + ((TypeNode)object).getTypeName() + " to a value of " + typeNode4.getKind() + " " + typeNode4.getTypeName() + " in the array mapStartWithAccumulateBy function method.");
            return false;
        }
        if (!typeNode4.isCompatibleTo((TypeNode)object)) {
            this.reportError("Cannot bind the element variable of type " + ((BaseNode)object).toStringWithDeclarationCoords() + " to a value of type " + typeNode4.toStringWithDeclarationCoords() + " in the array mapStartWithAccumulateBy function method.");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.resultArrayType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.mappingExpr = this.mappingExpr.evaluate();
        return new ArrayMapStartWithAccumulateByExpr(this.targetExpr.checkIR(Expression.class), this.initArrayAccessVar != null ? this.initArrayAccessVar.checkIR(Variable.class) : null, this.initExpr.checkIR(Expression.class), this.arrayAccessVar != null ? this.arrayAccessVar.checkIR(Variable.class) : null, this.previousAccumulationAccessVar != null ? this.previousAccumulationAccessVar.checkIR(Variable.class) : null, this.indexVar != null ? this.indexVar.checkIR(Variable.class) : null, this.elementVar.checkIR(Variable.class), this.mappingExpr.checkIR(Expression.class), this.resultArrayType.checkIR(ArrayType.class));
    }

    static {
        ArrayMapStartWithAccumulateByNode.setName(ArrayMapStartWithAccumulateByNode.class, "array map start with accumulate by");
        typeResolver = new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class);
    }
}

