/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayOrderAscending;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayOrderAscendingNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    public ArrayOrderAscendingNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!arrayTypeNode.valueType.isOrderableType()) {
            this.targetExpr.reportError("The array function method orderAscending can only be employed on an object of type array<" + TypeNode.getOrderableTypesAsString() + "> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getTargetType();
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayOrderAscending(this.targetExpr.checkIR(Expression.class));
    }

    static {
        ArrayOrderAscendingNode.setName(ArrayOrderAscendingNode.class, "array order ascending");
    }
}

