/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayPeekExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayPeekNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private ExprNode numberExpr;

    public ArrayPeekNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, exprNode);
        this.numberExpr = this.becomeParent(exprNode2);
    }

    public ArrayPeekNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        if (this.numberExpr != null) {
            vector.add(this.numberExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        if (this.numberExpr != null) {
            vector.add("numberExpr");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.numberExpr != null && !this.numberExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.numberExpr.reportError("The array function method peek expects as argument (number) a value of type int (but is given a value of type " + this.numberExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getTargetType().valueType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        if (this.numberExpr != null) {
            this.numberExpr = this.numberExpr.evaluate();
        }
        return new ArrayPeekExpr(this.targetExpr.checkIR(Expression.class), this.numberExpr != null ? this.numberExpr.checkIR(Expression.class) : null);
    }

    static {
        ArrayPeekNode.setName(ArrayPeekNode.class, "array peek");
    }
}

