/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArraySubarrayExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArraySubarrayNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private ExprNode startExpr;
    private ExprNode lengthExpr;

    public ArraySubarrayNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords, exprNode);
        this.startExpr = this.becomeParent(exprNode2);
        this.lengthExpr = this.becomeParent(exprNode3);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.startExpr);
        vector.add(this.lengthExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("startExpr");
        vector.add("lengthExpr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.startExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.startExpr.reportError("The array function method subarray expects as 1. argument (start position) a value of type int (but is given a value of type " + this.startExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.lengthExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.lengthExpr.reportError("The array function method subarray expects as 2. argument (length) a value of type int (but is given a value of type " + this.lengthExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getTargetType();
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.startExpr = this.startExpr.evaluate();
        this.lengthExpr = this.lengthExpr.evaluate();
        return new ArraySubarrayExpr(this.targetExpr.checkIR(Expression.class), this.startExpr.checkIR(Expression.class), this.lengthExpr.checkIR(Expression.class));
    }

    static {
        ArraySubarrayNode.setName(ArraySubarrayNode.class, "array subarray");
    }
}

