/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.deque;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeInitNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.deque.DequeCopyConstructor;
import de.unika.ipd.grgen.ir.type.container.DequeType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class DequeCopyConstructorNode
extends ExprNode {
    private DequeTypeNode dequeType;
    private ExprNode dequeToCopy;
    private BaseNode lhsUnresolved;

    public DequeCopyConstructorNode(Coords coords, IdentNode identNode, DequeTypeNode dequeTypeNode, ExprNode exprNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.dequeType = dequeTypeNode;
        }
        this.dequeToCopy = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.dequeToCopy);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("dequeToCopy");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.dequeType != null) {
            return this.dequeType.resolve();
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        if (this.lhsUnresolved != null) {
            this.reportError("A deque copy constructor is not allowed in a deque initialization in the model.");
            bl = false;
        } else if (this.dequeToCopy.getType() instanceof DequeTypeNode) {
            DequeTypeNode dequeTypeNode = (DequeTypeNode)this.dequeToCopy.getType();
            bl &= this.checkCopyConstructorTypes(this.dequeType.valueType, dequeTypeNode.valueType, "deque", false);
        } else {
            this.reportError("A deque copy constructor expects a value of deque type to copy (but is given " + this.dequeToCopy.getType().getTypeName() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.dequeType;
    }

    @Override
    protected IR constructIR() {
        this.dequeToCopy = this.dequeToCopy.evaluate();
        return new DequeCopyConstructor(this.dequeToCopy.checkIR(Expression.class), this.dequeType.checkIR(DequeType.class));
    }

    public static String getKindStr() {
        return "deque copy constructor";
    }

    static {
        DequeCopyConstructorNode.setName(DequeInitNode.class, "deque copy constructor");
    }
}

