/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.deque;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.deque.DequeLastIndexOfExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class DequeLastIndexOfNode
extends DequeFunctionMethodInvocationBaseExprNode {
    private ExprNode valueExpr;
    private ExprNode startIndexExpr;

    public DequeLastIndexOfNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, exprNode);
        this.valueExpr = this.becomeParent(exprNode2);
    }

    public DequeLastIndexOfNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords, exprNode);
        this.valueExpr = this.becomeParent(exprNode2);
        this.startIndexExpr = this.becomeParent(exprNode3);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.valueExpr);
        if (this.startIndexExpr != null) {
            vector.add(this.startIndexExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("valueExpr");
        if (this.startIndexExpr != null) {
            vector.add("startIndex");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.valueExpr.getType();
        DequeTypeNode dequeTypeNode = this.getTargetType();
        if (!typeNode.isEqual(dequeTypeNode.valueType)) {
            ExprNode exprNode = this.valueExpr;
            this.valueExpr = this.becomeParent(this.valueExpr.adjustType(dequeTypeNode.valueType, this.getCoords()));
            if (this.valueExpr == ConstNode.getInvalid()) {
                exprNode.reportError("The deque function method lastIndexOf expects as 1. argument (valueToSearchFor) a value of type " + dequeTypeNode.valueType.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
                return false;
            }
        }
        if (this.startIndexExpr != null && !this.startIndexExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.startIndexExpr.reportError("The deque function method lastIndexOf expects as 2. argument (startIndex) a value of type int (but is given a value of type " + this.startIndexExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.valueExpr = this.valueExpr.evaluate();
        if (this.startIndexExpr != null) {
            this.startIndexExpr = this.startIndexExpr.evaluate();
            return new DequeLastIndexOfExpr(this.targetExpr.checkIR(Expression.class), this.valueExpr.checkIR(Expression.class), this.startIndexExpr.checkIR(Expression.class));
        }
        return new DequeLastIndexOfExpr(this.targetExpr.checkIR(Expression.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        DequeLastIndexOfNode.setName(DequeLastIndexOfNode.class, "deque last index of");
    }
}

